/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.make;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.gradle.internal.impldep.aQute.bnd.osgi.Builder;
import org.gradle.internal.impldep.aQute.bnd.osgi.EmbeddedResource;
import org.gradle.internal.impldep.aQute.bnd.osgi.FileResource;
import org.gradle.internal.impldep.aQute.bnd.osgi.Resource;
import org.gradle.internal.impldep.aQute.bnd.service.MakePlugin;

public class MakeCopy
implements MakePlugin {
    @Override
    public Resource make(Builder builder, String destination, Map<String, String> argumentsOnMake) throws Exception {
        String type = argumentsOnMake.get("type");
        if (!type.equals("copy")) {
            return null;
        }
        String from = argumentsOnMake.get("from");
        if (from == null) {
            String content = argumentsOnMake.get("content");
            if (content == null) {
                throw new IllegalArgumentException("No 'from' or 'content' field in copy " + argumentsOnMake);
            }
            return new EmbeddedResource(content, 0L);
        }
        File f = builder.getFile(from);
        if (f.isFile()) {
            return new FileResource(f);
        }
        try {
            URL url = new URL(from);
            return Resource.fromURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Copy source does not exist " + from + " for destination " + destination);
        }
    }
}

