/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.header;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.aQute.bnd.header.Attrs;
import org.gradle.internal.impldep.aQute.bnd.header.OSGiHeader;
import org.gradle.internal.impldep.aQute.lib.collections.SortedList;
import org.gradle.internal.impldep.aQute.service.reporter.Reporter;

public class Parameters
implements Map<String, Attrs> {
    private final Map<String, Attrs> map;
    private final boolean allowDuplicateAttributes;

    public Parameters(boolean allowDuplicateAttributes) {
        this.allowDuplicateAttributes = allowDuplicateAttributes;
        this.map = new LinkedHashMap<String, Attrs>();
    }

    public Parameters() {
        this(false);
    }

    public Parameters(String header) {
        this(header, null);
    }

    public Parameters(String header, Reporter reporter) {
        this(false);
        OSGiHeader.parseHeader(header, reporter, this);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void add(String key, Attrs attrs) {
        while (this.containsKey(key)) {
            key = key + "~";
        }
        this.put(key, attrs);
    }

    public boolean containsKey(String name) {
        return this.map.containsKey(name);
    }

    @Override
    @Deprecated
    public boolean containsKey(Object name) {
        assert (name instanceof String);
        return this.map.containsKey(name);
    }

    public boolean containsValue(Attrs value) {
        return this.map.containsValue(value);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        assert (value instanceof Attrs);
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Attrs>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    @Deprecated
    public Attrs get(Object key) {
        assert (key instanceof String);
        return this.map.get(key);
    }

    public Attrs get(String key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    public List<String> keyList() {
        return this.keySet().stream().map(this::removeDuplicateMarker).collect(Collectors.toList());
    }

    @Override
    public Attrs put(String key, Attrs value) {
        assert (key != null);
        assert (value != null);
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Attrs> map) {
        this.map.putAll(map);
    }

    public void putAllIfAbsent(Map<String, ? extends Attrs> map) {
        for (Map.Entry<String, ? extends Attrs> entry : map.entrySet()) {
            if (this.containsKey(entry.getKey())) continue;
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Deprecated
    public Attrs remove(Object var0) {
        assert (var0 instanceof String);
        return this.map.remove(var0);
    }

    public Attrs remove(String var0) {
        return this.map.remove(var0);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Attrs> values() {
        return this.map.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb);
        return sb.toString();
    }

    public void append(StringBuilder sb) {
        String del = "";
        for (Map.Entry<String, Attrs> s : this.entrySet()) {
            sb.append(del);
            sb.append(this.removeDuplicateMarker(s.getKey()));
            if (!s.getValue().isEmpty()) {
                sb.append(';');
                s.getValue().append(sb);
            }
            del = ",";
        }
    }

    private String removeDuplicateMarker(String key) {
        int i;
        for (i = key.length() - 1; i >= 0 && key.charAt(i) == '~'; --i) {
        }
        return key.substring(0, i + 1);
    }

    @Override
    @Deprecated
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    @Deprecated
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isEqual(Parameters other) {
        SortedList lo;
        if (this == other) {
            return true;
        }
        if (other == null || this.size() != other.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        SortedList l = new SortedList(this.keySet());
        if (!l.isEqual(lo = new SortedList(other.keySet()))) {
            return false;
        }
        for (String key : this.keySet()) {
            Attrs valueo;
            Attrs value = this.get(key);
            if (value == (valueo = other.get(key)) || value != null && value.isEqual(valueo)) continue;
            return false;
        }
        return true;
    }

    public Map<String, ? extends Map<String, String>> asMapMap() {
        return this;
    }

    public void mergeWith(Parameters other, boolean override) {
        for (Map.Entry<String, Attrs> e : other.entrySet()) {
            Attrs existing = this.get(e.getKey());
            if (existing == null) {
                this.put(e.getKey(), new Attrs(e.getValue()));
                continue;
            }
            existing.mergeWith(e.getValue(), override);
        }
    }

    public boolean allowDuplicateAttributes() {
        return this.allowDuplicateAttributes;
    }

    public static Collector<String, Parameters, Parameters> toParameters() {
        return Collector.of(Parameters::new, Parameters::accumulator, Parameters::combiner, new Collector.Characteristics[0]);
    }

    private static void accumulator(Parameters p, String s) {
        OSGiHeader.parseHeader(s, null, p);
    }

    private static Parameters combiner(Parameters t, Parameters u) {
        t.mergeWith(u, true);
        return t;
    }
}

