/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.exporter.runbundles;

import java.io.File;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import org.gradle.internal.impldep.aQute.bnd.annotation.plugin.BndPlugin;
import org.gradle.internal.impldep.aQute.bnd.build.Container;
import org.gradle.internal.impldep.aQute.bnd.build.Project;
import org.gradle.internal.impldep.aQute.bnd.osgi.FileResource;
import org.gradle.internal.impldep.aQute.bnd.osgi.Jar;
import org.gradle.internal.impldep.aQute.bnd.osgi.JarResource;
import org.gradle.internal.impldep.aQute.bnd.osgi.Resource;
import org.gradle.internal.impldep.aQute.bnd.service.export.Exporter;
import org.gradle.internal.impldep.aQute.lib.strings.Strings;

@BndPlugin(name="exporter.runbundles")
public class RunbundlesExporter
implements Exporter {
    public static final String RUNBUNDLES = "bnd.runbundles";

    @Override
    public String[] getTypes() {
        return new String[]{RUNBUNDLES};
    }

    @Override
    public Map.Entry<String, Resource> export(String type, Project project, Map<String, String> options) throws Exception {
        project.prepare();
        Collection<Container> runbundles = project.getRunbundles();
        Jar jar = new Jar(project.getName());
        jar.setDoNotTouchManifest();
        for (Container container : runbundles) {
            File source = container.getFile();
            String path = this.nonCollidingPath(jar, source.getName());
            jar.putResource(path, new FileResource(source));
        }
        return new AbstractMap.SimpleEntry<String, Resource>(jar.getName(), new JarResource(jar, true));
    }

    private String nonCollidingPath(Jar jar, String fileName) {
        String[] parts = Strings.extension(fileName);
        if (parts == null) {
            parts = new String[]{fileName, ""};
        }
        int i = 1;
        while (jar.exists(fileName)) {
            fileName = String.format("%s[%d].%s", parts[0], i++, parts[1]);
        }
        return fileName;
    }
}

