/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.exporter.executable;

import java.util.AbstractMap;
import java.util.Map;
import org.gradle.internal.impldep.aQute.bnd.annotation.plugin.BndPlugin;
import org.gradle.internal.impldep.aQute.bnd.build.Project;
import org.gradle.internal.impldep.aQute.bnd.build.ProjectLauncher;
import org.gradle.internal.impldep.aQute.bnd.osgi.Jar;
import org.gradle.internal.impldep.aQute.bnd.osgi.JarResource;
import org.gradle.internal.impldep.aQute.bnd.osgi.Resource;
import org.gradle.internal.impldep.aQute.bnd.service.export.Exporter;
import org.gradle.internal.impldep.aQute.lib.converter.Converter;
import org.gradle.internal.impldep.aQute.lib.strings.Strings;

@BndPlugin(name="exporter.executablejar")
public class ExecutableJarExporter
implements Exporter {
    public static final String EXECUTABLE_JAR = "bnd.executablejar";

    @Override
    public String[] getTypes() {
        return new String[]{EXECUTABLE_JAR};
    }

    @Override
    public Map.Entry<String, Resource> export(String type, Project project, Map<String, String> options) throws Exception {
        Configuration configuration = Converter.cnv(Configuration.class, options);
        project.prepare();
        try (ProjectLauncher launcher = project.getProjectLauncher();){
            launcher.setKeep(configuration.keep());
            Jar jar = launcher.executable();
            project.getInfo(launcher);
            String name = jar.getName();
            String[] baseext = Strings.extension(name);
            if (baseext != null && ("bnd".equals(baseext[1]) || "bndrun".equals(baseext[1]))) {
                name = baseext[0];
            }
            name = name + ".jar";
            AbstractMap.SimpleEntry<String, Resource> simpleEntry = new AbstractMap.SimpleEntry<String, Resource>(name, new JarResource(jar, true));
            return simpleEntry;
        }
    }

    static interface Configuration {
        public boolean keep();
    }
}

