/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.aQute.bnd.compatibility;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;

public class Signatures {
    public String getSignature(Object c) throws Exception {
        if (c instanceof Class) {
            return this.getSignature((Class)c);
        }
        if (c instanceof Constructor) {
            return this.getSignature((Constructor)c);
        }
        if (c instanceof Method) {
            return this.getSignature((Method)c);
        }
        if (c instanceof Field) {
            return this.getSignature((Field)c);
        }
        throw new IllegalArgumentException(c.toString());
    }

    public String getSignature(Class<?> c) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.declaration(sb, c);
        this.reference(sb, c.getGenericSuperclass());
        for (Type type : c.getGenericInterfaces()) {
            this.reference(sb, type);
        }
        return sb.toString();
    }

    public String getSignature(Method m) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.declaration(sb, m);
        sb.append('(');
        for (Type type : m.getGenericParameterTypes()) {
            this.reference(sb, type);
        }
        sb.append(')');
        this.reference(sb, m.getGenericReturnType());
        return sb.toString();
    }

    public String getSignature(Constructor<?> c) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.declaration(sb, c);
        sb.append('(');
        for (Type type : c.getGenericParameterTypes()) {
            this.reference(sb, type);
        }
        sb.append(')');
        this.reference(sb, Void.TYPE);
        return sb.toString();
    }

    public String getSignature(Field f) throws Exception {
        StringBuilder sb = new StringBuilder();
        Type t = f.getGenericType();
        this.reference(sb, t);
        return sb.toString();
    }

    private void declaration(StringBuilder sb, GenericDeclaration gd) throws Exception {
        TypeVariable<?>[] typeParameters = gd.getTypeParameters();
        if (typeParameters.length > 0) {
            sb.append('<');
            for (TypeVariable<?> tv : typeParameters) {
                sb.append(tv.getName());
                Type[] bounds = tv.getBounds();
                if (bounds.length > 0 && this.isInterface(bounds[0])) {
                    sb.append(':');
                }
                for (Type bound : bounds) {
                    sb.append(':');
                    this.reference(sb, bound);
                }
            }
            sb.append('>');
        }
    }

    private boolean isInterface(Type type) throws Exception {
        if (type instanceof Class) {
            return ((Class)type).isInterface();
        }
        if (type instanceof ParameterizedType) {
            return this.isInterface(((ParameterizedType)type).getRawType());
        }
        return false;
    }

    private void reference(StringBuilder sb, Type t) throws Exception {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            sb.append('L');
            this.parameterizedType(sb, pt);
            sb.append(';');
            return;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)t;
            sb.append('[');
            this.reference(sb, gat.getGenericComponentType());
        } else if (t instanceof WildcardType) {
            WildcardType wt = (WildcardType)t;
            Type[] lowerBounds = wt.getLowerBounds();
            Type[] upperBounds = wt.getUpperBounds();
            if (upperBounds.length == 1 && upperBounds[0] == Object.class) {
                upperBounds = new Type[]{};
            }
            if (upperBounds.length != 0) {
                for (Type upper : upperBounds) {
                    sb.append('+');
                    this.reference(sb, upper);
                }
            } else if (lowerBounds.length != 0) {
                for (Type lower : lowerBounds) {
                    sb.append('-');
                    this.reference(sb, lower);
                }
            } else {
                sb.append('*');
            }
        } else if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            sb.append('T');
            sb.append(tv.getName());
            sb.append(';');
        } else if (t instanceof Class) {
            Class c = (Class)t;
            if (c.isPrimitive()) {
                sb.append(this.primitive(c));
            } else {
                sb.append('L');
                String name = c.getName().replace('.', '/');
                sb.append(name);
                sb.append(';');
            }
        }
    }

    private void parameterizedType(StringBuilder sb, ParameterizedType pt) throws Exception {
        String name = ((Class)pt.getRawType()).getName().replace('.', '/');
        Type owner = pt.getOwnerType();
        if (owner != null) {
            if (owner instanceof ParameterizedType) {
                this.parameterizedType(sb, (ParameterizedType)owner);
            } else {
                sb.append(((Class)owner).getName().replace('.', '/'));
            }
            sb.append('.');
            int n = name.lastIndexOf(36);
            name = name.substring(n + 1);
        }
        sb.append(name);
        sb.append('<');
        for (Type parameterType : pt.getActualTypeArguments()) {
            this.reference(sb, parameterType);
        }
        sb.append('>');
    }

    private char primitive(Class<?> type) {
        if (type == Byte.TYPE) {
            return 'B';
        }
        if (type == Character.TYPE) {
            return 'C';
        }
        if (type == Double.TYPE) {
            return 'D';
        }
        if (type == Float.TYPE) {
            return 'F';
        }
        if (type == Integer.TYPE) {
            return 'I';
        }
        if (type == Long.TYPE) {
            return 'J';
        }
        if (type == Short.TYPE) {
            return 'S';
        }
        if (type == Boolean.TYPE) {
            return 'Z';
        }
        if (type == Void.TYPE) {
            return 'V';
        }
        throw new IllegalArgumentException("Unknown primitive type " + type);
    }

    public String normalize(String signature) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        Rover rover = new Rover(signature);
        this.declare(sb, map, rover);
        if (rover.peek() == '(') {
            sb.append(rover.take('('));
            while (rover.peek() != ')') {
                this.reference(sb, map, rover, true);
            }
            sb.append(rover.take(')'));
            this.reference(sb, map, rover, true);
        } else {
            this.reference(sb, map, rover, true);
            while (!rover.isEOF()) {
                this.reference(sb, map, rover, true);
            }
        }
        return sb.toString();
    }

    private void reference(StringBuilder sb, Map<String, String> map, Rover rover, boolean primitivesAllowed) {
        char type = rover.take();
        sb.append(type);
        if (type == '[') {
            this.reference(sb, map, rover, true);
        } else if (type == 'L') {
            String fqnb = rover.upTo("<;.");
            sb.append(fqnb);
            this.body(sb, map, rover);
            while (rover.peek() == '.') {
                sb.append(rover.take('.'));
                sb.append(rover.upTo("<;."));
                this.body(sb, map, rover);
            }
            sb.append(rover.take(';'));
        } else if (type == 'T') {
            String name = rover.upTo(";");
            name = this.assign(map, name);
            sb.append(name);
            sb.append(rover.take(';'));
        } else if (!primitivesAllowed) {
            throw new IllegalStateException("Primitives are not allowed without an array");
        }
    }

    private void body(StringBuilder sb, Map<String, String> map, Rover rover) {
        if (rover.peek() == '<') {
            sb.append(rover.take('<'));
            while (rover.peek() != '>') {
                switch (rover.peek()) {
                    case 'L': 
                    case '[': {
                        this.reference(sb, map, rover, false);
                        break;
                    }
                    case 'T': {
                        sb.append(rover.take('T'));
                        String name = rover.upTo(";");
                        sb.append(this.assign(map, name));
                        sb.append(rover.take(';'));
                        break;
                    }
                    case '+': 
                    case '-': {
                        sb.append(rover.take());
                        this.reference(sb, map, rover, false);
                        break;
                    }
                    case '*': {
                        sb.append(rover.take());
                    }
                }
            }
            sb.append(rover.take('>'));
        }
    }

    private void declare(StringBuilder sb, Map<String, String> map, Rover rover) {
        char c = rover.peek();
        if (c == '<') {
            sb.append(rover.take('<'));
            while (rover.peek() != '>') {
                String name = rover.upTo(":");
                name = this.assign(map, name);
                sb.append(name);
                block4: while (rover.peek() == ':') {
                    sb.append(rover.take(':'));
                    switch (rover.peek()) {
                        case ':': {
                            continue block4;
                        }
                    }
                    this.reference(sb, map, rover, false);
                }
            }
            sb.append(rover.take('>'));
        }
    }

    private String assign(Map<String, String> map, String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        int n = map.size();
        map.put(name, "_" + n);
        return "_" + n;
    }

    static class Rover {
        final String s;
        int i;

        public Rover(String s) {
            this.s = s;
            this.i = 0;
        }

        char peek() {
            return this.s.charAt(this.i);
        }

        char take() {
            return this.s.charAt(this.i++);
        }

        char take(char c) {
            char x;
            if (c != (x = this.s.charAt(this.i++))) {
                throw new IllegalStateException("get() expected " + c + " but got + " + x);
            }
            return x;
        }

        public String upTo(String except) {
            int start = this.i;
            while (except.indexOf(this.peek()) < 0) {
                this.take();
            }
            return this.s.substring(start, this.i);
        }

        public boolean isEOF() {
            return this.i >= this.s.length();
        }
    }
}

