/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.banner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.gephi.desktop.banner.workspace.WorkspacePanel;
import org.gephi.perspective.api.PerspectiveController;
import org.gephi.perspective.spi.Perspective;
import org.gephi.ui.utils.UIUtils;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BannerComponent
extends JPanel {
    private transient JToggleButton[] buttons;
    private final transient PerspectiveController perspectiveController;
    private JLabel bannerBackground;
    private JPanel buttonsPanel;
    private JPanel groupsPanel;
    private JButton logoButton;
    private JPanel mainPanel;
    private ButtonGroup perspectivesButtonGroup;
    private JPanel workspacePanel;

    public BannerComponent() {
        this.initComponents();
        this.perspectiveController = (PerspectiveController)Lookup.getDefault().lookup(PerspectiveController.class);
        this.addGroupTabs();
        this.logoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        URI uri = new URI("http://gephi.org");
                        desktop.browse(uri);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
        this.setPreferredSize(new Dimension(100, 55 + (UIUtils.isAquaLookAndFeel() ? 10 : 0)));
    }

    private void addGroupTabs() {
        this.buttons = new JPerspectiveButton[this.perspectiveController.getPerspectives().length];
        int i = 0;
        for (final Perspective perspective : this.perspectiveController.getPerspectives()) {
            JPerspectiveButton toggleButton = new JPerspectiveButton(perspective.getDisplayName(), perspective.getIcon());
            toggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BannerComponent.this.perspectiveController.selectPerspective(perspective);
                }
            });
            this.perspectivesButtonGroup.add(toggleButton);
            this.buttonsPanel.add(toggleButton);
            this.buttons[i++] = toggleButton;
        }
        this.perspectivesButtonGroup.setSelected(this.buttons[this.getSelectedPerspectiveIndex()].getModel(), true);
    }

    public int getSelectedPerspectiveIndex() {
        int i = 0;
        for (Perspective p : this.perspectiveController.getPerspectives()) {
            if (p.equals(this.perspectiveController.getSelectedPerspective())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void initComponents() {
        this.perspectivesButtonGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.logoButton = new JButton();
        this.groupsPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.bannerBackground = new JLabel();
        this.workspacePanel = new WorkspacePanel();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
        this.mainPanel.setBackground(new Color(255, 255, 255));
        this.mainPanel.setLayout(new GridBagLayout());
        this.logoButton.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/banner/resources/logo_std.png")));
        this.logoButton.setToolTipText(NbBundle.getMessage(BannerComponent.class, (String)"BannerComponent.logoButton.toolTipText"));
        this.logoButton.setBorderPainted(false);
        this.logoButton.setContentAreaFilled(false);
        this.logoButton.setCursor(new Cursor(0));
        this.logoButton.setFocusPainted(false);
        this.logoButton.setHorizontalTextPosition(0);
        this.logoButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/banner/resources/logo_glow.png")));
        this.logoButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/banner/resources/logo_glow.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.mainPanel.add((Component)this.logoButton, gridBagConstraints);
        this.groupsPanel.setBackground(new Color(255, 255, 255));
        this.groupsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBackground(new Color(255, 255, 255));
        this.buttonsPanel.setCursor(new Cursor(0));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setPreferredSize(new Dimension(10, 50));
        this.buttonsPanel.setLayout(new FlowLayout(0, 3, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.groupsPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        this.bannerBackground.setIcon(new ImageIcon(this.getClass().getResource("/org/gephi/desktop/banner/resources/bannerback.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.groupsPanel.add((Component)this.bannerBackground, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.groupsPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
        this.add((Component)this.workspacePanel, "South");
    }

    private static class JPerspectiveButton
    extends JToggleButton {
        public JPerspectiveButton(String text, Icon icon) {
            this.setText(text);
            this.setBorder(null);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setHorizontalTextPosition(0);
            if (UIUtils.isWindowsLookAndFeel()) {
                this.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/vista-enabled.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
                this.setRolloverIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/vista-mousover.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
                this.setSelectedIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/vista-selected.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
            } else if (UIUtils.isAquaLookAndFeel()) {
                this.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/aqua-enabled.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
                this.setRolloverIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/aqua-mouseover.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
                this.setSelectedIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/aqua-selected.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
            } else {
                this.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/nimbus-enabled.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
                this.setRolloverIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/nimbus-mouseover.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
                this.setSelectedIcon(ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/gephi/desktop/banner/perspective/resources/nimbus-selected.png"), (Image)ImageUtilities.icon2Image((Icon)icon), (int)6, (int)3)));
            }
        }
    }
}

