function getWindowLocationSearch(win){"use strict";var search=(win||window).location.search;if(!search){var index=window.location.href.indexOf("?");-1!==index&&(search=window.location.href.substring(index))}return search||""}function getParameterByName(name,url){"use strict";name=name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var results=new RegExp("[\\?&]"+name+"=([^&#]*)","i").exec(url||getWindowLocationSearch());return null==results?"":decodeURIComponent(results[1].replace(/\+/g," "))}self.Intl||(self.Intl={}),self.Intl.NumberFormat||(self.Intl.NumberFormat=function(){},self.Intl.NumberFormat.prototype.format=function(value){"use strict";return value.toString()});var AppInfo={},Dashboard={isConnectMode:function(){"use strict";return null!=self.appMode},allowPluginPages:function(pluginId){"use strict";var allowedPluginConfigs=["b0daa30f-2e09-4083-a6ce-459d9fecdd80","de228f12-e43e-4bd9-9fc0-2830819c3b92","899c12c7-5b40-4c4e-9afd-afd74a685eb1","14f5f69e-4c8d-491b-8917-8e90e8317530","02528C96-F727-44D7-BE87-9EEF040758C3","dc372f99-4e0e-4c6b-8c18-2b887ca4530c","830fc68f-b964-4d2f-b139-48e22cd143c","b9f0c474-e9a8-4292-ae41-eb3c1542f4cd","7cfbb821-e8fd-40ab-b64e-a7749386a6b2","4C2FDA1C-FD5E-433A-AD2B-718E0B73E9A9","cd5a19be-7676-48ef-b64f-a17c98f2b889","b2ff6a63-303a-4a84-b937-6e12f87e3eb9","0277E613-3EC0-4360-A3DE-F8AF0AABB5E9","9464BD84-D30D-4404-B2AD-DFF4E12D5FC5","9574ac10-bf23-49bc-949f-924f23cfa48f","66fd72a4-7e8e-4f22-8d1c-022ce4b9b0d5","4DCB591C-0FA2-4C5D-A7E5-DABE37164C8B","8e791e2a-058a-4b12-8493-8bf69d92d685","577f89eb-58a7-4013-be06-9a970ddb1377","6153FDF0-40CC-4457-8730-3B4A19512BAE","de228f12-e43e-4bd9-9fc0-2830819c3b92","6C3B6965-C257-47C2-AA02-64457AE21D91","2FE79C34-C9DC-4D94-9DF2-2F3F36764414","0417264b-5a93-4ad0-a1f0-b87569b7cf80","e711475e-efad-431b-8527-033ba9873a34","AB95885A-1D0E-445E-BDBF-80C1912C98C5","F015EA06-B413-47F1-BF15-F049A799658B","986a7283-205a-4436-862d-23135c067f8a","8abc6789-fde2-4705-8592-4028806fa343","2850d40d-9c66-4525-aa46-968e8ef04e97","830fc68f-b964-4d2f-b139-48e22cd143c7","8D7D93B2-01DC-48DC-8C5D-4E7ABBD9F9EB","341944AF-4959-47E5-8ACE-398520208A71","3A63A9F3-810E-44F6-910A-14D6AD1255EC","E610BA80-9750-47BC-979D-3F0FC86E0081","C68856B8-6031-480D-B08E-43B9114ADDB2","7FB7FF5E-5407-4F74-8990-B7AA643085D2","3A63A9F3-810E-44F6-910A-14D6AD1255EC","0A70BB83-E28F-4633-923D-B87244697831","CEA173E8-8851-4B3B-B61D-5BEF28B4612B","8C6DDB20-18B1-4131-9285-796179A71C0F","96FA50A4-69CE-42AC-B6A3-EF6B3388CCB7","2EA04F4B-A776-428E-9869-58E8E5B149C2","DD735A61-C43E-446D-A1DB-1F9F47855383","4C7A45D6-F859-4242-9CDA-AEA1977969DE"].map(function(i){return i.toLowerCase()});return!(AppInfo.isNativeApp&&-1===allowedPluginConfigs.indexOf((pluginId||"").toLowerCase()))},serverAddress:function(){"use strict";if(Dashboard.isConnectMode()){var apiClient=window.ApiClient;return apiClient?apiClient.serverAddress():null}var urlLower=window.location.href.toLowerCase(),index=urlLower.lastIndexOf("/web");if(-1!==index)return urlLower.substring(0,index);var loc=window.location,address=loc.protocol+"//"+loc.hostname;return loc.port&&(address+=":"+loc.port),address},onServerChanged:function(userId,accessToken,apiClient){"use strict";apiClient=apiClient||window.ApiClient,window.ApiClient=apiClient},logout:function(logoutWithServer,forceWindowRedirect){"use strict";require(["playbackManager"],function(playbackManager){function onLogoutDone(){var loginPage;Dashboard.isConnectMode()?(loginPage="connectlogin.html",window.ApiClient=null):loginPage="login.html",!0!==forceWindowRedirect||Dashboard.isConnectMode()?Dashboard.navigate(loginPage):window.location="index.html?#!/"+loginPage}playbackManager.stop(),!1===logoutWithServer?onLogoutDone():require(["connectionManager"],function(connectionManager){connectionManager.logout().then(onLogoutDone)})})},getConfigurationPageUrl:function(name){"use strict";return Dashboard.isConnectMode()?"configurationpageext?name="+encodeURIComponent(name):"configurationpage?name="+encodeURIComponent(name)},getConfigurationResourceUrl:function(name){"use strict";return Dashboard.isConnectMode()?ApiClient.getUrl("web/ConfigurationPage",{name:name}):Dashboard.getConfigurationPageUrl(name)},navigate:function(url,preserveQueryString){"use strict";if(!url)throw new Error("url cannot be null or empty");var queryString=getWindowLocationSearch();return preserveQueryString&&queryString&&(url+=queryString),new Promise(function(resolve,reject){require(["appRouter"],function(appRouter){return appRouter.show(url).then(resolve,reject)})})},processPluginConfigurationUpdateResult:function(){"use strict";require(["loading","toast","globalize"],function(loading,toast,globalize){loading.hide(),toast(globalize.translate("MessageSettingsSaved"))})},processServerConfigurationUpdateResult:function(result){"use strict";require(["loading","toast","globalize"],function(loading,toast,globalize){loading.hide(),toast(globalize.translate("MessageSettingsSaved"))})},processErrorResponse:function(response){"use strict";require(["loading"],function(loading){loading.hide()});var status=""+response.status;response.statusText&&(status=response.statusText),Dashboard.alert({title:status,message:response.headers?response.headers.get("X-Application-Error-Code"):null})},alert:function(options){"use strict";"string"!=typeof options?require(["alert","globalize"],function(alert,globalize){alert({title:options.title||globalize.translate("HeaderAlert"),text:options.message}).then(options.callback||function(){})}):require(["toast"],function(toast){toast({text:options})})},restartServer:function(){"use strict";var apiClient=window.ApiClient;apiClient&&require(["serverRestartDialog","events"],function(ServerRestartDialog,events){var dialog=new ServerRestartDialog({apiClient:apiClient});events.on(dialog,"restarted",function(){Dashboard.isConnectMode()?apiClient.ensureWebSocket():window.location.reload(!0)}),dialog.show()})}};function pageClassOn(eventName,className,fn){"use strict";document.addEventListener(eventName,function(e){var target=e.target;target.classList.contains(className)&&fn.call(target,e)})}function pageIdOn(eventName,id,fn){"use strict";document.addEventListener(eventName,function(e){var target=e.target;target.id===id&&fn.call(target,e)})}!function(){"use strict";function showTranslatedAlert(text){return require(["globalize","alert"]).then(function(responses){var globalize=responses[0];return(0,responses[1])(globalize.translate(text))})}function onApiClientCreated(e,newApiClient){!function(apiClient){"cordova"!==self.appMode&&"android"!==self.appMode||(apiClient._getAvailablePlugins=apiClient.getAvailablePlugins,apiClient.getAvailablePlugins=function(){return this._getAvailablePlugins().then(function(plugins){return plugins.filter(function(p){return Dashboard.allowPluginPages(p.guid)})})})}(newApiClient),window.$&&(window.$.ajax=newApiClient.ajax)}var localApiClient,urlArgs,bowerPath,apiClientBowerPath,embyWebComponentsBowerPath,embyElementsPath,paths;function getCapabilities(){return require(["apphost"]).then(function(requireResult){var appHost=requireResult[0];return appHost.getSyncProfile().then(function(deviceProfile){var caps={PlayableMediaTypes:["Audio","Video"],SupportedCommands:["MoveUp","MoveDown","MoveLeft","MoveRight","PageUp","PageDown","PreviousLetter","NextLetter","ToggleOsd","ToggleContextMenu","Select","Back","SendKey","SendString","GoHome","GoToSettings","VolumeUp","VolumeDown","Mute","Unmute","ToggleMute","SetVolume","SetAudioStreamIndex","SetSubtitleStreamIndex","DisplayContent","GoToSearch","DisplayMessage","SetRepeatMode","ChannelUp","ChannelDown","PlayMediaSource","PlayTrailers"],SupportsMediaControl:!0};caps.DeviceProfile=deviceProfile,caps.IconUrl=appHost.deviceIconUrl(),caps.SupportsSync=appHost.supports("sync"),caps.SupportsContentUploading=appHost.supports("cameraupload");appHost.getPushTokenInfo();return caps=Object.assign(caps,appHost.getPushTokenInfo()),Promise.resolve(caps)})})}function createConnectionManager(){return new Promise(function(resolve,reject){require(["connectionManagerFactory","apphost","credentialprovider","events","userSettings"],function(ConnectionManager,apphost,credentialProvider,events,userSettings){var credentialProviderInstance=new credentialProvider,promises=[apphost.init()];Promise.all(promises).then(function(responses){var connectionManager=new ConnectionManager(credentialProviderInstance,apphost.appName(),apphost.appVersion(),apphost.deviceName(),apphost.deviceId(),getCapabilities,window.devicePixelRatio);if(function(connectionManager){window.ConnectionManager=connectionManager,define("connectionManager",[],function(){return connectionManager})}(connectionManager),function(connectionManager,events,userSettings,appHost){(window.Events=events).on(connectionManager,"apiclientcreated",onApiClientCreated),connectionManager.currentApiClient=function(){if(!localApiClient){var server=connectionManager.getLastUsedServer();server&&(localApiClient=connectionManager.getApiClient(server.Id))}return localApiClient},connectionManager.onLocalUserSignedIn=function(serverId,userId){return localApiClient=connectionManager.getApiClient(serverId),window.ApiClient=localApiClient,userSettings.setUserInfo(userId,localApiClient)},events.on(connectionManager,"localusersignedout",function(){userSettings.setUserInfo(null,null)}),connectionManager.validateServerAddress=appHost.validateServerAddress}(connectionManager,events,userSettings,apphost),!Dashboard.isConnectMode())return console.log("loading ApiClient singleton"),require(["apiclient"]).then(function(requireResult){var apiClientFactory=requireResult[0];console.log("creating ApiClient singleton");var apiClient=new apiClientFactory(Dashboard.serverAddress(),apphost.appName(),apphost.appVersion(),apphost.deviceName(),apphost.deviceId(),window.devicePixelRatio);apiClient.enableAutomaticNetworking=!1,apiClient.manualAddressOnly=!0,connectionManager.addApiClient(apiClient),window.ApiClient=apiClient,localApiClient=apiClient,console.log("loaded ApiClient singleton"),resolve()});connectionManager.rejectInsecureAddresses=apphost.supports("rejectinsecureaddresses"),resolve()})})})}function returnFirstDependency(obj){return obj}function getSettingsBuilder(UserSettings,layoutManager,browser){return UserSettings.prototype.enableThemeVideos=function(val){return null!=val?this.set("enableThemeVideos",val.toString(),!1):(val=this.get("enableThemeVideos",!1))?"false"!==val:!layoutManager.mobile&&!browser.slow},UserSettings}function getPlaybackManager(playbackManager){return window.addEventListener("beforeunload",function(e){try{playbackManager.onAppClose()}catch(err){console.log("error in onAppClose: "+err)}}),playbackManager}function getLayoutManager(layoutManager,appHost){return appHost.getDefaultLayout&&(layoutManager.defaultLayout=appHost.getDefaultLayout()),layoutManager.init(),layoutManager}function createWindowHeadroom(Headroom){var headroom=new Headroom([],{});return headroom.init(),headroom}function getCastSenderApiLoader(){var ccLoaded=!1;return{load:function(){return ccLoaded?Promise.resolve():new Promise(function(resolve,reject){var fileref=document.createElement("script");fileref.setAttribute("type","text/javascript"),fileref.onload=function(){ccLoaded=!0,resolve()},fileref.setAttribute("src","https://www.gstatic.com/cv/js/sender/v1/cast_sender.js"),document.querySelector("head").appendChild(fileref)})}}}function getDummyCastSenderApiLoader(){return{load:function(){return window.chrome=window.chrome||{},Promise.resolve()}}}function createSharedAppFooter(appFooter){return new appFooter({})}function onRequireJsError(requireType,requireModules){console.log("RequireJS error: "+(requireType||"unknown")+". Failed modules: "+(requireModules||[]).join(","))}function init(){define("livetvcss",["css!css/livetv.css"],returnFirstDependency),define("detailtablecss",["css!css/detailtable.css"],returnFirstDependency),define("buttonenabled",["legacy/buttonenabled"],returnFirstDependency);var list=[];self.fetch||list.push("fetch"),"function"!=typeof Object.assign&&list.push("objectassign"),Array.prototype.filter||list.push("arraypolyfills"),Function.prototype.bind||list.push("functionbind"),self.requestAnimationFrame||list.push("raf"),require(list,function(){createConnectionManager().then(function(){console.log("initAfterDependencies promises resolved"),require(["globalize","browser"],function(globalize,browser){Promise.all([function(globalize){var translations=["ar","be-BY","bg-BG","ca","cs","da","de","el","en-GB","en-US","es","es-AR","es-MX","fa","fi","fr","fr-CA","gsw","he","hi-IN","hr","hu","id","it","ja","kk","ko","lt-LT","ms","nb","nl","pl","pt-BR","pt-PT","ro","ru","sk","sl-SI","sv","tr","uk","vi","zh-CN","zh-HK","zh-TW"].map(function(i){return{lang:i,path:"strings/"+i+".json"}});return globalize.loadStrings({name:"core",translations:translations})}(globalize),function(globalize){var translations=["ar","bg-BG","ca","cs","da","de","el","en-GB","en-US","es","es-AR","es-MX","fi","fr","fr-CA","gsw","he","hr","hu","id","it","kk","ko","lt-LT","ms","nb","nl","pl","pt-BR","pt-PT","ro","ru","sk","sl-SI","sv","tr","uk","vi","zh-CN","zh-HK","zh-TW"].map(function(i){return{lang:i,path:"bower_components/emby-webcomponents/strings/"+i+".json"}});globalize.loadStrings({name:"sharedcomponents",translations:translations})}(globalize)]).then(function(){!function(browser,globalize){if("android"===self.appMode){if(-1!==self.location.href.toString().toLowerCase().indexOf("start=backgroundsync"))return onAppReady(browser)}document.title=globalize.translateDocument(document.title,"core");var deps=["apphost"];console.log("Using default fonts"),deps.push("systemFontsCss"),deps.push("css!bower_components/emby-webcomponents/layout"),deps.push("css!css/librarybrowser"),deps.push("sectionsStyle"),require(deps,function(appHost){(function(externalPlugins,appHost,browser){console.log("Loading installed plugins");var list=["bower_components/emby-webcomponents/playback/playbackvalidation","bower_components/emby-webcomponents/playback/playaccessvalidation","bower_components/emby-webcomponents/playback/experimentalwarnings"];"android"===self.appMode?21<=AndroidAppHost.getSDKVersion()&&(list.push("cordova/mpvvideoplayer"),list.push("cordova/mpvaudioplayer")):"cordova"===self.appMode&&11<=(browser.iOSVersion||0)&&(list.push("cordova/mpvaudioplayer"),list.push("cordova/mpvvideoplayer"));list.push("bower_components/emby-webcomponents/htmlaudioplayer/plugin"),"cordova"===self.appMode&&list.push("cordova/chromecast");"android"===self.appMode&&(list.push("cordova/externalplayer"),list.push("cordova/chromecast"));list.push("bower_components/emby-webcomponents/htmlvideoplayer/plugin"),list.push("bower_components/emby-webcomponents/photoplayer/plugin"),appHost.supports("remotecontrol")&&(list.push("bower_components/emby-webcomponents/sessionplayer"),(browser.chrome||browser.opera)&&"android"!==self.appMode&&list.push("bower_components/emby-webcomponents/chromecast/chromecastplayer"));list.push("bower_components/emby-webcomponents/youtubeplayer/plugin");for(var i=0,length=externalPlugins.length;i<length;i++)list.push(externalPlugins[i]);return new Promise(function(resolve,reject){Promise.all(list.map(loadPlugin)).then(function(){require(["packageManager"],function(packageManager){packageManager.init().then(resolve,reject)})},reject)})})([],appHost,browser).then(function(){onAppReady(browser)})})}(browser,globalize)})})})})}function defineRoute(newRoute,dictionary){var baseRoute=Emby.Page.baseUrl(),path=newRoute.path;path=path.replace(baseRoute,""),console.log("Defining route: "+path),newRoute.dictionary=newRoute.dictionary||dictionary||"core",Emby.Page.addRoute(path,newRoute)}function getPluginPageContentPath(){return window.ApiClient?ApiClient.getUrl("web/ConfigurationPage"):null}function loadPlugin(url){return new Promise(function(resolve,reject){require(["pluginManager"],function(pluginManager){pluginManager.loadPlugin(url).then(resolve,reject)})})}function onAppReady(browser){console.log("Begin onAppReady");var deps=[],isBackgroundSync=-1!==self.location.href.toString().toLowerCase().indexOf("start=backgroundsync"),isInBackground=isBackgroundSync;deps.push("apphost"),isInBackground||(deps.push("appRouter"),deps.push("scripts/themeloader"),browser.iOS&&deps.push("css!devices/ios/ios.css"),"cordova"!==self.appMode&&"android"!==self.appMode||deps.push("registrationServices"),deps.push("libraryMenu")),console.log("onAppReady - loading dependencies"),require(deps,function(appHost,pageObjects){console.log("Loaded dependencies in onAppReady"),window.Emby={},isBackgroundSync?require(["localsync"],function(localSync){localSync.sync()}):(window.Emby.Page=pageObjects,console.log("Defining core routes"),defineRoute({path:"/plugins/addplugin.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"plugins/addpluginpage"}),defineRoute({path:"/appservices.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/channelsettings.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/connectlogin.html",dependencies:["emby-button","emby-input"],autoFocus:!1,anonymous:!0,startup:!0,controller:"scripts/connectlogin",defaultTitle:!0}),defineRoute({path:"/dashboard.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"scripts/dashboardpage",defaultTitle:!0}),defineRoute({path:"/dashboardgeneral.html",controller:"dashboard/dashboardgeneral",autoFocus:!1,roles:"admin"}),defineRoute({path:"/dashboardhosting.html",dependencies:["emby-input","emby-button"],autoFocus:!1,roles:"admin",controller:"dashboard/dashboardhosting"}),defineRoute({path:"/devices/devices.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"devices/devices"}),defineRoute({path:"/devices/device.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"devices/device"}),defineRoute({path:"/devicesupload.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"dashboard/devicesupload"}),defineRoute({path:"/edititemmetadata.html",dependencies:[],controller:"scripts/edititemmetadata",autoFocus:!1}),defineRoute({path:"/encodingsettings.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"scripts/encodingsettings"}),defineRoute({path:"/forgotpassword.html",dependencies:["emby-input","emby-button"],anonymous:!0,startup:!0,controller:"scripts/forgotpassword",defaultTitle:!0}),defineRoute({path:"/forgotpasswordpin.html",dependencies:["emby-input","emby-button"],autoFocus:!1,anonymous:!0,startup:!0,controller:"scripts/forgotpasswordpin",defaultTitle:!0}),defineRoute({path:"/home.html",dependencies:[],autoFocus:!1,controller:"home/home",transition:"fade",type:"home",headerTabs:!0,homeButton:!1,defaultTitle:!0,autoHideHeader:!0}),defineRoute({path:"/list/list.html",dependencies:[],autoFocus:!1,controller:"list/list",transition:"fade",autoHideHeader:!0}),defineRoute({path:"/servermenu/servermenu.html",dependencies:[],autoFocus:!1,controller:"servermenu/servermenu",transition:"fade",defaultTitle:!0}),defineRoute({path:"/index.html",dependencies:[],autoFocus:!1,isDefaultRoute:!0}),defineRoute({path:"/item/item.html",dependencies:[],controller:"item/item",autoFocus:!1,transition:"fade",transparentHeader:!0,autoHideHeader:!0}),defineRoute({path:"/library.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/librarysettings.html",dependencies:["emby-collapse","emby-input","emby-button","emby-select"],autoFocus:!1,roles:"admin",controller:"dashboard/librarysettings"}),defineRoute({path:"/livetv/livetv.html",dependencies:["css!livetv/guide.css"],controller:"livetv/livetv",autoFocus:!1,transition:"fade",headerTabs:!0,autoHideHeader:!0}),defineRoute({path:"/livetvsetup/schedulesdirect.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"livetvsetup/schedulesdirect"}),defineRoute({path:"/livetvsetup/xmltv.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"livetvsetup/xmltv"}),defineRoute({path:"/livetvsetup/embydata.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"livetvsetup/embydata"}),defineRoute({path:"/livetvsetup/guideprovider.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"livetvsetup/guideprovider"}),defineRoute({path:"/livetvsetup/livetvsettings.html",dependencies:[],autoFocus:!1,controller:"livetvsetup/livetvsettings"}),defineRoute({path:"/livetvsetup/livetvstatus.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"livetvsetup/livetvstatus"}),defineRoute({path:"/livetvsetup/livetvtuner.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"livetvsetup/livetvtuner"}),defineRoute({path:"/log.html",dependencies:["emby-checkbox"],roles:"admin",controller:"dashboard/logpage"}),defineRoute({path:"/login.html",dependencies:["emby-button","emby-input"],autoFocus:!1,anonymous:!0,startup:!0,controller:"scripts/loginpage",defaultTitle:!0}),defineRoute({path:"/metadataadvanced.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/metadataimages.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"scripts/metadataimagespage"}),defineRoute({path:"/movies/movies.html",dependencies:[],autoFocus:!1,controller:"movies/movies",transition:"fade",headerTabs:!0,autoHideHeader:!0}),defineRoute({path:"/games/games.html",dependencies:[],autoFocus:!1,controller:"games/games",transition:"fade",headerTabs:!0,autoHideHeader:!0}),defineRoute({path:"/homevideos/homevideos.html",dependencies:[],autoFocus:!1,controller:"homevideos/homevideos",transition:"fade",headerTabs:!0,autoHideHeader:!0}),defineRoute({path:"/musicvideos/musicvideos.html",dependencies:[],autoFocus:!1,controller:"musicvideos/musicvideos",transition:"fade",headerTabs:!0,autoHideHeader:!0}),defineRoute({path:"/music/music.html",dependencies:[],controller:"music/music",autoFocus:!1,transition:"fade",headerTabs:!0,autoHideHeader:!0}),defineRoute({path:"/mypreferencesdisplay.html",dependencies:["emby-checkbox","emby-button","emby-select"],autoFocus:!1,transition:"fade",controller:"scripts/mypreferencesdisplay",autoHideHeader:!0}),defineRoute({path:"/mypreferenceshome.html",dependencies:[],autoFocus:!1,transition:"fade",controller:"scripts/mypreferenceshome",autoHideHeader:!0}),defineRoute({path:"/mypreferencessubtitles.html",dependencies:[],autoFocus:!1,transition:"fade",controller:"scripts/mypreferencessubtitles",autoHideHeader:!0}),defineRoute({path:"/mypreferenceslanguages.html",dependencies:["emby-button","emby-checkbox","emby-select"],autoFocus:!1,transition:"fade",controller:"scripts/mypreferenceslanguages",autoHideHeader:!0}),defineRoute({path:"/usermenu/usermenu.html",dependencies:["emby-button"],autoFocus:!1,transition:"fade",controller:"usermenu/usermenu",autoHideHeader:!0}),defineRoute({path:"/myprofile.html",dependencies:["emby-button","emby-collapse","emby-checkbox","emby-input"],autoFocus:!1,transition:"fade",controller:"scripts/myprofile",autoHideHeader:!0}),defineRoute({path:"/offline/offline.html",transition:"fade",controller:"offline/offline",dependencies:[],anonymous:!0,startup:!1,autoHideHeader:!0}),defineRoute({path:"/managedownloads.html",transition:"fade",controller:"scripts/managedownloads",dependencies:[],autoHideHeader:!0}),defineRoute({path:"/mysync.html",dependencies:[],autoFocus:!1,transition:"fade",controller:"scripts/mysync",autoHideHeader:!0}),defineRoute({path:"/camerauploadsettings.html",dependencies:[],autoFocus:!1,transition:"fade",controller:"scripts/camerauploadsettings",autoHideHeader:!0}),defineRoute({path:"/mysyncjob.html",dependencies:[],autoFocus:!1,transition:"fade",controller:"scripts/syncjob",autoHideHeader:!0}),defineRoute({path:"/mysyncsettings.html",dependencies:["emby-checkbox","emby-input","emby-button","paper-icon-button-light"],autoFocus:!1,transition:"fade",controller:"scripts/mysyncsettings",autoHideHeader:!0}),defineRoute({path:"/notificationsetting.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/notificationsettings.html",controller:"scripts/notificationsettings",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/nowplaying.html",dependencies:["paper-icon-button-light","emby-slider","emby-button","emby-input","emby-itemscontainer"],controller:"scripts/nowplayingpage",autoFocus:!1,transition:"fade",fullscreen:!0,supportsThemeMedia:!0,enableMediaControl:!1,transparentHeader:!0,autoHideHeader:!0}),defineRoute({path:"/plugins/plugincatalog.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"plugins/plugincatalog"}),defineRoute({path:"/plugins/plugins.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"plugins/plugins"}),defineRoute({path:"/scheduledtasks/scheduledtask.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"scheduledtasks/scheduledtaskpage"}),defineRoute({path:"/dashboard/releasenotes.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"dashboard/releasenotes"}),defineRoute({path:"/scheduledtasks/scheduledtasks.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"scheduledtasks/scheduledtaskspage"}),defineRoute({path:"/search.html",dependencies:[],controller:"scripts/searchpage",autoHideHeader:!0}),defineRoute({path:"/selectserver.html",dependencies:["listViewStyle","emby-button"],autoFocus:!1,anonymous:!0,startup:!0,controller:"scripts/selectserver",autoHideHeader:!0}),defineRoute({path:"/serveractivity.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"dashboard/serveractivity"}),defineRoute({path:"/serversecurity.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"scripts/serversecurity"}),defineRoute({path:"/support.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/supporterkey.html",dependencies:[],controller:"scripts/supporterkeypage",autoFocus:!1,roles:"admin"}),defineRoute({path:"/syncactivity.html",dependencies:[],autoFocus:!1,controller:"scripts/syncactivity"}),defineRoute({path:"/syncsettings.html",dependencies:[],autoFocus:!1}),defineRoute({path:"/tv/tv.html",dependencies:[],autoFocus:!1,controller:"tv/tv",transition:"fade",headerTabs:!0,autoHideHeader:!0}),defineRoute({path:"/useredit.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/userlibraryaccess.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/usernew.html",dependencies:[],autoFocus:!1,roles:"admin"}),defineRoute({path:"/userparentalcontrol.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"scripts/userparentalcontrol"}),defineRoute({path:"/userpassword.html",dependencies:["emby-input","emby-button","emby-checkbox"],autoFocus:!1,controller:"scripts/userpasswordpage"}),defineRoute({path:"/users/users.html",dependencies:[],autoFocus:!1,roles:"admin",controller:"users/users"}),defineRoute({path:"/wizard/wizardagreement.html",dependencies:["dashboardcss"],autoFocus:!1,anonymous:!0,controller:"wizard/wizardagreement",homeButton:!1,secondaryHeaderFeatures:!1,defaultTitle:!0}),defineRoute({path:"/wizard/wizardremoteaccess.html",dependencies:["dashboardcss"],autoFocus:!1,anonymous:!0,controller:"wizard/wizardremoteaccess",homeButton:!1,secondaryHeaderFeatures:!1,defaultTitle:!0}),defineRoute({path:"/wizard/wizardfinish.html",dependencies:["emby-button","dashboardcss"],autoFocus:!1,anonymous:!0,controller:"wizard/wizardfinishpage",homeButton:!1,secondaryHeaderFeatures:!1,defaultTitle:!0}),defineRoute({path:"/wizard/wizardlibrary.html",dependencies:["dashboardcss"],autoFocus:!1,anonymous:!0,homeButton:!1,secondaryHeaderFeatures:!1,defaultTitle:!0}),defineRoute({path:"/wizard/wizardsettings.html",dependencies:["dashboardcss"],autoFocus:!1,anonymous:!0,controller:"wizard/wizardsettings",homeButton:!1,secondaryHeaderFeatures:!1,defaultTitle:!0}),defineRoute({path:"/wizard/wizardstart.html",dependencies:["dashboardcss"],autoFocus:!1,anonymous:!0,controller:"wizard/wizardstart",homeButton:!1,secondaryHeaderFeatures:!1,defaultTitle:!0}),defineRoute({path:"/wizard/wizarduser.html",dependencies:["dashboardcss","emby-input"],controller:"wizard/wizarduserpage",autoFocus:!1,anonymous:!0,homeButton:!1,secondaryHeaderFeatures:!1,defaultTitle:!0}),defineRoute({path:"/videoosd/videoosd.html",dependencies:[],transition:"fade",controller:"videoosd/videoosd",autoFocus:!1,type:"video-osd",supportsThemeMedia:!0,fullscreen:!0,enableMediaControl:!1,homeButton:!1,transparentHeader:!0,backButton:!0}),Dashboard.isConnectMode()?defineRoute({path:"/configurationpageext",dependencies:[],autoFocus:!1,enableCache:!1,enableContentQueryString:!0,roles:"admin",contentPath:getPluginPageContentPath}):defineRoute({path:"/configurationpage",dependencies:[],autoFocus:!1,enableCache:!1,enableContentQueryString:!0,roles:"admin"}),defineRoute({path:"/",isDefaultRoute:!0,autoFocus:!1,dependencies:[]}),require(["appHeader"]).then(function(responses){return responses[0].init()}).then(function(){Emby.Page.start({click:!1,hashbang:!0});var postInitDependencies=[];window.navigator&&"string"==typeof window.navigator.gamepadInputEmulation&&(window.navigator.gamepadInputEmulation="keyboard",!0)||!("ongamepadconnected"in window||navigator.getGamepads||navigator.webkitGetGamepads)||postInitDependencies.push("bower_components/emby-webcomponents/input/gamepadtokey"),postInitDependencies.push("bower_components/emby-webcomponents/thememediaplayer"),postInitDependencies.push("scripts/autobackdrops"),"android"===self.appMode?(postInitDependencies.push("cordova/mediasession"),postInitDependencies.push("cordova/chromecast"),postInitDependencies.push("cordova/appshortcuts")):"cordova"===self.appMode&&(postInitDependencies.push("cordova/mediasession"),postInitDependencies.push("cordova/volume"),postInitDependencies.push("cordova/statusbar"),postInitDependencies.push("cordova/appshortcuts"),postInitDependencies.push("cordova/backgroundfetch")),browser.tv||browser.xboxOne||browser.ps4||postInitDependencies.push("bower_components/emby-webcomponents/nowplayingbar/nowplayingbar"),appHost.supports("remotecontrol")&&(postInitDependencies.push("playerSelectionMenu"),postInitDependencies.push("bower_components/emby-webcomponents/playback/remotecontrolautoplay")),appHost.supports("physicalvolumecontrol")&&!browser.touch||browser.edge||"android"===self.appMode||"cordova"===self.appMode||postInitDependencies.push("bower_components/emby-webcomponents/playback/volumeosd"),navigator.mediaSession&&postInitDependencies.push("mediaSession"),postInitDependencies.push("apiInput"),postInitDependencies.push("mouseManager"),browser.tv||browser.xboxOne||((screen.lockOrientation||screen.mozLockOrientation||screen.msLockOrientation||screen.orientation&&screen.orientation.lock)&&postInitDependencies.push("bower_components/emby-webcomponents/playback/playbackorientation"),function(){if(navigator.serviceWorker&&"cordova"!==self.appMode&&"android"!==self.appMode)try{navigator.serviceWorker.register("serviceworker.js").then(function(){return navigator.serviceWorker.ready}).then(function(reg){if(reg&&reg.sync)return reg.sync.register("emby-sync").then(function(){window.SyncRegistered=Dashboard.isConnectMode()})})}catch(err){console.log("Error registering serviceWorker: "+err)}}(),window.Notification&&postInitDependencies.push("bower_components/emby-webcomponents/notifications/notifications")),postInitDependencies.push("playerSelectionMenu"),postInitDependencies.push("dockedTabs"),appHost.supports("fullscreenchange")&&require(["fullscreen-doubleclick"]),require(postInitDependencies),Dashboard.isConnectMode()||window.ApiClient&&require(["css!"+ApiClient.getUrl("Branding/Css")])}))})}urlArgs="v="+(window.dashboardVersion||(new Date).getDate()),embyElementsPath="modules/emby-elements",(paths={velocity:(bowerPath="bower_components")+"/velocity/velocity.min",vibrant:bowerPath+"/vibrant/dist/vibrant",staticBackdrops:(embyWebComponentsBowerPath=bowerPath+"/emby-webcomponents")+"/staticbackdrops",ironCardList:"components/ironcardlist/ironcardlist",scrollThreshold:"components/scrollthreshold",playlisteditor:"components/playlisteditor/playlisteditor",medialibrarycreator:"components/medialibrarycreator/medialibrarycreator",medialibraryeditor:"components/medialibraryeditor/medialibraryeditor",imageoptionseditor:"components/imageoptionseditor/imageoptionseditor",howler:bowerPath+"/howlerjs/dist/howler.min",sortable:bowerPath+"/Sortable/Sortable.min",isMobile:bowerPath+"/isMobile/isMobile.min",masonry:bowerPath+"/masonry/dist/masonry.pkgd.min",humanedate:"modules/humanedate/humanedate",events:(apiClientBowerPath=bowerPath+"/emby-apiclient")+"/events",credentialprovider:apiClientBowerPath+"/credentials",connectionManagerFactory:bowerPath+"/emby-apiclient/connectionmanager",visibleinviewport:embyWebComponentsBowerPath+"/visibleinviewport",browserdeviceprofile:embyWebComponentsBowerPath+"/browserdeviceprofile",browser:embyWebComponentsBowerPath+"/browser",inputManager:embyWebComponentsBowerPath+"/inputmanager",qualityoptions:embyWebComponentsBowerPath+"/qualityoptions",hammer:bowerPath+"/hammerjs/hammer.min",pageJs:embyWebComponentsBowerPath+"/pagejs/page",focusManager:embyWebComponentsBowerPath+"/focusmanager",datetime:embyWebComponentsBowerPath+"/datetime",globalize:embyWebComponentsBowerPath+"/globalize",itemHelper:embyWebComponentsBowerPath+"/itemhelper",itemShortcuts:embyWebComponentsBowerPath+"/shortcuts",playQueueManager:embyWebComponentsBowerPath+"/playback/playqueuemanager",autoPlayDetect:embyWebComponentsBowerPath+"/playback/autoplaydetect",nowPlayingHelper:embyWebComponentsBowerPath+"/playback/nowplayinghelper",pluginManager:embyWebComponentsBowerPath+"/pluginmanager",packageManager:embyWebComponentsBowerPath+"/packagemanager"}).hlsjs=bowerPath+"/hlsjs/dist/hls.min",paths.flvjs=embyWebComponentsBowerPath+"/flvjs/flv.min",paths.shaka=embyWebComponentsBowerPath+"/shaka/shaka-player.compiled",define("chromecastHelper",[embyWebComponentsBowerPath+"/chromecast/chromecasthelpers"],returnFirstDependency),define("mediaSession",[embyWebComponentsBowerPath+"/playback/mediasession"],returnFirstDependency),define("webActionSheet",[embyWebComponentsBowerPath+"/actionsheet/actionsheet"],returnFirstDependency),define("libjass",[bowerPath+"/libjass/libjass","css!"+bowerPath+"/libjass/libjass"],returnFirstDependency),define("SubtitlesOctopus",[bowerPath+"/javascriptsubtitlesoctopus/dist/subtitles-octopus"],returnFirstDependency),define("tunerPicker",["components/tunerpicker"],returnFirstDependency),define("mainTabsManager",[embyWebComponentsBowerPath+"/maintabsmanager"],returnFirstDependency),define("imageLoader",[embyWebComponentsBowerPath+"/images/imagehelper"],returnFirstDependency),define("appFooter",[embyWebComponentsBowerPath+"/appfooter/appfooter"],returnFirstDependency),define("appHeader",[embyWebComponentsBowerPath+"/appheader/appheader"],returnFirstDependency),define("directorybrowser",["components/directorybrowser/directorybrowser"],returnFirstDependency),define("metadataEditor",[embyWebComponentsBowerPath+"/metadataeditor/metadataeditor"],returnFirstDependency),define("personEditor",[embyWebComponentsBowerPath+"/metadataeditor/personeditor"],returnFirstDependency),define("playerSelectionMenu",[embyWebComponentsBowerPath+"/playback/playerselection"],returnFirstDependency),define("playerSettingsMenu",[embyWebComponentsBowerPath+"/playback/playersettingsmenu"],returnFirstDependency),define("playMethodHelper",[embyWebComponentsBowerPath+"/playback/playmethodhelper"],returnFirstDependency),define("brightnessOsd",[embyWebComponentsBowerPath+"/playback/brightnessosd"],returnFirstDependency),define("libraryMenu",["scripts/librarymenu"],returnFirstDependency),define("emby-collapse",[embyElementsPath+"/emby-collapse/emby-collapse"],returnFirstDependency),define("emby-button",[embyElementsPath+"/emby-button/emby-button"],returnFirstDependency),define("emby-linkbutton",["emby-button"],returnFirstDependency),define("emby-itemscontainer",[embyElementsPath+"/emby-itemscontainer/emby-itemscontainer"],returnFirstDependency),define("alphaNumericShortcuts",[embyWebComponentsBowerPath+"/alphanumericshortcuts/alphanumericshortcuts"],returnFirstDependency),define("virtual-scroller",["modules/virtual-scroller/virtual-scroller","css!modules/virtual-scroller/virtual-scroller"],returnFirstDependency),define("emby-scroller",[embyElementsPath+"/emby-scroller/emby-scroller"],returnFirstDependency),define("emby-tabs",[embyElementsPath+"/emby-tabs/emby-tabs"],returnFirstDependency),define("emby-scrollbuttons",[embyElementsPath+"/emby-scrollbuttons/emby-scrollbuttons"],returnFirstDependency),define("emby-progressring",[embyElementsPath+"/emby-progressring/emby-progressring"],returnFirstDependency),define("emby-itemrefreshindicator",[embyElementsPath+"/emby-itemrefreshindicator/emby-itemrefreshindicator"],returnFirstDependency),define("multiSelect",[embyWebComponentsBowerPath+"/multiselect/multiselect"],returnFirstDependency),define("alphaPicker",[embyWebComponentsBowerPath+"/alphapicker/alphapicker"],returnFirstDependency),define("paper-icon-button-light",[embyElementsPath+"/emby-button/paper-icon-button-light"],returnFirstDependency),define("tabbedView",[embyWebComponentsBowerPath+"/tabbedview/tabbedview"],returnFirstDependency),define("foldersTab",[embyWebComponentsBowerPath+"/tabbedview/folderstab"],returnFirstDependency),define("itemsTab",[embyWebComponentsBowerPath+"/tabbedview/itemstab"],returnFirstDependency),define("connectHelper",[embyWebComponentsBowerPath+"/emby-connect/connecthelper"],returnFirstDependency),define("emby-input",[embyElementsPath+"/emby-input/emby-input"],returnFirstDependency),define("emby-select",[embyElementsPath+"/emby-select/emby-select"],returnFirstDependency),define("emby-slider",[embyElementsPath+"/emby-slider/emby-slider"],returnFirstDependency),define("emby-checkbox",[embyElementsPath+"/emby-checkbox/emby-checkbox"],returnFirstDependency),define("emby-progressbar",[embyElementsPath+"/emby-progressbar/emby-progressbar"],returnFirstDependency),define("embyProgressBarStyle",["css!"+embyElementsPath+"/emby-progressbar/emby-progressbar"],returnFirstDependency),define("emby-toggle",[embyElementsPath+"/emby-toggle/emby-toggle"],returnFirstDependency),define("emby-textarea",[embyElementsPath+"/emby-textarea/emby-textarea"],returnFirstDependency),define("collectionEditor",[embyWebComponentsBowerPath+"/collectioneditor/collectioneditor"],returnFirstDependency),define("serverRestartDialog",[embyWebComponentsBowerPath+"/serverrestartdialog/serverrestartdialog"],returnFirstDependency),define("playlistEditor",[embyWebComponentsBowerPath+"/playlisteditor/playlisteditor"],returnFirstDependency),define("recordingCreator",[embyWebComponentsBowerPath+"/recordingcreator/recordingcreator"],returnFirstDependency),define("recordingEditor",[embyWebComponentsBowerPath+"/recordingcreator/recordingeditor"],returnFirstDependency),define("seriesRecordingEditor",[embyWebComponentsBowerPath+"/recordingcreator/seriesrecordingeditor"],returnFirstDependency),define("recordingFields",[embyWebComponentsBowerPath+"/recordingcreator/recordingfields"],returnFirstDependency),define("recordingButton",[embyWebComponentsBowerPath+"/recordingcreator/recordingbutton"],returnFirstDependency),define("recordingHelper",[embyWebComponentsBowerPath+"/recordingcreator/recordinghelper"],returnFirstDependency),define("subtitleEditor",[embyWebComponentsBowerPath+"/subtitleeditor/subtitleeditor"],returnFirstDependency),define("itemIdentifier",[embyWebComponentsBowerPath+"/itemidentifier/itemidentifier"],returnFirstDependency),define("mediaInfo",[embyWebComponentsBowerPath+"/mediainfo/mediainfo"],returnFirstDependency),define("itemContextMenu",[embyWebComponentsBowerPath+"/itemcontextmenu"],returnFirstDependency),define("imageEditor",[embyWebComponentsBowerPath+"/imageeditor/imageeditor"],returnFirstDependency),define("imageDownloader",[embyWebComponentsBowerPath+"/imagedownloader/imagedownloader"],returnFirstDependency),define("dom",[embyWebComponentsBowerPath+"/dom"],returnFirstDependency),define("playerStats",[embyWebComponentsBowerPath+"/playerstats/playerstats"],returnFirstDependency),define("searchFields",[embyWebComponentsBowerPath+"/search/searchfields"],returnFirstDependency),define("searchResults",[embyWebComponentsBowerPath+"/search/searchresults"],returnFirstDependency),define("upNextDialog",[embyWebComponentsBowerPath+"/upnextdialog/upnextdialog"],returnFirstDependency),define("fullscreen-doubleclick",[embyWebComponentsBowerPath+"/fullscreen/fullscreen-dc"],returnFirstDependency),define("fullscreenManager",[embyWebComponentsBowerPath+"/fullscreen/fullscreenmanager","events"],returnFirstDependency),define("headroom",[embyWebComponentsBowerPath+"/headroom/headroom"],returnFirstDependency),define("subtitleAppearanceHelper",[embyWebComponentsBowerPath+"/subtitlesettings/subtitleappearancehelper"],returnFirstDependency),define("subtitleSettings",[embyWebComponentsBowerPath+"/subtitlesettings/subtitlesettings"],returnFirstDependency),define("displaySettings",[embyWebComponentsBowerPath+"/displaysettings/displaysettings"],returnFirstDependency),define("playbackSettings",[embyWebComponentsBowerPath+"/playbacksettings/playbacksettings"],returnFirstDependency),define("homescreenSettings",[embyWebComponentsBowerPath+"/homescreensettings/homescreensettings"],returnFirstDependency),define("homescreenSettingsDialog",[embyWebComponentsBowerPath+"/homescreensettings/homescreensettingsdialog"],returnFirstDependency),define("playbackManager",[embyWebComponentsBowerPath+"/playback/playbackmanager"],getPlaybackManager),define("layoutManager",[embyWebComponentsBowerPath+"/layoutmanager","apphost"],getLayoutManager),define("homeSections",[embyWebComponentsBowerPath+"/homesections/homesections"],returnFirstDependency),define("refreshDialog",[embyWebComponentsBowerPath+"/refreshdialog/refreshdialog"],returnFirstDependency),define("backdrop",[embyWebComponentsBowerPath+"/backdrop/backdrop"],returnFirstDependency),define("fetchHelper",[embyWebComponentsBowerPath+"/fetchhelper"],returnFirstDependency),define("roundCardStyle",["cardStyle","css!"+embyWebComponentsBowerPath+"/cardbuilder/roundcard"],returnFirstDependency),define("cardStyle",["css!"+embyWebComponentsBowerPath+"/cardbuilder/card"],returnFirstDependency),define("cardBuilder",[embyWebComponentsBowerPath+"/cardbuilder/cardbuilder"],returnFirstDependency),define("peoplecardbuilder",[embyWebComponentsBowerPath+"/cardbuilder/peoplecardbuilder"],returnFirstDependency),define("chaptercardbuilder",[embyWebComponentsBowerPath+"/cardbuilder/chaptercardbuilder"],returnFirstDependency),define("mouseManager",[embyWebComponentsBowerPath+"/input/mouse"],returnFirstDependency),define("flexStyles",["css!"+embyWebComponentsBowerPath+"/flexstyles"],returnFirstDependency),define("deleteHelper",[embyWebComponentsBowerPath+"/deletehelper"],returnFirstDependency),define("tvguide",[embyElementsPath+"/guide/guide"],returnFirstDependency),define("programStyles",["css!"+embyElementsPath+"/guide/programs"],returnFirstDependency),define("guide-settings-dialog",[embyElementsPath+"/guide/guide-settings"],returnFirstDependency),define("loadingDialog",[embyWebComponentsBowerPath+"/loadingdialog/loadingdialog"],returnFirstDependency),define("syncDialog",[embyWebComponentsBowerPath+"/sync/sync"],returnFirstDependency),define("syncJobEditor",[embyWebComponentsBowerPath+"/sync/syncjobeditor"],returnFirstDependency),define("syncJobList",[embyWebComponentsBowerPath+"/sync/syncjoblist"],returnFirstDependency),define("viewManager",[embyWebComponentsBowerPath+"/viewmanager/viewmanager"],function(viewManager){return(window.ViewManager=viewManager).dispatchPageEvents(!0),viewManager}),"cordova"===self.appMode||"android"===self.appMode?paths.apphost="cordova/apphost":paths.apphost="components/apphost",paths.appStorage=function(basePath){try{return localStorage.setItem("_test","0"),localStorage.removeItem("_test"),basePath+"/appstorage-localstorage"}catch(e){return basePath+"/appstorage-memory"}}(apiClientBowerPath),require.config({waitSeconds:0,map:{"*":{css:bowerPath+"/emby-webcomponents/require/requirecss",text:bowerPath+"/emby-webcomponents/require/requiretext"}},urlArgs:urlArgs,paths:paths,onError:onRequireJsError}),require.onError=onRequireJsError,define("jstree",[bowerPath+"/jstree/jstree","css!"+bowerPath+"/jstree/themes/default/style.css"],returnFirstDependency),define("dashboardcss",["css!css/dashboard"],returnFirstDependency),define("slideshow",[embyWebComponentsBowerPath+"/slideshow/slideshow"],returnFirstDependency),define("fetch",[bowerPath+"/fetch/fetch"],returnFirstDependency),define("raf",[embyWebComponentsBowerPath+"/polyfills/raf"],returnFirstDependency),define("functionbind",[embyWebComponentsBowerPath+"/polyfills/bind"],returnFirstDependency),define("arraypolyfills",[embyWebComponentsBowerPath+"/polyfills/array"],returnFirstDependency),define("objectassign",[embyWebComponentsBowerPath+"/polyfills/objectassign"],returnFirstDependency),define("clearButtonStyle",["css!"+embyWebComponentsBowerPath+"/clearbutton"],returnFirstDependency),define("emby-playstatebutton",[embyElementsPath+"/userdatabuttons/emby-playstatebutton"],returnFirstDependency),define("emby-ratingbutton",[embyElementsPath+"/userdatabuttons/emby-ratingbutton"],returnFirstDependency),define("emby-downloadbutton",[embyElementsPath+"/sync/emby-downloadbutton"],returnFirstDependency),define("categorySyncButton",[embyWebComponentsBowerPath+"/sync/categorysyncbutton"],returnFirstDependency),define("listView",[embyWebComponentsBowerPath+"/listview/listview"],returnFirstDependency),define("listViewStyle",["css!"+embyWebComponentsBowerPath+"/listview/listview"],returnFirstDependency),define("formDialogStyle",["css!"+embyWebComponentsBowerPath+"/formdialog"],returnFirstDependency),define("sectionsStyle",["css!"+embyWebComponentsBowerPath+"/sections"],returnFirstDependency),define("detailButtonStyle",["css!"+embyWebComponentsBowerPath+"/detailbuttons"],returnFirstDependency),define("indicators",[embyWebComponentsBowerPath+"/indicators/indicators"],returnFirstDependency),define("viewSettings",[embyWebComponentsBowerPath+"/viewsettings/viewsettings"],returnFirstDependency),define("filterMenu",[embyWebComponentsBowerPath+"/filtermenu/filtermenu"],returnFirstDependency),define("registrationServices",[embyWebComponentsBowerPath+"/registrationservices/registrationservices"],returnFirstDependency),"cordova"===self.appMode||"android"===self.appMode?define("fileupload",["cordova/fileupload"],returnFirstDependency):define("fileupload",[apiClientBowerPath+"/fileupload"],returnFirstDependency),define("connectionmanager",[apiClientBowerPath+"/connectionmanager"]),define("contentuploader",[apiClientBowerPath+"/sync/contentuploader"],returnFirstDependency),define("serversync",[apiClientBowerPath+"/sync/serversync"],returnFirstDependency),define("multiserversync",[apiClientBowerPath+"/sync/multiserversync"],returnFirstDependency),define("mediasync",[apiClientBowerPath+"/sync/mediasync"],returnFirstDependency),define("idb",[embyWebComponentsBowerPath+"/idb"],returnFirstDependency),define("sanitizefilename",[embyWebComponentsBowerPath+"/sanitizefilename"],returnFirstDependency),define("idbcore",[apiClientBowerPath+"/localdatabase/idbcore"],returnFirstDependency),define("itemrepository",[apiClientBowerPath+"/localdatabase/itemrepository"],returnFirstDependency),define("useractionrepository",[apiClientBowerPath+"/localdatabase/useractionrepository"],returnFirstDependency),define("localdatabase",[apiClientBowerPath+"/localdatabase/localdatabase"],returnFirstDependency),define("swiper",[bowerPath+"/Swiper/dist/js/swiper.min","css!"+bowerPath+"/Swiper/dist/css/swiper.min"],returnFirstDependency),define("scroller",[embyWebComponentsBowerPath+"/scroller/smoothscroller"],returnFirstDependency),define("toast",[embyWebComponentsBowerPath+"/toast/toast"],returnFirstDependency),define("scrollHelper",[embyWebComponentsBowerPath+"/scrollhelper"],returnFirstDependency),define("touchHelper",[embyWebComponentsBowerPath+"/touchhelper"],returnFirstDependency),define("appSettings",[embyWebComponentsBowerPath+"/appsettings"],returnFirstDependency),define("userSettings",[embyWebComponentsBowerPath+"/usersettings/usersettings"],returnFirstDependency),define("userSettingsBuilder",[embyWebComponentsBowerPath+"/usersettings/usersettingsbuilder","layoutManager","browser"],getSettingsBuilder),define("material-icons",["css!"+embyWebComponentsBowerPath+"/fonts/material-icons/style"],returnFirstDependency),define("systemFontsCss",["css!"+embyWebComponentsBowerPath+"/fonts/fonts"],returnFirstDependency),define("scrollStyles",["css!"+embyWebComponentsBowerPath+"/scrollstyles"],returnFirstDependency),define("imageUploader",[embyWebComponentsBowerPath+"/imageuploader/imageuploader"],returnFirstDependency),define("navdrawer",["components/navdrawer/navdrawer"],returnFirstDependency),define("dockedTabs",["components/dockedtabs/dockedtabs"],returnFirstDependency),define("htmlMediaHelper",[embyWebComponentsBowerPath+"/htmlvideoplayer/htmlmediahelper"],returnFirstDependency),define("viewcontainer",["components/viewcontainer-lite","css!"+embyWebComponentsBowerPath+"/viewmanager/viewcontainer-lite"],returnFirstDependency),define("queryString",[bowerPath+"/query-string/index"],function(){return self.queryString}),define("alert",[embyWebComponentsBowerPath+"/alert/alert"],returnFirstDependency),define("dialog",[embyWebComponentsBowerPath+"/dialog/dialog"],returnFirstDependency),define("confirm",[embyWebComponentsBowerPath+"/confirm/confirm"],returnFirstDependency),define("prompt",[embyWebComponentsBowerPath+"/prompt/prompt"],returnFirstDependency),define("jQuery",[bowerPath+"/jquery/dist/jquery.slim.min"],function(){return self.ApiClient&&(self.jQuery.ajax=ApiClient.ajax),self.jQuery}),define("fnchecked",["legacy/fnchecked"],returnFirstDependency),define("dialogHelper",[embyWebComponentsBowerPath+"/dialoghelper/dialoghelper"],returnFirstDependency),define("inputmanager",["inputManager"],returnFirstDependency),define("apiInput",[embyWebComponentsBowerPath+"/input/api"],returnFirstDependency),define("serverNotifications",["apiInput"],returnFirstDependency),define("headroom-window",["headroom"],createWindowHeadroom),define("appFooter-shared",["appFooter"],createSharedAppFooter),define("skinManager",[embyWebComponentsBowerPath+"/skinmanager"],function(skinManager){return skinManager.loadUserSkin=function(options){require(["appRouter"],function(appRouter){(options=options||{}).start?appRouter.invokeShortcut(options.start):appRouter.goHome()})},skinManager.getThemes=function(){return[{name:"Apple TV",id:"appletv"},{name:"Blue Radiance",id:"blueradiance"},{name:"Dark",id:"dark",isDefault:!0},{name:"Dark (green accent)",id:"dark-green"},{name:"Dark (red accent)",id:"dark-red"},{name:"Halloween",id:"halloween"},{name:"Light",id:"light",isDefaultServerDashboard:!0},{name:"Light (blue accent)",id:"light-blue"},{name:"Light (green accent)",id:"light-green"},{name:"Light (pink accent)",id:"light-pink"},{name:"Light (purple accent)",id:"light-purple"},{name:"Light (red accent)",id:"light-red"},{name:"Windows Media Center",id:"wmc"}]},skinManager}),define("connectionManager",[],function(){return self.ConnectionManager}),define("apiClientResolver",[],function(){return function(){return window.ApiClient}}),define("appRouter",[embyWebComponentsBowerPath+"/router","itemHelper"],function(appRouter,itemHelper){return appRouter.showLocalLogin=function(serverId,manualLogin){Dashboard.navigate("login.html?serverid="+serverId)},appRouter.showVideoOsd=function(){return Dashboard.navigate("videoosd/videoosd.html")},appRouter.showSelectServer=function(){Dashboard.isConnectMode()?Dashboard.navigate("selectserver.html"):Dashboard.navigate("login.html")},appRouter.showWelcome=function(){Dashboard.isConnectMode()?Dashboard.navigate("connectlogin.html?mode=welcome"):Dashboard.navigate("login.html")},appRouter.showConnectLogin=function(){Dashboard.navigate("connectlogin.html")},appRouter.goHome=function(){Dashboard.navigate("home.html")},appRouter.showSearch=function(){Dashboard.navigate("search.html")},appRouter.showFavorites=function(){Dashboard.navigate("home.html?tab=1")},appRouter.showSettings=function(){Dashboard.navigate(appRouter.getRouteUrl("settings"))},appRouter.showUserMenu=function(){Dashboard.navigate(appRouter.getRouteUrl("settings"))},appRouter.showNowPlaying=function(){Dashboard.navigate("nowplaying.html")},appRouter.getRouteUrl=function(item,options){if(!item)throw new Error("item cannot be null");if(item.url)return item.url;var context=options?options.context:null,id=item.Id||item.ItemId;options=options||{};var url,itemType=item.Type||(options?options.itemType:null),serverId=item.ServerId||options.serverId;if("settings"===item)return"usermenu/usermenu.html";if("wizard"===item)return"wizardstart.html";if("downloads"===item)return"offline/offline.html";if("downloadsettings"===item)return"mysyncsettings.html";if("premiere"===item)return"supporterkey.html";if("managedownloads"===item)return"managedownloads.html";if("manageserver"===item)return"dashboard.html";if("recordedtv"===item)return"livetv/livetv.html?tab=3&serverId="+options.serverId;if("nextup"===item)return"list/list.html?type=nextup&serverId="+options.serverId;if("list"===item)return url="list/list.html?serverId="+options.serverId+"&type="+options.itemTypes,options.isFavorite&&(url+="&IsFavorite=true"),url;if("livetv"===item)return"programs"===options.section?"livetv/livetv.html?tab=0&serverId="+options.serverId:"guide"===options.section?"livetv/livetv.html?tab=1&serverId="+options.serverId:"movies"===options.section?"list/list.html?type=Program&IsMovie=true&serverId="+options.serverId:"shows"===options.section?"list/list.html?type=Program&IsSeries=true&IsMovie=false&IsNews=false&serverId="+options.serverId:"sports"===options.section?"list/list.html?type=Program&IsSports=true&serverId="+options.serverId:"kids"===options.section?"list/list.html?type=Program&IsKids=true&serverId="+options.serverId:"news"===options.section?"list/list.html?type=Program&IsNews=true&serverId="+options.serverId:"onnow"===options.section?"list/list.html?type=Program&IsAiring=true&serverId="+options.serverId:"dvrschedule"===options.section?"livetv/livetv.html?tab=4&serverId="+options.serverId:"livetv/livetv.html?serverId="+options.serverId;if("SeriesTimer"===itemType)return"item/item.html?seriesTimerId="+id+"&serverId="+serverId;if("Device"===itemType)return"devices/device.html?id="+id;if("Plugin"===itemType)return Dashboard.allowPluginPages(item.Id)?item.ConfigPageUrl:null;if("User"===itemType)return"useredit.html?userId="+id;if("livetv"===item.CollectionType)return"livetv/livetv.html?serverId="+item.ServerId;if("Genre"===item.Type)return url="list/list.html?genreId="+item.Id+"&serverId="+serverId,"livetv"===context&&(url+="&type=Program"),options.parentId&&(url+="&parentId="+options.parentId),url;if("GameGenre"===item.Type)return url="list/list.html?gameGenreId="+item.Id+"&serverId="+serverId,options.parentId&&(url+="&parentId="+options.parentId),url;if("MusicGenre"===item.Type)return url="list/list.html?musicGenreId="+item.Id+"&serverId="+serverId,options.parentId&&(url+="&parentId="+options.parentId),url;if("Studio"===item.Type)return url="list/list.html?studioId="+item.Id+"&serverId="+serverId,options.parentId&&(url+="&parentId="+options.parentId),url;if("Tag"===item.Type)return url="list/list.html?tagId="+item.Id+"&serverId="+serverId,options.parentId&&(url+="&parentId="+options.parentId),url;if("folders"!==context&&"GameSystem"===item.Type)return url="list/list.html?serverId="+serverId,url+="&type=Game&parentId="+id;if("folders"!==context&&!itemHelper.isLocalItem(item)){if("movies"===item.CollectionType)return url="movies/movies.html?parentId="+item.Id+"&serverId="+item.ServerId,options&&"latest"===options.section&&(url+="&tab=1"),url;if("games"===item.CollectionType)return url="games/games.html?parentId="+item.Id+"&serverId="+item.ServerId;if("homevideos"===item.CollectionType)return url="homevideos/homevideos.html?parentId="+item.Id+"&serverId="+item.ServerId;if("musicvideos"===item.CollectionType)return url="musicvideos/musicvideos.html?parentId="+item.Id+"&serverId="+item.ServerId;if("tvshows"===item.CollectionType)return url="tv/tv.html?parentId="+item.Id+"&serverId="+item.ServerId,options&&"latest"===options.section&&(url+="&tab=1"),url;if("music"===item.CollectionType||"audiobooks"===item.CollectionType)return"music/music.html?parentId="+item.Id+"&serverId="+item.ServerId}return"Playlist"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"TvChannel"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"Program"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"BoxSet"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"MusicAlbum"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"MusicGenre"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"Person"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"Recording"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"MusicArtist"===itemType?"item/item.html?id="+id+"&serverId="+serverId:"Series"===itemType||"Season"===itemType||"Episode"===itemType?"item/item.html?id="+id+(context?"&context="+context:"")+"&serverId="+serverId:item.IsFolder?id?"list/list.html?parentId="+id+"&serverId="+serverId:"#":"item/item.html?id="+id+"&serverId="+serverId},appRouter.showItem=function(item,serverId,options){if("string"==typeof item)require(["connectionManager"],function(connectionManager){var apiClient=connectionManager.currentApiClient();apiClient.getItem(apiClient.getCurrentUserId(),item).then(function(item){appRouter.showItem(item,options)})});else{if("Plugin"===item.Type){if(!item.ConfigPageUrl)return showTranslatedAlert("NoPluginConfigurationMessage");if(!Dashboard.allowPluginPages(item.Id))return showTranslatedAlert("MessagePluginConfigurationRequiresLocalAccess")}2===arguments.length&&(options=serverId),appRouter.show("/"+appRouter.getRouteUrl(item,options),{item:item})}},appRouter}),require(["css!css/site"]),require(["browser"],function(browser){var initialDependencies=[];!function(browser){var apiClientBowerPath="bower_components/emby-apiclient",embyWebComponentsBowerPath="bower_components/emby-webcomponents";"android"===self.appMode?define("iapManager",["cordova/iap"],returnFirstDependency):"cordova"===self.appMode?define("iapManager",["cordova/iap"],returnFirstDependency):define("iapManager",["components/iap"],returnFirstDependency),"android"===self.appMode?(define("filesystem",["cordova/filesystem"],returnFirstDependency),define("cameraRoll",["cordova/cameraroll"],returnFirstDependency)):(define("filesystem",[embyWebComponentsBowerPath+"/filesystem"],returnFirstDependency),define("cameraRoll",[apiClientBowerPath+"/cameraroll"],returnFirstDependency)),window.IntersectionObserver?define("lazyLoader",[embyWebComponentsBowerPath+"/lazyloader/lazyloader-intersectionobserver"],returnFirstDependency):define("lazyLoader",[embyWebComponentsBowerPath+"/lazyloader/lazyloader-scroll"],returnFirstDependency),"android"===self.appMode?define("shell",["cordova/shell"],returnFirstDependency):define("shell",[embyWebComponentsBowerPath+"/shell"],returnFirstDependency),"cordova"===self.appMode||"android"===self.appMode&&AndroidAppHost.supportsSync()?(define("apiclientcore",["bower_components/emby-apiclient/apiclient"],returnFirstDependency),define("apiclient",["bower_components/emby-apiclient/apiclientex"],returnFirstDependency)):define("apiclient",["bower_components/emby-apiclient/apiclient"],returnFirstDependency),"cordova"===self.appMode||"android"===self.appMode?define("wakeOnLan",["cordova/wakeonlan"],returnFirstDependency):define("wakeOnLan",["bower_components/emby-apiclient/wakeonlan"],returnFirstDependency),define("actionsheet",["webActionSheet"],returnFirstDependency),"android"===self.appMode?define("serverdiscovery",["cordova/serverdiscovery"],returnFirstDependency):"cordova"===self.appMode?define("serverdiscovery",["cordova/serverdiscovery"],returnFirstDependency):define("serverdiscovery",[apiClientBowerPath+"/serverdiscovery"],returnFirstDependency),browser.tizen||browser.operaTv||browser.chromecast||browser.orsay||browser.web0s||browser.netcast||browser.ps4?define("loading",[embyWebComponentsBowerPath+"/loading/loading-legacy"],returnFirstDependency):define("loading",[embyWebComponentsBowerPath+"/loading/loading-lite"],returnFirstDependency),define("multi-download",[embyWebComponentsBowerPath+"/multidownload"],returnFirstDependency),"android"===self.appMode?define("fileDownloader",["cordova/filedownloader"],returnFirstDependency):define("fileDownloader",[embyWebComponentsBowerPath+"/filedownloader"],returnFirstDependency),define("localassetmanager",[apiClientBowerPath+"/localassetmanager"],returnFirstDependency),"cordova"===self.appMode||"android"===self.appMode?define("castSenderApiLoader",[],getDummyCastSenderApiLoader):define("castSenderApiLoader",[],getCastSenderApiLoader),self.Windows?(define("bgtaskregister",["environments/windows-uwp/bgtaskregister"],returnFirstDependency),define("transfermanager",["environments/windows-uwp/transfermanager"],returnFirstDependency),define("filerepository",["environments/windows-uwp/filerepository"],returnFirstDependency)):"cordova"===self.appMode?(define("filerepository",["cordova/filerepository"],returnFirstDependency),define("transfermanager",["filerepository"],returnFirstDependency)):"android"===self.appMode&&AndroidAppHost.supportsSync()?(define("transfermanager",["cordova/transfermanager"],returnFirstDependency),define("filerepository",["cordova/filerepository"],returnFirstDependency)):(define("transfermanager",[apiClientBowerPath+"/sync/transfermanager"],returnFirstDependency),define("filerepository",[apiClientBowerPath+"/sync/filerepository"],returnFirstDependency)),"android"===self.appMode&&AndroidAppHost.supportsSync()?define("localsync",["cordova/localsync"],returnFirstDependency):define("localsync",[apiClientBowerPath+"/sync/localsync"],returnFirstDependency)}(browser),"cordova"!==self.appMode&&"android"!==self.appMode||(AppInfo.isNativeApp=!0),initialDependencies.push("scripts/babelhelpers"),self.ResizeObserver||initialDependencies.push("bower_components/emby-webcomponents/resize-observer-polyfill/ResizeObserver"),browser.msie?"registerElement"in document||initialDependencies.push("bower_components/webcomponentsjs/webcomponents-lite.min"):"customElements"in self?browser.customBuiltInElements||initialDependencies.push("bower_components/document-register-element/custom-elements-builtin"):initialDependencies.push("bower_components/document-register-element/document-register-element"),require(initialDependencies,init)})}();