/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.utils;

import org.elasticsearch.geo.geometry.Circle;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryCollection;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.LinearRing;
import org.elasticsearch.geo.geometry.MultiLine;
import org.elasticsearch.geo.geometry.MultiPoint;
import org.elasticsearch.geo.geometry.MultiPolygon;
import org.elasticsearch.geo.geometry.Point;
import org.elasticsearch.geo.geometry.Polygon;
import org.elasticsearch.geo.geometry.Rectangle;
import org.elasticsearch.geo.utils.GeometryValidator;

public class GeographyValidator
implements GeometryValidator {
    private static final double MIN_LON_INCL = -180.0;
    private static final double MAX_LON_INCL = 180.0;
    private static final double MIN_LAT_INCL = -90.0;
    private static final double MAX_LAT_INCL = 90.0;
    private final boolean ignoreZValue;

    public GeographyValidator(boolean ignoreZValue) {
        this.ignoreZValue = ignoreZValue;
    }

    protected void checkLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + latitude + "; must be between " + -90.0 + " and " + 90.0);
        }
    }

    protected void checkLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + longitude + "; must be between " + -180.0 + " and " + 180.0);
        }
    }

    protected void checkAltitude(double zValue) {
        if (!this.ignoreZValue && !Double.isNaN(zValue)) {
            throw new IllegalArgumentException("found Z value [" + zValue + "] but [ignore_z_value] parameter is [" + this.ignoreZValue + "]");
        }
    }

    @Override
    public void validate(Geometry geometry) {
        geometry.visit(new GeometryVisitor<Void, RuntimeException>(){

            @Override
            public Void visit(Circle circle) throws RuntimeException {
                GeographyValidator.this.checkLatitude(circle.getLat());
                GeographyValidator.this.checkLongitude(circle.getLon());
                GeographyValidator.this.checkAltitude(circle.getAlt());
                return null;
            }

            @Override
            public Void visit(GeometryCollection<?> collection) throws RuntimeException {
                for (Geometry g : collection) {
                    g.visit(this);
                }
                return null;
            }

            @Override
            public Void visit(Line line) throws RuntimeException {
                for (int i = 0; i < line.length(); ++i) {
                    GeographyValidator.this.checkLatitude(line.getLat(i));
                    GeographyValidator.this.checkLongitude(line.getLon(i));
                    GeographyValidator.this.checkAltitude(line.getAlt(i));
                }
                return null;
            }

            @Override
            public Void visit(LinearRing ring) throws RuntimeException {
                for (int i = 0; i < ring.length(); ++i) {
                    GeographyValidator.this.checkLatitude(ring.getLat(i));
                    GeographyValidator.this.checkLongitude(ring.getLon(i));
                    GeographyValidator.this.checkAltitude(ring.getAlt(i));
                }
                return null;
            }

            @Override
            public Void visit(MultiLine multiLine) throws RuntimeException {
                return this.visit((GeometryCollection)multiLine);
            }

            @Override
            public Void visit(MultiPoint multiPoint) throws RuntimeException {
                return this.visit((GeometryCollection)multiPoint);
            }

            @Override
            public Void visit(MultiPolygon multiPolygon) throws RuntimeException {
                return this.visit((GeometryCollection)multiPolygon);
            }

            @Override
            public Void visit(Point point) throws RuntimeException {
                GeographyValidator.this.checkLatitude(point.getLat());
                GeographyValidator.this.checkLongitude(point.getLon());
                GeographyValidator.this.checkAltitude(point.getAlt());
                return null;
            }

            @Override
            public Void visit(Polygon polygon) throws RuntimeException {
                polygon.getPolygon().visit(this);
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    polygon.getHole(i).visit(this);
                }
                return null;
            }

            @Override
            public Void visit(Rectangle rectangle) throws RuntimeException {
                GeographyValidator.this.checkLatitude(rectangle.getMinLat());
                GeographyValidator.this.checkLatitude(rectangle.getMaxLat());
                GeographyValidator.this.checkLongitude(rectangle.getMinLon());
                GeographyValidator.this.checkLongitude(rectangle.getMaxLon());
                GeographyValidator.this.checkAltitude(rectangle.getMinAlt());
                GeographyValidator.this.checkAltitude(rectangle.getMaxAlt());
                return null;
            }
        });
    }
}

