/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.File;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class FileContent {
    public static final long NULL_TIMESTAMP = -1L;
    public static final long NULL_FILE_SIZE = -1L;

    public abstract String getFileLocation();

    public abstract long getTimestamp();

    public abstract long getReadTime();

    public abstract long getFileSize();

    public abstract boolean hasError();

    public abstract long getContentsHash();

    public static FileContent create(String filePath, char[] contents) {
        return new InternalFileContent(filePath, new CharArray(contents));
    }

    public static FileContent create(String filePath, boolean isSource, char[] contents) {
        InternalFileContent fileContent = new InternalFileContent(filePath, new CharArray(contents));
        fileContent.setIsSource(isSource);
        return fileContent;
    }

    public static FileContent create(ITranslationUnit tu) {
        IResource res;
        IPath location = tu.getLocation();
        InternalFileContent fileContent = location == null ? new InternalFileContent(tu.getElementName(), new CharArray(tu.getContents())) : (tu.isWorkingCopy() ? new InternalFileContent(location.toOSString(), new CharArray(tu.getContents())) : ((res = tu.getResource()) instanceof IFile ? InternalParserUtil.createWorkspaceFileContent((IFile)res) : InternalParserUtil.createExternalFileContent(location.toOSString(), InternalParserUtil.SYSTEM_DEFAULT_ENCODING)));
        if (fileContent != null) {
            fileContent.setTranslationUnit(tu);
            fileContent.setIsSource(tu.isSourceUnit());
        }
        return fileContent;
    }

    public static FileContent create(IIndexFileLocation ifl) {
        return InternalParserUtil.createFileContent(ifl);
    }

    public static FileContent create(IFile file) {
        return InternalParserUtil.createWorkspaceFileContent(file);
    }

    public static FileContent createForExternalFileLocation(String fileLocation) {
        return FileContent.createForExternalFileLocation(fileLocation, InternalParserUtil.SYSTEM_DEFAULT_ENCODING);
    }

    public static FileContent createForExternalFileLocation(String fileLocation, String encoding) {
        return FileContent.createForExternalFileLocation(fileLocation, false, encoding);
    }

    public static FileContent createForExternalFileLocation(String fileLocation, boolean isSource, String encoding) {
        InternalFileContent fileContent = InternalParserUtil.createExternalFileContent(fileLocation, encoding);
        if (fileContent != null) {
            fileContent.setIsSource(isSource);
        }
        return fileContent;
    }

    @Deprecated
    public static FileContent adapt(CodeReader reader) {
        if (reader == null) {
            return null;
        }
        long fileReadTime = System.currentTimeMillis();
        CharArray chars = new CharArray(reader.buffer);
        String filePath = reader.getPath();
        File file = new File(filePath);
        return new InternalFileContent(filePath, chars, file.lastModified(), file.length(), fileReadTime);
    }
}

