/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class RemoveInternalDirectiveEntryResolution
extends AbstractManifestMarkerResolution {
    private String fPackageName;

    public RemoveInternalDirectiveEntryResolution(int type, String packageName, IMarker marker) {
        super(type, marker);
        this.fPackageName = packageName;
    }

    @Override
    protected void createChange(BundleModel model) {
        ExportPackageObject exportedPackage;
        this.fPackageName = this.marker.getAttribute("packageName", null);
        IManifestHeader header = model.getBundle().getManifestHeader("Export-Package");
        if (header instanceof ExportPackageHeader && (exportedPackage = ((ExportPackageHeader)header).getPackage(this.fPackageName)) != null) {
            exportedPackage.removeInternalDirective();
        }
    }

    public String getLabel() {
        return PDEUIMessages.RemoveInternalDirective_label;
    }

    @Override
    public String getDescription() {
        return PDEUIMessages.RemoveInternalDirective_desc;
    }
}

