/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.css.CSSUnknownRule;

public class UnknownRuleFormatter
extends DefaultCSSSourceFormatter {
    private static UnknownRuleFormatter instance;

    UnknownRuleFormatter() {
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int start = ((IndexedRegion)node).getStartOffset();
        int end = ((IndexedRegion)node).getEndOffset();
        if (end > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedPropValueRegion(regions[i], stgy));
                ++i;
            }
        } else {
            CSSUnknownRule rule = (CSSUnknownRule)((Object)node);
            source.append(rule.getCssText());
        }
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || UnknownRuleFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedPropValueRegion(regions[i], stgy));
            ++i;
        }
        if (UnknownRuleFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    public static synchronized UnknownRuleFormatter getInstance() {
        if (instance == null) {
            instance = new UnknownRuleFormatter();
        }
        return instance;
    }
}

