/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal;

import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.buildship.core.internal.CoreTraceScopes;
import org.eclipse.buildship.core.internal.Logger;
import org.eclipse.buildship.core.internal.configuration.ConfigurationManager;
import org.eclipse.buildship.core.internal.configuration.DefaultConfigurationManager;
import org.eclipse.buildship.core.internal.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.internal.console.StdProcessStreamsProvider;
import org.eclipse.buildship.core.internal.event.DefaultListenerRegistry;
import org.eclipse.buildship.core.internal.event.ListenerRegistry;
import org.eclipse.buildship.core.internal.extension.DefaultExtensionManager;
import org.eclipse.buildship.core.internal.extension.ExtensionManager;
import org.eclipse.buildship.core.internal.invocation.InvocationCustomizerCollector;
import org.eclipse.buildship.core.internal.launch.DefaultExternalLaunchConfigurationManager;
import org.eclipse.buildship.core.internal.launch.DefaultGradleLaunchConfigurationManager;
import org.eclipse.buildship.core.internal.launch.ExternalLaunchConfigurationManager;
import org.eclipse.buildship.core.internal.launch.GradleLaunchConfigurationManager;
import org.eclipse.buildship.core.internal.operation.DefaultToolingApiOperationManager;
import org.eclipse.buildship.core.internal.operation.ToolingApiOperationManager;
import org.eclipse.buildship.core.internal.preferences.DefaultModelPersistence;
import org.eclipse.buildship.core.internal.preferences.ModelPersistence;
import org.eclipse.buildship.core.internal.util.gradle.IdeFriendlyClassLoading;
import org.eclipse.buildship.core.internal.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.core.internal.util.logging.EclipseLogger;
import org.eclipse.buildship.core.internal.workspace.DefaultGradleWorkspace;
import org.eclipse.buildship.core.internal.workspace.DefaultWorkspaceOperations;
import org.eclipse.buildship.core.internal.workspace.InternalGradleWorkspace;
import org.eclipse.buildship.core.internal.workspace.ProjectChangeListener;
import org.eclipse.buildship.core.internal.workspace.SynchronizingBuildScriptUpdateListener;
import org.eclipse.buildship.core.internal.workspace.WorkspaceOperations;
import org.eclipse.buildship.core.invocation.InvocationCustomizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public final class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.buildship.core";
    public static final String GRADLE_JOB_FAMILY = "org.eclipse.buildship.core.jobs";
    private static CorePlugin plugin;
    private ServiceRegistration loggerService;
    private ServiceRegistration publishedGradleVersionsService;
    private ServiceRegistration workspaceOperationsService;
    private ServiceRegistration internalGradleWorkspaceService;
    private ServiceRegistration processStreamsProviderService;
    private ServiceRegistration gradleLaunchConfigurationService;
    private ServiceRegistration listenerRegistryService;
    private ServiceTracker loggerServiceTracker;
    private ServiceTracker publishedGradleVersionsServiceTracker;
    private ServiceTracker workspaceOperationsServiceTracker;
    private ServiceTracker internalGradleWorkspaceServiceTracker;
    private ServiceTracker processStreamsProviderServiceTracker;
    private ServiceTracker gradleLaunchConfigurationServiceTracker;
    private ServiceTracker listenerRegistryServiceTracker;
    private DefaultModelPersistence modelPersistence;
    private ProjectChangeListener projectChangeListener;
    private SynchronizingBuildScriptUpdateListener buildScriptUpdateListener;
    private InvocationCustomizer invocationCustomizer;
    private ConfigurationManager configurationManager;
    private DefaultExternalLaunchConfigurationManager externalLaunchConfigurationManager;
    private ToolingApiOperationManager operationManager;
    private ExtensionManager extensionManager;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.ensureProxySettingsApplied();
        this.registerServices(bundleContext);
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterServices();
        IdeFriendlyClassLoading.cleanup();
        plugin = null;
        super.stop(context);
    }

    private void ensureProxySettingsApplied() throws Exception {
        Platform.getBundle((String)"org.eclipse.core.net").start(1);
    }

    private void registerServices(BundleContext context) {
        Hashtable<String, Object> preferences = new Hashtable<String, Object>();
        ((Dictionary)preferences).put("service.ranking", 1);
        this.loggerServiceTracker = this.createServiceTracker(context, Logger.class);
        this.publishedGradleVersionsServiceTracker = this.createServiceTracker(context, PublishedGradleVersionsWrapper.class);
        this.workspaceOperationsServiceTracker = this.createServiceTracker(context, WorkspaceOperations.class);
        this.internalGradleWorkspaceServiceTracker = this.createServiceTracker(context, InternalGradleWorkspace.class);
        this.processStreamsProviderServiceTracker = this.createServiceTracker(context, ProcessStreamsProvider.class);
        this.gradleLaunchConfigurationServiceTracker = this.createServiceTracker(context, GradleLaunchConfigurationManager.class);
        this.listenerRegistryServiceTracker = this.createServiceTracker(context, ListenerRegistry.class);
        this.loggerService = this.registerService(context, Logger.class, this.createLogger(), preferences);
        this.publishedGradleVersionsService = this.registerService(context, PublishedGradleVersionsWrapper.class, this.createPublishedGradleVersions(), preferences);
        this.workspaceOperationsService = this.registerService(context, WorkspaceOperations.class, this.createWorkspaceOperations(), preferences);
        this.internalGradleWorkspaceService = this.registerService(context, InternalGradleWorkspace.class, this.createGradleWorkspace(), preferences);
        this.processStreamsProviderService = this.registerService(context, ProcessStreamsProvider.class, this.createProcessStreamsProvider(), preferences);
        this.gradleLaunchConfigurationService = this.registerService(context, GradleLaunchConfigurationManager.class, this.createGradleLaunchConfigurationManager(), preferences);
        this.listenerRegistryService = this.registerService(context, ListenerRegistry.class, this.createListenerRegistry(), preferences);
        this.modelPersistence = DefaultModelPersistence.createAndRegister();
        this.projectChangeListener = ProjectChangeListener.createAndRegister();
        this.buildScriptUpdateListener = SynchronizingBuildScriptUpdateListener.createAndRegister();
        this.invocationCustomizer = new InvocationCustomizerCollector();
        this.configurationManager = new DefaultConfigurationManager();
        this.externalLaunchConfigurationManager = DefaultExternalLaunchConfigurationManager.createAndRegister();
        this.operationManager = new DefaultToolingApiOperationManager();
        this.extensionManager = new DefaultExtensionManager();
    }

    private ServiceTracker createServiceTracker(BundleContext context, Class<?> clazz) {
        ServiceTracker serviceTracker = new ServiceTracker(context, clazz.getName(), null);
        serviceTracker.open();
        return serviceTracker;
    }

    private <T> ServiceRegistration registerService(BundleContext context, Class<T> clazz, T service, Dictionary<String, Object> properties) {
        return context.registerService(clazz.getName(), service, properties);
    }

    private EclipseLogger createLogger() {
        HashMap tracingEnablement = Maps.newHashMap();
        for (CoreTraceScopes scope : CoreTraceScopes.values()) {
            String option = Platform.getDebugOption((String)("org.eclipse.buildship.core/trace/" + scope.getScopeKey()));
            tracingEnablement.put(scope, "true".equalsIgnoreCase(option));
        }
        return new EclipseLogger(this.getLog(), PLUGIN_ID, tracingEnablement);
    }

    private PublishedGradleVersionsWrapper createPublishedGradleVersions() {
        return new PublishedGradleVersionsWrapper();
    }

    private WorkspaceOperations createWorkspaceOperations() {
        return new DefaultWorkspaceOperations();
    }

    private InternalGradleWorkspace createGradleWorkspace() {
        return new DefaultGradleWorkspace();
    }

    private ProcessStreamsProvider createProcessStreamsProvider() {
        return new StdProcessStreamsProvider();
    }

    private GradleLaunchConfigurationManager createGradleLaunchConfigurationManager() {
        return new DefaultGradleLaunchConfigurationManager();
    }

    private ListenerRegistry createListenerRegistry() {
        return new DefaultListenerRegistry();
    }

    private void unregisterServices() {
        this.externalLaunchConfigurationManager.unregister();
        this.buildScriptUpdateListener.close();
        this.projectChangeListener.close();
        this.modelPersistence.close();
        this.listenerRegistryService.unregister();
        this.gradleLaunchConfigurationService.unregister();
        this.processStreamsProviderService.unregister();
        this.internalGradleWorkspaceService.unregister();
        this.workspaceOperationsService.unregister();
        this.publishedGradleVersionsService.unregister();
        this.loggerService.unregister();
        this.listenerRegistryServiceTracker.close();
        this.gradleLaunchConfigurationServiceTracker.close();
        this.processStreamsProviderServiceTracker.close();
        this.internalGradleWorkspaceServiceTracker.close();
        this.workspaceOperationsServiceTracker.close();
        this.publishedGradleVersionsServiceTracker.close();
        this.loggerServiceTracker.close();
    }

    public static CorePlugin getInstance() {
        return plugin;
    }

    public static Logger logger() {
        return (Logger)CorePlugin.getInstance().loggerServiceTracker.getService();
    }

    public static PublishedGradleVersionsWrapper publishedGradleVersions() {
        return (PublishedGradleVersionsWrapper)CorePlugin.getInstance().publishedGradleVersionsServiceTracker.getService();
    }

    public static WorkspaceOperations workspaceOperations() {
        return (WorkspaceOperations)CorePlugin.getInstance().workspaceOperationsServiceTracker.getService();
    }

    public static InternalGradleWorkspace internalGradleWorkspace() {
        return (InternalGradleWorkspace)CorePlugin.getInstance().internalGradleWorkspaceServiceTracker.getService();
    }

    public static ProcessStreamsProvider processStreamsProvider() {
        return (ProcessStreamsProvider)CorePlugin.getInstance().processStreamsProviderServiceTracker.getService();
    }

    public static GradleLaunchConfigurationManager gradleLaunchConfigurationManager() {
        return (GradleLaunchConfigurationManager)CorePlugin.getInstance().gradleLaunchConfigurationServiceTracker.getService();
    }

    public static ListenerRegistry listenerRegistry() {
        return (ListenerRegistry)CorePlugin.getInstance().listenerRegistryServiceTracker.getService();
    }

    public static ModelPersistence modelPersistence() {
        return CorePlugin.getInstance().modelPersistence;
    }

    public static InvocationCustomizer invocationCustomizer() {
        return CorePlugin.getInstance().invocationCustomizer;
    }

    public static ConfigurationManager configurationManager() {
        return CorePlugin.getInstance().configurationManager;
    }

    public static ExternalLaunchConfigurationManager externalLaunchConfigurationManager() {
        return CorePlugin.getInstance().externalLaunchConfigurationManager;
    }

    public static ToolingApiOperationManager operationManager() {
        return CorePlugin.getInstance().operationManager;
    }

    public static ExtensionManager extensionManager() {
        return CorePlugin.getInstance().extensionManager;
    }
}

