/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.manager.DB2AbstractDropOnlyManager;
import org.jkiss.dbeaver.ext.db2.model.DB2Package;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;

public class DB2PackageManager
extends DB2AbstractDropOnlyManager<DB2Package, DB2Schema> {
    private static final String SQL_DROP = "DROP PACKAGE %s";

    @Override
    public String buildDropStatement(DB2Package db2Package) {
        String fullyQualifiedName = db2Package.getFullyQualifiedName(DBPEvaluationContext.DDL);
        return String.format(SQL_DROP, fullyQualifiedName);
    }

    @Nullable
    public DBSObjectCache<DB2Schema, DB2Package> getObjectsCache(DB2Package db2Package) {
        return db2Package.getSchema().getPackageCache();
    }
}

