"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareReviewsController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _reviewsView = _interopRequireDefault(require("../views/reviews-view"));

var _prCheckoutController = _interopRequireDefault(require("../controllers/pr-checkout-controller"));

var _addPrReview = _interopRequireDefault(require("../mutations/add-pr-review"));

var _addPrReviewComment = _interopRequireDefault(require("../mutations/add-pr-review-comment"));

var _submitPrReview = _interopRequireDefault(require("../mutations/submit-pr-review"));

var _deletePrReview = _interopRequireDefault(require("../mutations/delete-pr-review"));

var _resolveReviewThread = _interopRequireDefault(require("../mutations/resolve-review-thread"));

var _unresolveReviewThread = _interopRequireDefault(require("../mutations/unresolve-review-thread"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Milliseconds to update highlightedThreadIDs
const FLASH_DELAY = 1500;

class BareReviewsController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openFile", async (filePath, lineNumber) => {
      await this.props.workspace.open(filePath, {
        initialLine: lineNumber - 1,
        initialColumn: 0,
        pending: true
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-file', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openDiff", async (filePath, lineNumber) => {
      const item = await this.getPRDetailItem();
      item.openFilesTab({
        changedFilePath: filePath,
        changedFilePosition: lineNumber
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-diff', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "openPR", async () => {
      await this.getPRDetailItem();
      (0, _reporterProxy.addEvent)('reviews-dock-open-pr', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "getPRDetailItem", () => {
      return this.props.workspace.open(_issueishDetailItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir
      }), {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "moreContext", () => {
      this.setState(prev => ({
        contextLines: prev.contextLines + 1
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-more-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "lessContext", () => {
      this.setState(prev => ({
        contextLines: Math.max(prev.contextLines - 1, 1)
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-less-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openIssueish", async (owner, repo, number) => {
      const host = this.props.endpoint.getHost();
      const homeRepository = (await this.props.localRepository.hasGitHubRemote(host, owner, repo)) ? this.props.localRepository : (await this.props.workdirContextPool.getMatchingContext(host, owner, repo)).getRepository();

      const uri = _issueishDetailItem["default"].buildURI({
        host,
        owner,
        repo,
        number,
        workdir: homeRepository.getWorkingDirectoryPath()
      });

      return this.props.workspace.open(uri, {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "showSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: false
    }, resolve)));

    _defineProperty(this, "showComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: false
    }, resolve)));

    _defineProperty(this, "showThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen.add(commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "hideThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen["delete"](commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "highlightThread", threadID => {
      this.setState(state => {
        state.highlightedThreadIDs.add(threadID);
        return {};
      }, () => {
        setTimeout(() => this.setState(state => {
          state.highlightedThreadIDs["delete"](threadID);

          if (state.scrollToThreadID === threadID) {
            return {
              scrollToThreadID: null
            };
          }

          return {};
        }), FLASH_DELAY);
      });
    });

    _defineProperty(this, "resolveThread", async thread => {
      if (thread.viewerCanResolve) {
        // optimistically hide the thread to avoid jankiness;
        // if the operation fails, the onError callback will revert it.
        this.hideThreadID(thread.id);

        try {
          await (0, _resolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          this.highlightThread(thread.id);
          (0, _reporterProxy.addEvent)('resolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.showThreadID(thread.id);
          this.props.reportMutationErrors('Unable to resolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "unresolveThread", async thread => {
      if (thread.viewerCanUnresolve) {
        try {
          await (0, _unresolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          this.highlightThread(thread.id);
          (0, _reporterProxy.addEvent)('unresolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.props.reportMutationErrors('Unable to unresolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "addSingleComment", async (commentBody, threadID, replyToID, path, position, callbacks = {}) => {
      let pendingReviewID = null;

      try {
        this.setState({
          postingToThreadID: threadID
        });
        const reviewResult = await (0, _addPrReview["default"])(this.props.relay.environment, {
          pullRequestID: this.props.pullRequest.id,
          viewerID: this.props.viewer.id
        });
        const reviewID = reviewResult.addPullRequestReview.reviewEdge.node.id;
        pendingReviewID = reviewID;
        const commentPromise = (0, _addPrReviewComment["default"])(this.props.relay.environment, {
          body: commentBody,
          inReplyTo: replyToID,
          reviewID,
          threadID,
          viewerID: this.props.viewer.id,
          path,
          position
        });

        if (callbacks.didSubmitComment) {
          callbacks.didSubmitComment();
        }

        await commentPromise;
        pendingReviewID = null;
        await (0, _submitPrReview["default"])(this.props.relay.environment, {
          event: 'COMMENT',
          reviewID
        });
        (0, _reporterProxy.addEvent)('add-single-comment', {
          "package": 'github'
        });
      } catch (error) {
        if (callbacks.didFailComment) {
          callbacks.didFailComment();
        }

        if (pendingReviewID !== null) {
          try {
            await (0, _deletePrReview["default"])(this.props.relay.environment, {
              reviewID: pendingReviewID,
              pullRequestID: this.props.pullRequest.id
            });
          } catch (e) {
            /* istanbul ignore else */
            if (error.errors && e.errors) {
              error.errors.push(...e.errors);
            } else {
              // eslint-disable-next-line no-console
              console.warn('Unable to delete pending review', e);
            }
          }
        }

        this.props.reportMutationErrors('Unable to submit your comment', error);
      } finally {
        this.setState({
          postingToThreadID: null
        });
      }
    });

    this.state = {
      contextLines: 4,
      postingToThreadID: null,
      scrollToThreadID: this.props.initThreadID,
      summarySectionOpen: true,
      commentSectionOpen: true,
      threadIDsOpen: new Set(this.props.initThreadID ? [this.props.initThreadID] : []),
      highlightedThreadIDs: new Set()
    };
  }

  componentDidMount() {
    const {
      scrollToThreadID
    } = this.state;

    if (scrollToThreadID) {
      this.highlightThread(scrollToThreadID);
    }
  }

  componentDidUpdate(prevProps) {
    const {
      initThreadID
    } = this.props;

    if (initThreadID && initThreadID !== prevProps.initThreadID) {
      this.setState(prev => {
        prev.threadIDsOpen.add(initThreadID);
        this.highlightThread(initThreadID);
        return {
          commentSectionOpen: true,
          scrollToThreadID: initThreadID
        };
      });
    }
  }

  render() {
    return _react["default"].createElement(_prCheckoutController["default"], {
      repository: this.props.repository,
      pullRequest: this.props.pullRequest,
      localRepository: this.props.localRepository,
      isAbsent: this.props.isAbsent,
      isLoading: this.props.isLoading,
      isPresent: this.props.isPresent,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      branches: this.props.branches,
      remotes: this.props.remotes
    }, checkoutOp => _react["default"].createElement(_reviewsView["default"], _extends({
      checkoutOp: checkoutOp,
      contextLines: this.state.contextLines,
      postingToThreadID: this.state.postingToThreadID,
      summarySectionOpen: this.state.summarySectionOpen,
      commentSectionOpen: this.state.commentSectionOpen,
      threadIDsOpen: this.state.threadIDsOpen,
      highlightedThreadIDs: this.state.highlightedThreadIDs,
      scrollToThreadID: this.state.scrollToThreadID,
      moreContext: this.moreContext,
      lessContext: this.lessContext,
      openFile: this.openFile,
      openDiff: this.openDiff,
      openPR: this.openPR,
      openIssueish: this.openIssueish,
      showSummaries: this.showSummaries,
      hideSummaries: this.hideSummaries,
      showComments: this.showComments,
      hideComments: this.hideComments,
      showThreadID: this.showThreadID,
      hideThreadID: this.hideThreadID,
      resolveThread: this.resolveThread,
      unresolveThread: this.unresolveThread,
      addSingleComment: this.addSingleComment
    }, this.props)));
  }

}

exports.BareReviewsController = BareReviewsController;

_defineProperty(BareReviewsController, "propTypes", {
  // Relay results
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  viewer: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  repository: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  summaries: _propTypes["default"].array.isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  refetch: _propTypes["default"].func.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  localRepository: _propTypes["default"].object.isRequired,
  isAbsent: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  isPresent: _propTypes["default"].bool.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  multiFilePatch: _propTypes["default"].object.isRequired,
  initThreadID: _propTypes["default"].string,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // URL parameters
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportMutationErrors: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareReviewsController, {
  viewer: function () {
    const node = require("./__generated__/reviewsController_viewer.graphql");

    if (node.hash && node.hash !== "e9e4cf88f2d8a809620a0f225d502896") {
      console.error("The definition of 'reviewsController_viewer' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_viewer.graphql");
  },
  repository: function () {
    const node = require("./__generated__/reviewsController_repository.graphql");

    if (node.hash && node.hash !== "1e0016aed6db6035651ff6213eb38ff6") {
      console.error("The definition of 'reviewsController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_repository.graphql");
  },
  pullRequest: function () {
    const node = require("./__generated__/reviewsController_pullRequest.graphql");

    if (node.hash && node.hash !== "9d67f9908ab4ed776af5f1ee14f61ccb") {
      console.error("The definition of 'reviewsController_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_pullRequest.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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