/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkListener;
import processing.app.Theme;

public class NotificationPopup
extends JDialog {
    private Timer autoCloseTimer = new Timer(false);
    private boolean autoClose = true;

    public NotificationPopup(Frame parent, HyperlinkListener hyperlinkListener, String message) {
        this(parent, hyperlinkListener, message, true);
    }

    public NotificationPopup(final Frame parent, HyperlinkListener hyperlinkListener, String message, boolean _autoClose) {
        super(parent, false);
        this.autoClose = _autoClose;
        this.setLayout(new FlowLayout());
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setResizable(false);
        Image arduino = Theme.getLibImage("arduino", this, Theme.scale(40), Theme.scale(40));
        JLabel arduinoIcon = new JLabel(new ImageIcon(arduino));
        this.add(arduinoIcon);
        JEditorPane text = new JEditorPane();
        text.setBorder(new LineBorder(new Color(0, 0, 0), 0, true));
        text.setContentType("text/html");
        text.setOpaque(false);
        text.setEditable(false);
        text.setText("<html><body style=\"font-family:sans-serif; font-size: " + Theme.scale(14) + ";\">  " + message + "  </body></html>");
        text.addHyperlinkListener(hyperlinkListener);
        this.add(text);
        Image close = Theme.getThemeImage("close", this, Theme.scale(22), Theme.scale(22));
        JButton closeButton = new JButton(new ImageIcon(close));
        closeButton.setBorder(null);
        closeButton.setBorderPainted(false);
        closeButton.setHideActionText(true);
        closeButton.setOpaque(false);
        closeButton.setBackground(new Color(0, 0, 0, 0));
        this.add(closeButton);
        MouseAdapter closeOnClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NotificationPopup.this.close();
            }
        };
        this.addMouseListener(closeOnClick);
        text.addMouseListener(closeOnClick);
        arduinoIcon.addMouseListener(closeOnClick);
        closeButton.addMouseListener(closeOnClick);
        this.pack();
        this.updateLocation(parent);
        final ComponentAdapter parentMovedListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                NotificationPopup.this.updateLocation(parent);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                NotificationPopup.this.updateLocation(parent);
            }
        };
        parent.addComponentListener(parentMovedListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                parent.removeComponentListener(parentMovedListener);
            }
        });
    }

    private void updateLocation(Frame parent) {
        Point parentLocation = parent.getLocation();
        int parentX = Double.valueOf(parentLocation.getX()).intValue();
        int parentY = Double.valueOf(parentLocation.getY()).intValue();
        this.setLocation(parentX, parentY + parent.getHeight() - this.getHeight());
    }

    public void close() {
        if (this.autoClose) {
            this.autoCloseTimer.cancel();
        }
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void begin() {
        if (this.autoClose) {
            this.autoCloseTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    NotificationPopup.this.close();
                }
            }, 10000L);
        }
        this.setVisible(true);
    }
}

