/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import com.eteks.sweethome3d.viewcontroller.WizardController;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class BackgroundImageWizardController
extends WizardController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private final BackgroundImageWizardStepState imageChoiceStepState;
    private final BackgroundImageWizardStepState imageScaleStepState;
    private final BackgroundImageWizardStepState imageOriginStepState;
    private View stepsView;
    private Step step;
    private BackgroundImage referenceBackgroundImage;
    private Content image;
    private Float scaleDistance;
    private float scaleDistanceXStart;
    private float scaleDistanceYStart;
    private float scaleDistanceXEnd;
    private float scaleDistanceYEnd;
    private float xOrigin;
    private float yOrigin;

    public BackgroundImageWizardController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        super(userPreferences, viewFactory);
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setTitle(userPreferences.getLocalizedString(BackgroundImageWizardController.class, "wizard.title", new Object[0]));
        this.setResizable(true);
        this.imageChoiceStepState = new ImageChoiceStepState();
        this.imageScaleStepState = new ImageScaleStepState();
        this.imageOriginStepState = new ImageOriginStepState();
        this.setStepState(this.imageChoiceStepState);
        Level level = this.home.getSelectedLevel();
        if (level != null) {
            int n;
            List<Level> list = this.home.getLevels();
            int n2 = list.indexOf(level);
            for (n = n2 - 1; n >= 0 && this.referenceBackgroundImage == null; --n) {
                this.referenceBackgroundImage = list.get(n).getBackgroundImage();
            }
            for (n = n2 + 1; n < list.size() && this.referenceBackgroundImage == null; ++n) {
                this.referenceBackgroundImage = list.get(n).getBackgroundImage();
            }
        }
    }

    @Override
    public void finish() {
        Level level = this.home.getSelectedLevel();
        BackgroundImage backgroundImage = level != null ? level.getBackgroundImage() : this.home.getBackgroundImage();
        float[][] fArray = this.getScaleDistancePoints();
        BackgroundImage backgroundImage2 = new BackgroundImage(this.getImage(), this.getScaleDistance().floatValue(), fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], this.getXOrigin(), this.getYOrigin());
        if (level != null) {
            level.setBackgroundImage(backgroundImage2);
        } else {
            this.home.setBackgroundImage(backgroundImage2);
        }
        boolean bl = backgroundImage == null;
        BackgroundImageUndoableEdit backgroundImageUndoableEdit = new BackgroundImageUndoableEdit(this.home, level, this.preferences, bl, backgroundImage, backgroundImage2);
        this.undoSupport.postEdit(backgroundImageUndoableEdit);
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    @Override
    protected BackgroundImageWizardStepState getStepState() {
        return (BackgroundImageWizardStepState)super.getStepState();
    }

    protected BackgroundImageWizardStepState getImageChoiceStepState() {
        return this.imageChoiceStepState;
    }

    protected BackgroundImageWizardStepState getImageOriginStepState() {
        return this.imageOriginStepState;
    }

    protected BackgroundImageWizardStepState getImageScaleStepState() {
        return this.imageScaleStepState;
    }

    protected View getStepsView() {
        if (this.stepsView == null) {
            BackgroundImage backgroundImage = this.home.getSelectedLevel() != null ? this.home.getSelectedLevel().getBackgroundImage() : this.home.getBackgroundImage();
            this.stepsView = this.viewFactory.createBackgroundImageWizardStepsView(backgroundImage, this.preferences, this);
        }
        return this.stepsView;
    }

    protected void setStep(Step step) {
        if (step != this.step) {
            Step step2 = this.step;
            this.step = step;
            this.propertyChangeSupport.firePropertyChange(Property.STEP.name(), (Object)step2, (Object)step);
        }
    }

    public Step getStep() {
        return this.step;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public BackgroundImage getReferenceBackgroundImage() {
        return this.referenceBackgroundImage;
    }

    public void setImage(Content content) {
        if (content != this.image) {
            Content content2 = this.image;
            this.image = content;
            this.propertyChangeSupport.firePropertyChange(Property.IMAGE.name(), content2, content);
        }
    }

    public Content getImage() {
        return this.image;
    }

    public void setScaleDistance(Float f) {
        if (f != this.scaleDistance) {
            Float f2 = this.scaleDistance;
            this.scaleDistance = f;
            this.propertyChangeSupport.firePropertyChange(Property.SCALE_DISTANCE.name(), f2, f);
        }
    }

    public Float getScaleDistance() {
        return this.scaleDistance;
    }

    public void setScaleDistancePoints(float f, float f2, float f3, float f4) {
        if (f != this.scaleDistanceXStart || f2 != this.scaleDistanceYStart || f3 != this.scaleDistanceXEnd || f4 != this.scaleDistanceYEnd) {
            float[][] fArrayArray = new float[][]{{this.scaleDistanceXStart, this.scaleDistanceYStart}, {this.scaleDistanceXEnd, this.scaleDistanceYEnd}};
            this.scaleDistanceXStart = f;
            this.scaleDistanceYStart = f2;
            this.scaleDistanceXEnd = f3;
            this.scaleDistanceYEnd = f4;
            this.propertyChangeSupport.firePropertyChange(Property.SCALE_DISTANCE_POINTS.name(), fArrayArray, new float[][]{{f, f2}, {f3, f4}});
        }
    }

    public float[][] getScaleDistancePoints() {
        return new float[][]{{this.scaleDistanceXStart, this.scaleDistanceYStart}, {this.scaleDistanceXEnd, this.scaleDistanceYEnd}};
    }

    public void setOrigin(float f, float f2) {
        Float f3;
        if (f != this.xOrigin) {
            f3 = Float.valueOf(this.xOrigin);
            this.xOrigin = f;
            this.propertyChangeSupport.firePropertyChange(Property.X_ORIGIN.name(), f3, Float.valueOf(f));
        }
        if (f2 != this.yOrigin) {
            f3 = Float.valueOf(this.yOrigin);
            this.yOrigin = f2;
            this.propertyChangeSupport.firePropertyChange(Property.Y_ORIGIN.name(), f3, Float.valueOf(f2));
        }
    }

    public float getXOrigin() {
        return this.xOrigin;
    }

    public float getYOrigin() {
        return this.yOrigin;
    }

    private class ImageOriginStepState
    extends BackgroundImageWizardStepState {
        private ImageOriginStepState() {
        }

        @Override
        public void enter() {
            super.enter();
            this.setLastStep(true);
            this.setNextStepEnabled(true);
        }

        @Override
        public Step getStep() {
            return Step.ORIGIN;
        }

        @Override
        public void goBackToPreviousStep() {
            BackgroundImageWizardController.this.setStepState(BackgroundImageWizardController.this.getImageScaleStepState());
        }
    }

    private class ImageScaleStepState
    extends BackgroundImageWizardStepState {
        public ImageScaleStepState() {
            BackgroundImageWizardController.this.addPropertyChangeListener(Property.SCALE_DISTANCE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ImageScaleStepState.this.setNextStepEnabled(BackgroundImageWizardController.this.getScaleDistance() != null);
                }
            });
        }

        @Override
        public void enter() {
            super.enter();
            this.setNextStepEnabled(BackgroundImageWizardController.this.getScaleDistance() != null);
        }

        @Override
        public Step getStep() {
            return Step.SCALE;
        }

        @Override
        public void goBackToPreviousStep() {
            BackgroundImageWizardController.this.setStepState(BackgroundImageWizardController.this.getImageChoiceStepState());
        }

        @Override
        public void goToNextStep() {
            BackgroundImageWizardController.this.setStepState(BackgroundImageWizardController.this.getImageOriginStepState());
        }
    }

    private class ImageChoiceStepState
    extends BackgroundImageWizardStepState {
        public ImageChoiceStepState() {
            BackgroundImageWizardController.this.addPropertyChangeListener(Property.IMAGE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ImageChoiceStepState.this.setNextStepEnabled(BackgroundImageWizardController.this.getImage() != null);
                }
            });
        }

        @Override
        public void enter() {
            super.enter();
            this.setFirstStep(true);
            this.setNextStepEnabled(BackgroundImageWizardController.this.getImage() != null);
        }

        @Override
        public Step getStep() {
            return Step.CHOICE;
        }

        @Override
        public void goToNextStep() {
            BackgroundImageWizardController.this.setStepState(BackgroundImageWizardController.this.getImageScaleStepState());
        }
    }

    protected abstract class BackgroundImageWizardStepState
    extends WizardController.WizardControllerStepState {
        private URL icon = BackgroundImageWizardController.class.getResource("resources/backgroundImageWizard.png");

        protected BackgroundImageWizardStepState() {
        }

        public abstract Step getStep();

        @Override
        public void enter() {
            BackgroundImageWizardController.this.setStep(this.getStep());
        }

        @Override
        public View getView() {
            return BackgroundImageWizardController.this.getStepsView();
        }

        @Override
        public URL getIcon() {
            return this.icon;
        }
    }

    private static class BackgroundImageUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final Level level;
        private final UserPreferences preferences;
        private final boolean modification;
        private final BackgroundImage oldImage;
        private final BackgroundImage image;

        private BackgroundImageUndoableEdit(Home home, Level level, UserPreferences userPreferences, boolean bl, BackgroundImage backgroundImage, BackgroundImage backgroundImage2) {
            this.home = home;
            this.level = level;
            this.preferences = userPreferences;
            this.modification = bl;
            this.oldImage = backgroundImage;
            this.image = backgroundImage2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.home.setSelectedLevel(this.level);
            if (this.level != null) {
                this.level.setBackgroundImage(this.oldImage);
            } else {
                this.home.setBackgroundImage(this.oldImage);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setSelectedLevel(this.level);
            if (this.level != null) {
                this.level.setBackgroundImage(this.image);
            } else {
                this.home.setBackgroundImage(this.image);
            }
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(BackgroundImageWizardController.class, this.modification ? "undoImportBackgroundImageName" : "undoModifyBackgroundImageName", new Object[0]);
        }
    }

    public static enum Step {
        CHOICE,
        SCALE,
        ORIGIN;

    }

    public static enum Property {
        STEP,
        IMAGE,
        SCALE_DISTANCE,
        SCALE_DISTANCE_POINTS,
        X_ORIGIN,
        Y_ORIGIN;

    }
}

