/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineArrayRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.PointArrayRetained;
import javax.media.j3d.QuadArrayRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TriangleArrayRetained;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;

abstract class IndexedGeometryArrayRetained
extends GeometryArrayRetained {
    int[] indexCoord;
    int[] indexColor;
    int[] indexNormal;
    int[][] indexTexCoord;
    int[][] indexVertexAttr;
    int indexCount = 0;
    int initialIndexIndex = 0;
    int validIndexCount = 0;
    int[] compileIndexCount;
    int[] compileIndexOffset;
    int maxCoordIndex = 0;
    int maxColorIndex = 0;
    int maxNormalIndex = 0;
    int[] maxTexCoordIndices = null;
    int[] maxVertexAttrIndices = null;

    IndexedGeometryArrayRetained() {
    }

    void createIndexedGeometryArrayData(int n) {
        int n2;
        boolean bl;
        this.indexCount = n;
        this.validIndexCount = n;
        boolean bl2 = bl = (this.vertexFormat & 0x200) == 0;
        if ((this.vertexFormat & 1) != 0 && (this.vertexFormat & 0x2000) == 0) {
            this.indexCoord = new int[n];
        }
        if ((this.vertexFormat & 2) != 0 && bl) {
            this.indexNormal = new int[n];
        }
        if ((this.vertexFormat & 4) != 0 && bl) {
            this.indexColor = new int[n];
        }
        if ((this.vertexFormat & 0x460) != 0) {
            this.indexTexCoord = new int[this.texCoordSetCount][];
            if (bl) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.indexTexCoord[n2] = new int[n];
                }
            }
            this.maxTexCoordIndices = new int[this.texCoordSetCount];
        }
        if ((this.vertexFormat & 0x1000) != 0) {
            this.indexVertexAttr = new int[this.vertexAttrCount][];
            if (bl) {
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    this.indexVertexAttr[n2] = new int[n];
                }
            }
            this.maxVertexAttrIndices = new int[this.vertexAttrCount];
        }
    }

    GeometryArrayRetained cloneNonIndexedGeometry() {
        GeometryArrayRetained geometryArrayRetained = null;
        switch (this.geoType) {
            case 11: {
                geometryArrayRetained = new LineArrayRetained();
                break;
            }
            case 10: {
                geometryArrayRetained = new PointArrayRetained();
                break;
            }
            case 8: {
                geometryArrayRetained = new QuadArrayRetained();
                break;
            }
            case 9: {
                geometryArrayRetained = new TriangleArrayRetained();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        geometryArrayRetained.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap, this.vertexAttrCount, this.vertexAttrSizes);
        geometryArrayRetained.cloneSourceArray = this;
        geometryArrayRetained.unIndexify(this);
        geometryArrayRetained.source = this.source;
        return geometryArrayRetained;
    }

    int getIndexCount() {
        return this.indexCount;
    }

    void doErrorCheck(int n) {
        this.doCoordCheck(n);
        if ((this.vertexFormat & 0x200) != 0) {
            int n2;
            if ((this.vertexFormat & 4) != 0) {
                this.doColorCheck(n);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.doTexCoordCheck(n, n2);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    this.doVertexAttrCheck(n, n2);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.doNormalCheck(n);
            }
        }
    }

    void doCoordCheck(int n) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        if ((this.vertexFormat & 0x80) != 0) break block19;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block21;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xF) {
                            case 1: {
                                if (this.floatBufferRefCoords == null || 3 * n < this.floatBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                            case 2: {
                                if (this.doubleBufferRefCoords == null || 3 * n < this.doubleBufferRefCoords.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                    }
                    break block20;
                }
                if ((this.vertexFormat & 0x100) != 0) break block22;
                switch (this.vertexType & 0xF) {
                    case 1: {
                        if (this.floatRefCoords != null && 3 * n >= this.floatRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 2: {
                        if (this.doubleRefCoords != null && 3 * n >= this.doubleRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 4: {
                        if (this.p3fRefCoords != null && n >= this.p3fRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                    case 8: {
                        if (this.p3dRefCoords != null && n >= this.p3dRefCoords.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray23"));
            }
        }
    }

    void doColorCheck(int n) {
        block25: {
            block27: {
                int n2;
                block26: {
                    block24: {
                        if ((this.vertexFormat & 4) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block24;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    n2 = this.getColorStride();
                    if ((this.vertexFormat & 0x800) == 0) break block26;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x3F0) {
                            case 16: {
                                if (this.floatBufferRefColors == null || n2 * n < this.floatBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                            case 32: {
                                if (this.byteBufferRefColors == null || n2 * n < this.byteBufferRefColors.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                    }
                    break block25;
                }
                if ((this.vertexFormat & 0x100) != 0) break block27;
                switch (this.vertexType & 0x3F0) {
                    case 16: {
                        if (this.floatRefColors != null && n2 * n >= this.floatRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 32: {
                        if (this.byteRefColors != null && n2 * n >= this.byteRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 64: {
                        if (this.c3fRefColors != null && n >= this.c3fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 128: {
                        if (this.c4fRefColors != null && n >= this.c4fRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 256: {
                        if (this.c3bRefColors != null && n >= this.c3bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                    case 512: {
                        if (this.c4bRefColors != null && n >= this.c4bRefColors.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
                        }
                        break block25;
                    }
                }
                break block25;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray24"));
            }
        }
    }

    void doNormalCheck(int n) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        if ((this.vertexFormat & 2) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block15;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    if ((this.vertexFormat & 0x800) == 0) break block17;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0xC00) {
                            case 1024: {
                                if (this.floatBufferRefNormals == null || 3 * n < this.floatBufferRefNormals.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                    }
                    break block16;
                }
                if ((this.vertexFormat & 0x100) != 0) break block18;
                switch (this.vertexType & 0xC00) {
                    case 1024: {
                        if (this.floatRefNormals != null && 3 * n >= this.floatRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                    case 2048: {
                        if (this.v3fRefNormals != null && n >= this.v3fRefNormals.length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray26"));
            }
        }
    }

    void doTexCoordCheck(int n, int n2) {
        block18: {
            block20: {
                int n3;
                block19: {
                    block17: {
                        if ((this.vertexFormat & 0x460) == 0) {
                            return;
                        }
                        if ((this.vertexFormat & 0x80) != 0) break block17;
                        if (n >= this.vertexCount) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    n3 = this.getTexStride();
                    if ((this.vertexFormat & 0x800) == 0) break block19;
                    if ((this.vertexFormat & 0x100) == 0) {
                        switch (this.vertexType & 0x7000) {
                            case 4096: {
                                FloatBuffer floatBuffer = (FloatBuffer)this.refTexCoordsBuffer[n2].getROBuffer();
                                if (this.refTexCoords[n2] == null || n3 * n < floatBuffer.limit()) break;
                                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                            }
                        }
                    } else if (this.interleavedFloatBufferImpl != null && this.stride * n >= this.interleavedFloatBufferImpl.limit()) {
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                    }
                    break block18;
                }
                if ((this.vertexFormat & 0x100) != 0) break block20;
                switch (this.vertexType & 0x7000) {
                    case 4096: {
                        if (this.refTexCoords[n2] != null && n3 * n >= ((float[])this.refTexCoords[n2]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 8192: {
                        if (this.refTexCoords[n2] != null && n >= ((TexCoord2f[])this.refTexCoords[n2]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                    case 16384: {
                        if (this.refTexCoords[n2] != null && n >= ((TexCoord3f[])this.refTexCoords[n2]).length) {
                            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
                        }
                        break block18;
                    }
                }
                break block18;
            }
            if (this.interLeavedVertexData != null && this.stride * n >= this.interLeavedVertexData.length) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray25"));
            }
        }
    }

    void doVertexAttrCheck(int n, int n2) {
        if ((this.vertexFormat & 0x1000) == 0) {
            return;
        }
        assert ((this.vertexFormat & 0x100) == 0);
        if ((this.vertexFormat & 0x80) == 0) {
            if (n >= this.vertexCount) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
            }
        } else {
            int n3 = this.vertexAttrSizes[n2];
            if ((this.vertexFormat & 0x800) != 0) {
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        if (n3 * n < this.floatBufferRefVertexAttrs[n2].limit()) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                    }
                }
            } else {
                switch (this.vertexType & 0x8000) {
                    case 32768: {
                        if (n3 * n < this.floatRefVertexAttrs[n2].length) break;
                        throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray30"));
                    }
                }
            }
        }
    }

    final void setCoordinateIndex(int n, int n2) {
        int n3;
        int n4 = this.doIndexCheck(n, this.maxCoordIndex, this.indexCoord, n2);
        if (n4 > this.maxCoordIndex) {
            this.doErrorCheck(n4);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n4;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.maxTexCoordIndices[n3] = n4;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n3 = 0; n3 < this.vertexAttrCount; ++n3) {
                    this.maxVertexAttrIndices[n3] = n4;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n4;
            }
        }
        int n5 = n3 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n3 != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.indexCoord[n] = n2;
        this.maxCoordIndex = n4;
        if (n3 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n3 != 0) {
            this.sendDataChangedMessage(true);
        }
    }

    int doIndexCheck(int n, int n2, int[] nArray, int n3) {
        int n4 = n2;
        if (n < this.initialIndexIndex) {
            return n4;
        }
        if (n >= this.initialIndexIndex + this.validIndexCount) {
            return n4;
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
        }
        if (n4 == nArray[n]) {
            if (n3 >= n4) {
                n4 = n3;
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= n4) continue;
                    n4 = nArray[i];
                }
            }
        } else if (n3 > n4) {
            n4 = n3;
        }
        return n4;
    }

    int doIndicesCheck(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = n2;
        boolean bl = false;
        int n4 = nArray2.length;
        boolean bl2 = false;
        for (int i = 0; i < n4; ++i) {
            if (n + i < this.initialIndexIndex || n + i >= this.initialIndexIndex + this.validIndexCount) continue;
            if (nArray2[i] < 0) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
            }
            if (nArray[n + i] == n2) {
                if (nArray2[i] >= n3) {
                    n3 = nArray2[i];
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (bl2) continue;
                bl = true;
                continue;
            }
            if (nArray2[i] < n3) continue;
            n3 = nArray2[i];
            bl = false;
            bl2 = true;
        }
        if (bl) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] <= n3) continue;
                n3 = nArray[i];
            }
        }
        return n3;
    }

    final void setCoordinateIndices(int n, int[] nArray) {
        boolean bl;
        int n2;
        int n3 = nArray.length;
        int n4 = this.doIndicesCheck(n, this.maxCoordIndex, this.indexCoord, nArray);
        if (n4 > this.maxCoordIndex) {
            this.doErrorCheck(n4);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n4;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = n4;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    this.maxVertexAttrIndices[n2] = n4;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n4;
            }
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = n4;
        n2 = 0;
        int n5 = n;
        while (n2 < n3) {
            this.indexCoord[n5] = nArray[n2];
            ++n2;
            ++n5;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(true);
        }
    }

    final void setCoordIndicesRef(int[] nArray) {
        int n;
        int n2 = 0;
        if (nArray != null) {
            if (nArray.length < this.initialIndexIndex + this.validIndexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
            }
            n2 = this.computeMaxIndexWithCheck(this.initialIndexIndex, this.validIndexCount, nArray);
            if (n2 > this.maxCoordIndex) {
                this.doErrorCheck(n2);
            }
        }
        if ((this.vertexFormat & 0x200) != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n2;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n = 0; n < this.texCoordSetCount; ++n) {
                    this.maxTexCoordIndices[n] = n2;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n = 0; n < this.vertexAttrCount; ++n) {
                    this.maxVertexAttrIndices[n] = n2;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n2;
            }
        }
        int n3 = n = this.source != null && this.source.isLive() ? 1 : 0;
        if (n != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = n2;
        this.indexCoord = nArray;
        if (n != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n != 0) {
            this.sendDataChangedMessage(true);
        }
    }

    final void doPostUpdaterUpdate() {
        int n = 0;
        if (this.indexCoord != null && (n = this.computeMaxIndexWithCheck(this.initialIndexIndex, this.validIndexCount, this.indexCoord)) > this.maxCoordIndex) {
            this.doErrorCheck(n);
        }
        if ((this.vertexFormat & 0x200) != 0) {
            int n2;
            if ((this.vertexFormat & 4) != 0) {
                this.maxColorIndex = n;
            }
            if ((this.vertexFormat & 0x460) != 0) {
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    this.maxTexCoordIndices[n2] = n;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    this.maxVertexAttrIndices[n2] = n;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                this.maxNormalIndex = n;
            }
        }
        this.dirtyFlag |= 0x20;
        this.maxCoordIndex = n;
    }

    final void setColorIndex(int n, int n2) {
        boolean bl;
        int n3 = this.maxColorIndex;
        n3 = this.doIndexCheck(n, this.maxColorIndex, this.indexColor, n2);
        if (n3 > this.maxColorIndex) {
            this.doColorCheck(n3);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.indexColor[n] = n2;
        this.maxColorIndex = n3;
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setColorIndices(int n, int[] nArray) {
        boolean bl;
        int n2 = nArray.length;
        int n3 = this.doIndicesCheck(n, this.maxColorIndex, this.indexColor, nArray);
        if (n3 > this.maxColorIndex) {
            this.doColorCheck(n3);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.maxColorIndex = n3;
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            this.indexColor[n5] = nArray[n4];
            ++n4;
            ++n5;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setNormalIndex(int n, int n2) {
        boolean bl;
        int n3 = this.doIndexCheck(n, this.maxNormalIndex, this.indexNormal, n2);
        if (n3 > this.maxNormalIndex) {
            this.doNormalCheck(n3);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.maxNormalIndex = n3;
        this.indexNormal[n] = n2;
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setNormalIndices(int n, int[] nArray) {
        boolean bl;
        int n2 = nArray.length;
        int n3 = this.doIndicesCheck(n, this.maxNormalIndex, this.indexNormal, nArray);
        if (n3 > this.maxNormalIndex) {
            this.doNormalCheck(n3);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            this.indexNormal[n5] = nArray[n4];
            ++n4;
            ++n5;
        }
        this.maxNormalIndex = n3;
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setTextureCoordinateIndex(int n, int n2, int n3) {
        boolean bl;
        int[] nArray = this.indexTexCoord[n];
        int n4 = this.doIndexCheck(n2, this.maxTexCoordIndices[n], nArray, n3);
        if (n4 > this.maxTexCoordIndices[n]) {
            this.doTexCoordCheck(n4, n);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.maxTexCoordIndices[n] = n4;
        nArray[n2] = n3;
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    final void setTextureCoordinateIndices(int n, int n2, int[] nArray) {
        boolean bl;
        int n3 = nArray.length;
        int[] nArray2 = this.indexTexCoord[n];
        int n4 = this.doIndicesCheck(n2, this.maxTexCoordIndices[n], nArray2, nArray);
        if (n4 > this.maxTexCoordIndices[n]) {
            this.doTexCoordCheck(n4, n);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.maxTexCoordIndices[n] = n4;
        int n5 = 0;
        int n6 = n2;
        while (n5 < n3) {
            nArray2[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrIndex(int n, int n2, int n3) {
        boolean bl;
        int[] nArray = this.indexVertexAttr[n];
        int n4 = this.doIndexCheck(n2, this.maxVertexAttrIndices[n], nArray, n3);
        if (n4 > this.maxVertexAttrIndices[n]) {
            this.doVertexAttrCheck(n4, n);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.maxVertexAttrIndices[n] = n4;
        nArray[n2] = n3;
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    void setVertexAttrIndices(int n, int n2, int[] nArray) {
        boolean bl;
        int n3 = nArray.length;
        int[] nArray2 = this.indexVertexAttr[n];
        int n4 = this.doIndicesCheck(n2, this.maxVertexAttrIndices[n], nArray2, nArray);
        if (n4 > this.maxVertexAttrIndices[n]) {
            this.doVertexAttrCheck(n4, n);
        }
        boolean bl2 = bl = this.source != null && this.source.isLive();
        if (bl) {
            this.geomLock.getLock();
        }
        this.maxVertexAttrIndices[n] = n4;
        int n5 = 0;
        int n6 = n2;
        while (n5 < n3) {
            nArray2[n6] = nArray[n5];
            ++n5;
            ++n6;
        }
        if (bl) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && bl) {
            this.sendDataChangedMessage(false);
        }
    }

    final int getCoordinateIndex(int n) {
        return this.indexCoord[n];
    }

    final void getCoordinateIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexCoord[n4];
            ++n3;
            ++n4;
        }
    }

    final int[] getCoordIndicesRef() {
        return this.indexCoord;
    }

    final int getColorIndex(int n) {
        return this.indexColor[n];
    }

    final void getColorIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexColor[n4];
            ++n3;
            ++n4;
        }
    }

    final int getNormalIndex(int n) {
        return this.indexNormal[n];
    }

    final void getNormalIndices(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            nArray[n3] = this.indexNormal[n4];
            ++n3;
            ++n4;
        }
    }

    final int getTextureCoordinateIndex(int n, int n2) {
        int[] nArray = this.indexTexCoord[n];
        return nArray[n2];
    }

    final void getTextureCoordinateIndices(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        int[] nArray2 = this.indexTexCoord[n];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = nArray2[n5];
            ++n4;
            ++n5;
        }
    }

    int getVertexAttrIndex(int n, int n2) {
        int[] nArray = this.indexVertexAttr[n];
        return nArray[n2];
    }

    void getVertexAttrIndices(int n, int n2, int[] nArray) {
        int n3 = nArray.length;
        int[] nArray2 = this.indexVertexAttr[n];
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3) {
            nArray[n4] = nArray2[n5];
            ++n4;
            ++n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, int n, boolean bl3) {
        boolean bl4 = false;
        if (this.mirrorGeometry != null) {
            this.mirrorGeometry.execute(canvas3D, renderAtom, bl, bl2, f, n, bl3);
            return;
        }
        if (this.indexCoord == null) {
            return;
        }
        if ((this.vertexFormat & 0x800) == 0) {
            if ((this.vertexFormat & 0x80) == 0) {
                float[] fArray;
                int n2;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    n2 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        Object[] objectArray = this.updateAlphaInVertexData(canvas3D, n, f);
                        bl4 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n2 |= 4;
                        }
                    } else {
                        fArray = this.vertexData;
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n2 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().executeIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, (this.vertexFormat & 4) != 0 ? this.vertexFormat | 0xC : this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, fArray, null, n2, this.indexCoord);
            } else if ((this.vertexFormat & 0x100) != 0) {
                int n3;
                if (this.interLeavedVertexData == null) {
                    return;
                }
                float[] fArray = null;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
                synchronized (indexedGeometryArrayRetained) {
                    n3 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                        bl4 = objectArray[0] == Boolean.TRUE;
                        fArray = (float[])objectArray[1];
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n3 |= 4;
                        }
                    } else if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n3 |= 4;
                    }
                    this.dirtyFlag = 0;
                }
                Pipeline.getPipeline().executeIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.interLeavedVertexData, fArray, n3, this.indexCoord);
            } else {
                int n4;
                IndexedGeometryArrayRetained indexedGeometryArrayRetained;
                if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                    return;
                }
                byte[] byArray = null;
                float[] fArray = null;
                if ((this.vertexType & 0xD0) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        n4 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n4 |= 4;
                            }
                        } else {
                            fArray = this.mirrorFloatRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n4 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else if ((this.vertexType & 0x320) != 0) {
                    indexedGeometryArrayRetained = this;
                    synchronized (indexedGeometryArrayRetained) {
                        n4 = this.dirtyFlag;
                        if (bl2 && !bl3) {
                            byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                            if (f != this.lastScreenAlpha) {
                                this.lastScreenAlpha = f;
                                n4 |= 4;
                            }
                        } else {
                            byArray = this.mirrorUnsignedByteRefColors[0];
                            if (this.lastScreenAlpha != -1.0f) {
                                this.lastScreenAlpha = -1.0f;
                                n4 |= 4;
                            }
                        }
                        this.dirtyFlag = 0;
                    }
                } else {
                    n4 = this.dirtyFlag;
                }
                int n5 = 0;
                if ((this.vertexType & 5) != 0) {
                    n5 |= 1;
                }
                if ((this.vertexType & 0xA) != 0) {
                    n5 |= 2;
                }
                if ((this.vertexType & 0xD0) != 0) {
                    n5 |= 4;
                }
                if ((this.vertexType & 0x320) != 0) {
                    n5 |= 8;
                }
                if ((this.vertexType & 0xC00) != 0) {
                    n5 |= 0x10;
                }
                if ((this.vertexType & 0x8000) != 0) {
                    n5 |= 0x40;
                }
                if ((this.vertexType & 0x7000) != 0) {
                    n5 |= 0x20;
                }
                Pipeline.getPipeline().executeIndexedGeometryVA(canvas3D.ctx, this, this.geoType, bl, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, n5, this.mirrorFloatRefCoords, this.mirrorDoubleRefCoords, fArray, byArray, this.mirrorFloatRefNormals, this.vertexAttrCount, this.vertexAttrSizes, this.mirrorFloatRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.texCoordStride, this.mirrorRefTexCoords, n4, this.indexCoord);
            }
        } else if ((this.vertexFormat & 0x100) != 0) {
            int n6;
            if (this.interleavedFloatBufferImpl == null) {
                return;
            }
            float[] fArray = null;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
            synchronized (indexedGeometryArrayRetained) {
                n6 = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInInterLeavedData(canvas3D, n, f);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n6 |= 4;
                    }
                } else if (this.lastScreenAlpha != -1.0f) {
                    this.lastScreenAlpha = -1.0f;
                    n6 |= 4;
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().executeIndexedGeometryBuffer(canvas3D.ctx, this, this.geoType, bl, bl4, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, canvas3D.numActiveTexUnit, this.interleavedFloatBufferImpl, fArray, n6, this.indexCoord);
        } else {
            int n7;
            Object object;
            if (this.vertexType == 0 || (this.vertexType & 0xF) == 0 || (this.vertexFormat & 4) != 0 && (this.vertexType & 0x3F0) == 0 || (this.vertexFormat & 2) != 0 && (this.vertexType & 0xC00) == 0 || (this.vertexFormat & 0x1000) != 0 && (this.vertexType & 0x8000) == 0 || (this.vertexFormat & 0x460) != 0 && (this.vertexType & 0x7000) == 0) {
                return;
            }
            byte[] byArray = null;
            float[] fArray = null;
            if ((this.vertexType & 0x10) != 0) {
                object = this;
                synchronized (object) {
                    n7 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        fArray = this.updateAlphaInFloatRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n7 |= 4;
                        }
                    } else {
                        fArray = this.mirrorFloatRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n7 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else if ((this.vertexType & 0x20) != 0) {
                object = this;
                synchronized (object) {
                    n7 = this.dirtyFlag;
                    if (bl2 && !bl3) {
                        byArray = this.updateAlphaInByteRefColors(canvas3D, n, f);
                        if (f != this.lastScreenAlpha) {
                            this.lastScreenAlpha = f;
                            n7 |= 4;
                        }
                    } else {
                        byArray = this.mirrorUnsignedByteRefColors[0];
                        if (this.lastScreenAlpha != -1.0f) {
                            this.lastScreenAlpha = -1.0f;
                            n7 |= 4;
                        }
                    }
                    this.dirtyFlag = 0;
                }
            } else {
                n7 = this.dirtyFlag;
            }
            object = null;
            Buffer buffer = null;
            FloatBuffer floatBuffer = null;
            int n8 = 0;
            if ((this.vertexType & 1) != 0) {
                n8 |= 1;
                object = this.floatBufferRefCoords;
            } else if ((this.vertexType & 2) != 0) {
                n8 |= 2;
                object = this.doubleBufferRefCoords;
            }
            if ((this.vertexType & 0x10) != 0) {
                n8 |= 4;
                buffer = this.floatBufferRefColors;
            } else if ((this.vertexType & 0x20) != 0) {
                n8 |= 8;
                buffer = this.byteBufferRefColors;
            }
            if ((this.vertexType & 0xC00) != 0) {
                n8 |= 0x10;
                floatBuffer = this.floatBufferRefNormals;
            }
            if ((this.vertexType & 0x8000) != 0) {
                n8 |= 0x40;
            }
            if ((this.vertexType & 0x7000) != 0) {
                n8 |= 0x20;
            }
            Pipeline.getPipeline().executeIndexedGeometryVABuffer(canvas3D.ctx, this, this.geoType, bl, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat | this.c4fAllocated, n8, (Buffer)object, buffer, fArray, byArray, floatBuffer, this.vertexAttrCount, this.vertexAttrSizes, this.floatBufferRefVertexAttrs, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMap, canvas3D.numActiveTexUnit, this.texCoordStride, this.refTexCoords, n7, this.indexCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void buildGA(Canvas3D canvas3D, RenderAtom renderAtom, boolean bl, boolean bl2, float f, boolean bl3, Transform3D transform3D, Transform3D transform3D2) {
        boolean bl4 = false;
        if (this.mirrorGeometry != null) {
            ((GeometryArrayRetained)this.mirrorGeometry).buildGA(canvas3D, renderAtom, bl, bl2, f, bl3, transform3D, transform3D2);
        } else if ((this.vertexFormat & 0x80) == 0) {
            float[] fArray;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = this;
            synchronized (indexedGeometryArrayRetained) {
                int n = this.dirtyFlag;
                if (bl2 && !bl3) {
                    Object[] objectArray = this.updateAlphaInVertexData(canvas3D, canvas3D.screen.screen, f);
                    bl4 = objectArray[0] == Boolean.TRUE;
                    fArray = (float[])objectArray[1];
                    if (f != this.lastScreenAlpha) {
                        this.lastScreenAlpha = f;
                        n |= 4;
                    }
                } else {
                    fArray = this.vertexData;
                    if (this.lastScreenAlpha != -1.0f) {
                        this.lastScreenAlpha = -1.0f;
                        n |= 4;
                    }
                }
                this.dirtyFlag = 0;
            }
            Pipeline.getPipeline().buildIndexedGeometry(canvas3D.ctx, this, this.geoType, bl, bl2, f, bl3, this.initialIndexIndex, this.validIndexCount, this.maxCoordIndex + 1, this.vertexFormat, this.vertexAttrCount, this.vertexAttrSizes, this.texCoordSetCount, this.texCoordSetMap, this.texCoordSetMap == null ? 0 : this.texCoordSetMap.length, this.texCoordSetMapOffset, transform3D == null ? null : transform3D.mat, transform3D2 == null ? null : transform3D2.mat, fArray, this.indexCoord);
        }
    }

    @Override
    void mergeGeometryArrays(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        int[] nArray = null;
        this.indexCount = 0;
        for (n = 0; n < n2; ++n) {
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(n);
            this.indexCount += indexedGeometryArrayRetained.validIndexCount;
        }
        this.validIndexCount = this.indexCount;
        this.initialIndexIndex = 0;
        this.compileIndexCount = new int[n2];
        this.compileIndexOffset = new int[n2];
        this.indexCoord = new int[this.indexCount];
        int n3 = n = (this.vertexFormat & 0x200) == 0 ? 1 : 0;
        if (n != 0) {
            if ((this.vertexFormat & 4) != 0) {
                this.indexColor = new int[this.indexCount];
            }
            if ((this.vertexFormat & 2) != 0) {
                this.indexNormal = new int[this.indexCount];
            }
            if ((this.vertexFormat & 0x460) != 0) {
                this.indexTexCoord = new int[1][];
                this.indexTexCoord[0] = new int[this.indexCount];
                nArray = this.indexTexCoord[0];
            }
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6;
            IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)arrayList.get(i);
            this.compileIndexCount[i] = n6 = indexedGeometryArrayRetained.validIndexCount;
            for (int j = 0; j < n6; ++j) {
                this.indexCoord[j + n5] = indexedGeometryArrayRetained.indexCoord[j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
                if (n == 0) continue;
                if ((this.vertexFormat & 4) != 0) {
                    this.indexColor[j + n5] = indexedGeometryArrayRetained.indexColor[j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
                }
                if ((this.vertexFormat & 2) != 0) {
                    this.indexNormal[j + n5] = indexedGeometryArrayRetained.indexNormal[j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
                }
                if ((this.vertexFormat & 0x460) == 0) continue;
                nArray[j + n5] = indexedGeometryArrayRetained.indexTexCoord[0][j + indexedGeometryArrayRetained.initialIndexIndex] + n4;
            }
            this.maxCoordIndex = indexedGeometryArrayRetained.maxCoordIndex + n4;
            this.compileIndexOffset[i] = n5;
            n4 += indexedGeometryArrayRetained.vertexCount;
            n5 += n6;
        }
        super.mergeGeometryArrays(arrayList);
    }

    @Override
    boolean isWriteStatic() {
        return super.isWriteStatic() && !this.source.getCapability(10) && !this.source.getCapability(12) && !this.source.getCapability(14) && !this.source.getCapability(25) && !this.source.getCapability(16);
    }

    int getIndexCount(int n) {
        return this.compileIndexCount[n];
    }

    int computeMaxIndex(int n, int n2, int[] nArray) {
        int n3 = 0;
        if (nArray != null) {
            for (int i = n; i < n + n2; ++i) {
                if (nArray[i] <= n3) continue;
                n3 = nArray[i];
            }
        }
        return n3;
    }

    int computeMaxIndexWithCheck(int n, int n2, int[] nArray) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            if (nArray[i] < 0) {
                throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("IndexedGeometryArray27"));
            }
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        return n3;
    }

    void setValidIndexCount(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray21"));
        }
        if (this.initialIndexIndex + n > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        if ((this.vertexFormat & 0x2000) != 0 && this.indexCoord != null && this.indexCoord.length < this.initialIndexIndex + n) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        n3 = this.computeMaxIndex(this.initialIndexIndex, n, this.indexCoord);
        this.doErrorCheck(n3);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n4 = this.computeMaxIndex(this.initialIndexIndex, n, this.indexColor);
                this.doColorCheck(n4);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray = new int[this.texCoordSetCount];
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    nArray[n2] = this.computeMaxIndex(this.initialIndexIndex, n, this.indexTexCoord[n2]);
                    this.doTexCoordCheck(nArray[n2], n2);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                nArray2 = new int[this.vertexAttrCount];
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    nArray2[n2] = this.computeMaxIndex(this.initialIndexIndex, n, this.indexVertexAttr[n2]);
                    this.doVertexAttrCheck(nArray2[n2], n2);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n5 = this.computeMaxIndex(this.initialIndexIndex, n, this.indexNormal);
                this.doNormalCheck(n5);
            }
        }
        int n6 = n2 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n2 != 0) {
            this.geomLock.getLock();
        }
        this.validIndexCount = n;
        this.maxCoordIndex = n3;
        if ((this.vertexFormat & 0x200) == 0) {
            int n7;
            this.maxColorIndex = n4;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n7 = 0; n7 < this.texCoordSetCount; ++n7) {
                    this.maxTexCoordIndices[n7] = nArray[n7];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n7 = 0; n7 < this.vertexAttrCount; ++n7) {
                    this.maxVertexAttrIndices[n7] = nArray2[n7];
                }
            }
            this.maxNormalIndex = n5;
        } else {
            int n8;
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n8 = 0; n8 < this.texCoordSetCount; ++n8) {
                    this.maxTexCoordIndices[n8] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n8 = 0; n8 < this.vertexAttrCount; ++n8) {
                    this.maxVertexAttrIndices[n8] = this.maxCoordIndex;
                }
            }
        }
        if (n2 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n2 != 0) {
            this.sendDataChangedMessage(true);
        }
    }

    void setInitialIndexIndex(int n) {
        int n2;
        if (n + this.validIndexCount > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray22"));
        }
        if ((this.vertexFormat & 0x2000) != 0 && this.indexCoord != null && this.indexCoord.length < n + this.validIndexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray33"));
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        n3 = this.computeMaxIndex(n, this.validIndexCount, this.indexCoord);
        this.doErrorCheck(n3);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n4 = this.computeMaxIndex(n, this.validIndexCount, this.indexColor);
                this.doColorCheck(n4);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray = new int[this.texCoordSetCount];
                for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                    nArray[n2] = this.computeMaxIndex(n, this.validIndexCount, this.indexTexCoord[n2]);
                    this.doTexCoordCheck(nArray[n2], n2);
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                nArray2 = new int[this.vertexAttrCount];
                for (n2 = 0; n2 < this.vertexAttrCount; ++n2) {
                    nArray2[n2] = this.computeMaxIndex(n, this.validIndexCount, this.indexVertexAttr[n2]);
                    this.doVertexAttrCheck(nArray2[n2], n2);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n5 = this.computeMaxIndex(n, this.validIndexCount, this.indexNormal);
                this.doNormalCheck(n5);
            }
        }
        int n6 = n2 = this.source != null && this.source.isLive() ? 1 : 0;
        if (n2 != 0) {
            this.geomLock.getLock();
        }
        this.dirtyFlag |= 0x20;
        this.initialIndexIndex = n;
        this.maxCoordIndex = n3;
        if ((this.vertexFormat & 0x200) == 0) {
            int n7;
            this.maxColorIndex = n4;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n7 = 0; n7 < this.texCoordSetCount; ++n7) {
                    this.maxTexCoordIndices[n7] = nArray[n7];
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n7 = 0; n7 < this.vertexAttrCount; ++n7) {
                    this.maxVertexAttrIndices[n7] = nArray2[n7];
                }
            }
            this.maxNormalIndex = n5;
        } else {
            int n8;
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                for (n8 = 0; n8 < this.texCoordSetCount; ++n8) {
                    this.maxTexCoordIndices[n8] = this.maxCoordIndex;
                }
            }
            if ((this.vertexFormat & 0x1000) != 0) {
                for (n8 = 0; n8 < this.vertexAttrCount; ++n8) {
                    this.maxVertexAttrIndices[n8] = this.maxCoordIndex;
                }
            }
        }
        if (n2 != 0) {
            this.geomLock.unLock();
        }
        if (!this.inUpdater && n2 != 0) {
            this.sendDataChangedMessage(true);
        }
    }

    int getInitialIndexIndex() {
        return this.initialIndexIndex;
    }

    int getValidIndexCount() {
        return this.validIndexCount;
    }

    @Override
    void handleFrequencyChange(int n) {
        if (n == 10 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 4) != 0 && n == 12 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 2) != 0 && n == 14 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 0x1000) != 0 && n == 25 || (this.vertexFormat & 0x200) == 0 && (this.vertexFormat & 0x460) != 0 && n == 16) {
            this.setFrequencyChangeMask(n, 1);
        } else {
            super.handleFrequencyChange(n);
        }
    }
}

