/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vcs.ex.LineStatusActionBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveChangesLineStatusAction
extends LineStatusActionBase {
    @Override
    protected boolean isEnabled(@NotNull LineStatusTrackerBase<?> tracker, @NotNull Editor editor) {
        if (tracker == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(1);
        }
        return tracker instanceof PartialLocalLineStatusTracker;
    }

    @Override
    protected void doAction(@NotNull LineStatusTrackerBase<?> tracker, @NotNull Editor editor) {
        if (tracker == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(3);
        }
        MoveChangesLineStatusAction.moveToAnotherChangelist((PartialLocalLineStatusTracker)tracker, editor);
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull Editor editor) {
        if (tracker == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(5);
        }
        MoveChangesLineStatusAction.moveToAnotherChangelist(tracker, DiffUtil.getSelectedLines(editor));
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull BitSet selectedLines) {
        if (tracker == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(6);
        }
        if (selectedLines == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(7);
        }
        Project project = tracker.getProject();
        List<PartialLocalLineStatusTracker.LocalRange> ranges = tracker.getRangesForLines(selectedLines);
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        LocalChangeList targetList = MoveChangesLineStatusAction.askTargetChangelist(project, ranges, tracker);
        if (targetList == null) {
            return;
        }
        tracker.moveToChangelist(selectedLines, targetList);
    }

    public static void moveToAnotherChangelist(@NotNull PartialLocalLineStatusTracker tracker, @NotNull PartialLocalLineStatusTracker.LocalRange range2) {
        Project project;
        LocalChangeList targetList;
        if (tracker == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(8);
        }
        if (range2 == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(9);
        }
        if ((targetList = MoveChangesLineStatusAction.askTargetChangelist(project = tracker.getProject(), Collections.singletonList(range2), tracker)) == null) {
            return;
        }
        tracker.moveToChangelist(range2, targetList);
    }

    @Nullable
    private static LocalChangeList askTargetChangelist(@NotNull Project project, @NotNull List<PartialLocalLineStatusTracker.LocalRange> selectedRanges, @NotNull PartialLocalLineStatusTracker tracker) {
        if (project == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(10);
        }
        if (selectedRanges == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(11);
        }
        if (tracker == null) {
            MoveChangesLineStatusAction.$$$reportNull$$$0(12);
        }
        Set selectedListIds = ContainerUtil.map2Set(selectedRanges, range2 -> range2.getChangelistId());
        HashSet<String> remainingTrackerListIds = new HashSet<String>(tracker.getAffectedChangeListsIds());
        remainingTrackerListIds.removeAll(selectedListIds);
        ChangeListManager clm = ChangeListManager.getInstance((Project)project);
        List allChangelists = clm.getChangeListsCopy();
        List nonAffectedLists = ContainerUtil.filter((Collection)allChangelists, list2 -> !selectedListIds.contains(list2.getId()));
        List remainingTrackerLists = ContainerUtil.filter((Collection)allChangelists, list2 -> remainingTrackerListIds.contains(list2.getId()));
        List suggestedLists = nonAffectedLists.isEmpty() ? Collections.singletonList(clm.getDefaultChangeList()) : nonAffectedLists;
        List preferedLists = remainingTrackerLists.isEmpty() ? nonAffectedLists : remainingTrackerLists;
        ChangeList defaultSelection2 = MoveChangesToAnotherListAction.guessPreferredList(preferedLists);
        ChangeListChooser chooser = new ChangeListChooser(project, suggestedLists, defaultSelection2, ActionsBundle.message((String)"action.Vcs.MoveChangedLinesToChangelist.text", (Object[])new Object[0]), null);
        chooser.show();
        return chooser.getSelectedList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedLines";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRanges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/ex/MoveChangesLineStatusAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "moveToAnotherChangelist";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "askTargetChangelist";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

