/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Producer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider");
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(1);
        }
        PsiAwareTextEditorImpl psiAwareTextEditorImpl = new PsiAwareTextEditorImpl(project, file2, this);
        if (psiAwareTextEditorImpl == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(2);
        }
        return psiAwareTextEditorImpl;
    }

    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file2) {
        if (element == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(5);
        }
        TextEditorState state = (TextEditorState)super.readState(element, project, file2);
        Element child2 = element.getChild(FOLDING_ELEMENT);
        if (child2 != null) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document == null) {
                state.setDelayedFoldState(new MyDelayedFoldingState(project, file2, child2));
            } else {
                state.setFoldingState(CodeFoldingManager.getInstance(project).readFoldingState(child2, document));
            }
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(6);
        }
        return textEditorState;
    }

    @Override
    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        if (_state == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(9);
        }
        super.writeState(_state, project, element);
        TextEditorState state = (TextEditorState)_state;
        CodeFoldingState foldingState = state.getFoldingState();
        if (foldingState != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project).writeFoldingState(foldingState, e);
            }
            catch (WriteExternalException writeExternalException) {
                // empty catch block
            }
            if (!JDOMUtil.isEmpty((Element)e)) {
                element.addContent(e);
            }
        } else {
            Producer<CodeFoldingState> delayedProducer = state.getDelayedFoldState();
            if (delayedProducer instanceof MyDelayedFoldingState) {
                element.addContent(((MyDelayedFoldingState)delayedProducer).getSerializedState());
            }
        }
    }

    @Override
    @NotNull
    protected TextEditorState getStateImpl(Project project, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        if (editor == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(10);
        }
        if (level == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(11);
        }
        TextEditorState state = super.getStateImpl(project, editor, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project != null && !project.isDisposed() && !editor.isDisposed() && project.isInitialized()) {
                state.setFoldingState(CodeFoldingManager.getInstance(project).saveFoldingState(editor));
            } else {
                state.setFoldingState(null);
            }
        }
        TextEditorState textEditorState = state;
        if (textEditorState == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(12);
        }
        return textEditorState;
    }

    @Override
    protected void setStateImpl(Project project, Editor editor, TextEditorState state, boolean exactState) {
        super.setStateImpl(project, editor, state, exactState);
        CodeFoldingState foldState = state.getFoldingState();
        if (project != null && foldState != null && AsyncEditorLoader.isEditorLoaded(editor)) {
            if (!PsiDocumentManager.getInstance((Project)project).isCommitted(editor.getDocument())) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                LOG.error("File should be parsed when changing editor state, otherwise UI might be frozen for a considerable time");
            }
            editor.getFoldingModel().runBatchFoldingOperation(() -> CodeFoldingManager.getInstance(project).restoreFoldingState(editor, foldState));
        }
    }

    @Override
    @NotNull
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        if (editor == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(13);
        }
        PsiAwareEditorWrapper psiAwareEditorWrapper = new PsiAwareEditorWrapper(editor);
        if (psiAwareEditorWrapper == null) {
            PsiAwareTextEditorProvider.$$$reportNull$$$0(14);
        }
        return psiAwareEditorWrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_state";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrapperForEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStateImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createWrapperForEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDelayedFoldingState
    implements Producer<CodeFoldingState> {
        private final Project myProject;
        private final VirtualFile myFile;
        private final Element mySerializedState;

        private MyDelayedFoldingState(Project project, VirtualFile file2, Element state) {
            this.myProject = project;
            this.myFile = file2;
            this.mySerializedState = JDOMUtil.internElement((Element)state);
        }

        public CodeFoldingState produce() {
            Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
            return document == null ? null : CodeFoldingManager.getInstance(this.myProject).readFoldingState(this.mySerializedState, document);
        }

        private Element getSerializedState() {
            return this.mySerializedState.clone();
        }
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor) {
            if (editor == null) {
                PsiAwareEditorWrapper.$$$reportNull$$$0(0);
            }
            super(PsiAwareTextEditorProvider.this, editor);
            Project project = editor.getProject();
            this.myBackgroundHighlighter = project == null ? null : new TextEditorBackgroundHighlighter(project, editor);
        }

        @Override
        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }

        @Override
        public boolean isValid() {
            return !this.getEditor().isDisposed();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorProvider$PsiAwareEditorWrapper", "<init>"));
        }
    }
}

