/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.inference;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.protege.editor.core.prefs.Preferences;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class PrecomputedInferencePreferences {
    private Set<InferenceType> required = EnumSet.noneOf(InferenceType.class);
    private Set<InferenceType> disallowed = EnumSet.noneOf(InferenceType.class);
    private Map<InferenceType, Set<String>> requested = new EnumMap<InferenceType, Set<String>>(InferenceType.class);

    public Set<InferenceType> getPrecomputedInferences() {
        EnumSet<InferenceType> precompute = EnumSet.noneOf(InferenceType.class);
        for (InferenceType type : InferenceType.values()) {
            Set<String> requestors = this.requested.get(type);
            if (!this.required.contains(type) && (requestors == null || requestors.isEmpty())) continue;
            precompute.add(type);
        }
        precompute.removeAll(this.disallowed);
        return precompute;
    }

    public void requestPrecomputedInferences(String requestor, Set<InferenceType> types) {
        for (InferenceType type : InferenceType.values()) {
            Set<String> requestors = this.requested.get(type);
            if (types.contains(type)) {
                if (requestors == null) {
                    requestors = new TreeSet<String>();
                    this.requested.put(type, requestors);
                }
                requestors.add(requestor);
                continue;
            }
            if (requestors == null) continue;
            requestors.remove(requestor);
        }
    }

    public Set<String> getRequestors(InferenceType type) {
        return this.requested.get(type);
    }

    public Set<InferenceType> getRequired() {
        return Collections.unmodifiableSet(this.required);
    }

    public void setRequired(EnumSet<InferenceType> required) {
        this.required = EnumSet.copyOf(required);
    }

    public void setRequired(InferenceType type, boolean isRequired) {
        if (isRequired) {
            this.required.add(type);
        } else {
            this.required.remove(type);
        }
    }

    public Set<InferenceType> getDisallowed() {
        return this.disallowed;
    }

    public void setDisallowed(InferenceType type, boolean isDisallowed) {
        if (isDisallowed) {
            this.disallowed.add(type);
        } else {
            this.disallowed.remove(type);
        }
    }

    public void load(Preferences prefs) {
        this.required.clear();
        this.disallowed.clear();
        for (InferenceType type : InferenceType.values()) {
            if (prefs.getBoolean(this.getRequiredInferenceName(type), false)) {
                this.required.add(type);
            }
            if (!prefs.getBoolean(this.getDisallowedInferenceName(type), false)) continue;
            this.disallowed.add(type);
        }
    }

    public void save(Preferences prefs) {
        for (InferenceType type : InferenceType.values()) {
            prefs.putBoolean(this.getRequiredInferenceName(type), this.required.contains(type));
            prefs.putBoolean(this.getDisallowedInferenceName(type), this.disallowed.contains(type));
        }
    }

    private String getRequiredInferenceName(InferenceType type) {
        return "Require_" + type.toString();
    }

    private String getDisallowedInferenceName(InferenceType type) {
        return "Disallow_" + type.toString();
    }
}

