/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.PdfSource;
import org.sejda.model.output.MultipleTaskOutput;
import org.sejda.model.parameter.base.AbstractParameters;
import org.sejda.model.parameter.base.MultiplePdfSourceTaskParameters;
import org.sejda.model.validation.constraint.NotEmpty;

public class UnpackParameters
extends AbstractParameters
implements MultiplePdfSourceTaskParameters {
    @Valid
    @NotNull
    private final MultipleTaskOutput output;
    @NotEmpty
    @Valid
    private final List<PdfSource<?>> sourceList = new ArrayList();

    public UnpackParameters(MultipleTaskOutput output) {
        this.output = output;
    }

    @Override
    public MultipleTaskOutput getOutput() {
        return this.output;
    }

    @Override
    public void addSource(PdfSource<?> input) {
        this.sourceList.add(input);
    }

    @Override
    public List<PdfSource<?>> getSourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.output).append(this.sourceList).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnpackParameters)) {
            return false;
        }
        UnpackParameters parameter = (UnpackParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.output, (Object)parameter.getOutput()).append(this.sourceList, parameter.getSourceList()).isEquals();
    }
}

