/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.osmand.binary.BinaryMapIndexReader;

public class BinaryMapDataObject {
    protected int[] coordinates = null;
    protected int[][] polygonInnerCoordinates = null;
    protected boolean area = false;
    protected int[] types = null;
    protected int[] additionalTypes = null;
    protected int objectType = 1;
    protected TIntObjectHashMap<String> objectNames = null;
    protected TIntArrayList namesOrder = null;
    protected long id = 0L;
    protected BinaryMapIndexReader.MapIndex mapIndex = null;

    public BinaryMapDataObject() {
    }

    public BinaryMapDataObject(int[] coordinates, int[] types, int[][] polygonInnerCoordinates, long id2) {
        this.polygonInnerCoordinates = polygonInnerCoordinates;
        this.coordinates = coordinates;
        this.additionalTypes = new int[0];
        this.types = types;
        this.id = id2;
    }

    protected void setCoordinates(int[] coordinates) {
        this.coordinates = coordinates;
    }

    public String getName() {
        if (this.objectNames == null) {
            return "";
        }
        String name = (String)this.objectNames.get(this.mapIndex.nameEncodingType);
        if (name == null) {
            return "";
        }
        return name;
    }

    public TIntObjectHashMap<String> getObjectNames() {
        return this.objectNames;
    }

    public Map<Integer, String> getOrderedObjectNames() {
        LinkedHashMap<Integer, String> lm = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < this.namesOrder.size(); ++i) {
            int nm = this.namesOrder.get(i);
            lm.put(nm, (String)this.objectNames.get(nm));
        }
        return lm;
    }

    public void putObjectName(int type, String name) {
        if (this.objectNames == null) {
            this.objectNames = new TIntObjectHashMap();
            this.namesOrder = new TIntArrayList();
        }
        this.objectNames.put(type, (Object)name);
        this.namesOrder.add(type);
    }

    public int[][] getPolygonInnerCoordinates() {
        return this.polygonInnerCoordinates;
    }

    public int[] getTypes() {
        return this.types;
    }

    public boolean containsType(int cachedType) {
        if (cachedType != -1) {
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i] != cachedType) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAdditionalType(int cachedType) {
        if (cachedType != -1) {
            for (int i = 0; i < this.additionalTypes.length; ++i) {
                if (this.additionalTypes[i] != cachedType) continue;
                return true;
            }
        }
        return false;
    }

    public String getNameByType(int type) {
        if (type != -1 && this.objectNames != null) {
            return (String)this.objectNames.get(type);
        }
        return null;
    }

    public int[] getAdditionalTypes() {
        return this.additionalTypes;
    }

    public boolean isArea() {
        return this.area;
    }

    public boolean isCycle() {
        if (this.coordinates == null || this.coordinates.length < 2) {
            return false;
        }
        return this.coordinates[0] == this.coordinates[this.coordinates.length - 2] && this.coordinates[1] == this.coordinates[this.coordinates.length - 1];
    }

    public void setArea(boolean area) {
        this.area = area;
    }

    public long getId() {
        return this.id;
    }

    protected void setId(long id2) {
        this.id = id2;
    }

    protected void setTypes(int[] types) {
        this.types = types;
    }

    public int getSimpleLayer() {
        if (this.mapIndex != null) {
            for (int i = 0; i < this.additionalTypes.length; ++i) {
                if (this.mapIndex.positiveLayers.contains(this.additionalTypes[i])) {
                    return 1;
                }
                if (!this.mapIndex.negativeLayers.contains(this.additionalTypes[i])) continue;
                return -1;
            }
        }
        return 0;
    }

    public TIntArrayList getNamesOrder() {
        return this.namesOrder;
    }

    public BinaryMapIndexReader.MapIndex getMapIndex() {
        return this.mapIndex;
    }

    public void setMapIndex(BinaryMapIndexReader.MapIndex mapIndex) {
        this.mapIndex = mapIndex;
    }

    public int getPointsLength() {
        if (this.coordinates == null) {
            return 0;
        }
        return this.coordinates.length / 2;
    }

    public int getPoint31YTile(int ind) {
        return this.coordinates[2 * ind + 1];
    }

    public int getPoint31XTile(int ind) {
        return this.coordinates[2 * ind];
    }
}

