/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.text.OrdinalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundleBase {
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    private static boolean assertOnMissedKeys = false;

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        if (bundle == null) {
            BundleBase.$$$reportNull$$$0(0);
        }
        if (key == null) {
            BundleBase.$$$reportNull$$$0(1);
        }
        if (params == null) {
            BundleBase.$$$reportNull$$$0(2);
        }
        String string = BundleBase.messageOrDefault(bundle, key, null, params);
        if (string == null) {
            BundleBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue2, Object ... params) {
        String value;
        block7: {
            if (key == null) {
                BundleBase.$$$reportNull$$$0(4);
            }
            if (params == null) {
                BundleBase.$$$reportNull$$$0(5);
            }
            if (bundle == null) {
                return defaultValue2;
            }
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (defaultValue2 != null) {
                    value = defaultValue2;
                }
                value = "!" + key + "!";
                if (!assertOnMissedKeys || $assertionsDisabled) break block7;
                throw new AssertionError((Object)("'" + key + "' is not found in " + bundle));
            }
        }
        value = BundleBase.replaceMnemonicAmpersand(value);
        if (params.length > 0 && value.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            MessageFormat format = locale != null ? new MessageFormat(value, locale) : new MessageFormat(value);
            OrdinalFormat.apply(format);
            value = format.format(params);
        }
        return value;
    }

    public static String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null || value.indexOf(38) < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = value.contains("&&");
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    builder.append('&');
                    ++i;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    if (SystemInfoRt.isMac) {
                        builder.append('\u001b');
                    }
                    ++i;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic) continue;
                builder.append('\u001b');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/BundleBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/BundleBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "messageOrDefault";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

