"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanel = void 0;

var _eui = require("@elastic/eui");

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _context_menu_actions = require("../context_menu_actions");

var _triggers = require("../triggers");

var _types = require("../types");

var _panel_actions = require("./panel_header/panel_actions");

var _add_panel_action = require("./panel_header/panel_actions/add_panel/add_panel_action");

var _customize_panel_action = require("./panel_header/panel_actions/customize_title/customize_panel_action");

var _panel_header = require("./panel_header/panel_header");

var _actions = require("../actions");

var _inspect_panel_action = require("./panel_header/panel_actions/inspect_panel_action");

var _edit_panel_action = require("./panel_header/panel_actions/edit_panel_action");

var _get_actions_for_trigger = require("../get_actions_for_trigger");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var EmbeddablePanel =
/*#__PURE__*/
function (_React$Component) {
  _inherits(EmbeddablePanel, _React$Component);

  function EmbeddablePanel(props) {
    var _this;

    _classCallCheck(this, EmbeddablePanel);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EmbeddablePanel).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "embeddableRoot", void 0);

    _defineProperty(_assertThisInitialized(_this), "parentSubscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "subscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "mounted", false);

    _defineProperty(_assertThisInitialized(_this), "onFocus", function (focusedPanelIndex) {
      _this.setState({
        focusedPanelIndex: focusedPanelIndex
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function (blurredPanelIndex) {
      if (_this.state.focusedPanelIndex === blurredPanelIndex) {
        _this.setState({
          focusedPanelIndex: undefined
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "closeMyContextMenuPanel", function () {
      if (_this.mounted) {
        _this.setState({
          closeContextMenu: true
        }, function () {
          if (_this.mounted) {
            _this.setState({
              closeContextMenu: false
            });
          }
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "getActionContextMenuPanel",
    /*#__PURE__*/
    _asyncToGenerator(
    /*#__PURE__*/
    regeneratorRuntime.mark(function _callee() {
      var actions, extraActions, sorted;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return (0, _get_actions_for_trigger.getActionsForTrigger)(_actions.actionRegistry, _triggers.triggerRegistry, _triggers.CONTEXT_MENU_TRIGGER, {
                embeddable: _this.props.embeddable
              });

            case 2:
              actions = _context.sent;
              // These actions are exposed on the context menu for every embeddable, they bypass the trigger
              // registry.
              extraActions = [new _customize_panel_action.CustomizePanelTitleAction(), new _add_panel_action.AddPanelAction(), new _inspect_panel_action.InspectPanelAction(), new _panel_actions.RemovePanelAction(), new _edit_panel_action.EditPanelAction()];
              sorted = actions.concat(extraActions).sort(function (a, b) {
                return b.order - a.order;
              });
              _context.next = 7;
              return (0, _context_menu_actions.buildContextMenuForActions)({
                actions: sorted,
                actionContext: {
                  embeddable: _this.props.embeddable
                },
                closeMenu: _this.closeMyContextMenuPanel
              });

            case 7:
              return _context.abrupt("return", _context.sent);

            case 8:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    var embeddable = _this.props.embeddable;
    var viewMode = embeddable.getInput().viewMode ? embeddable.getInput().viewMode : _types.ViewMode.EDIT;
    var hidePanelTitles = embeddable.parent ? Boolean(embeddable.parent.getInput().hidePanelTitles) : false;
    _this.state = {
      panels: [],
      viewMode: viewMode,
      hidePanelTitles: hidePanelTitles,
      closeContextMenu: false
    };
    _this.embeddableRoot = _react.default.createRef();
    return _this;
  }

  _createClass(EmbeddablePanel, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      var _this2 = this;

      this.mounted = true;
      var embeddable = this.props.embeddable;
      var parent = embeddable.parent;
      this.subscription = embeddable.getInput$().subscribe(
      /*#__PURE__*/
      _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee2() {
        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (_this2.mounted) {
                  _this2.setState({
                    viewMode: embeddable.getInput().viewMode ? embeddable.getInput().viewMode : _types.ViewMode.EDIT
                  });
                }

              case 1:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      })));

      if (parent) {
        this.parentSubscription = parent.getInput$().subscribe(
        /*#__PURE__*/
        _asyncToGenerator(
        /*#__PURE__*/
        regeneratorRuntime.mark(function _callee3() {
          return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  if (_this2.mounted && parent) {
                    _this2.setState({
                      hidePanelTitles: Boolean(parent.getInput().hidePanelTitles)
                    });
                  }

                case 1:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3);
        })));
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.mounted = false;

      if (this.subscription) {
        this.subscription.unsubscribe();
      }

      if (this.parentSubscription) {
        this.parentSubscription.unsubscribe();
      }

      this.props.embeddable.destroy();
    }
  }, {
    key: "render",
    value: function render() {
      var viewOnlyMode = this.state.viewMode === _types.ViewMode.VIEW;
      var classes = (0, _classnames.default)('embPanel', {
        'embPanel--editing': !viewOnlyMode
      });
      var title = this.props.embeddable.getTitle();
      return _react.default.createElement(_eui.EuiPanel, {
        className: classes,
        "data-test-subj": "embeddablePanel",
        paddingSize: "none"
      }, _react.default.createElement(_panel_header.PanelHeader, {
        getActionContextMenuPanel: this.getActionContextMenuPanel,
        hidePanelTitles: this.state.hidePanelTitles,
        isViewMode: viewOnlyMode,
        closeContextMenu: this.state.closeContextMenu,
        title: title
      }), _react.default.createElement("div", {
        className: "embPanel__content",
        ref: this.embeddableRoot
      }));
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.embeddableRoot.current) {
        this.props.embeddable.render(this.embeddableRoot.current);
      }
    }
  }]);

  return EmbeddablePanel;
}(_react.default.Component);

exports.EmbeddablePanel = EmbeddablePanel;