/**
 * @file The `Bounded` type class represents totally ordered types that have an upper and lower boundary.
 *
 * Instances should satisfy the following law in addition to the `Ord` laws:
 *
 * - Bounded: `bottom <= a <= top`
 */
import { ordNumber } from './Ord';
/**
 * @since 1.0.0
 */
export const boundedNumber = Object.assign({}, ordNumber, { top: Infinity, bottom: -Infinity });
