"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var classnames_1 = __importDefault(require("classnames"));
var mobx_react_1 = require("mobx-react");
var react_1 = __importDefault(require("react"));
var axis_utils_1 = require("../../lib/axes/axis_utils");
var legend_item_1 = require("./legend_item");
var LegendComponent = /** @class */ (function (_super) {
    __extends(LegendComponent, _super);
    function LegendComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onCollapseLegend = function () {
            _this.props.chartStore.toggleLegendCollapsed();
        };
        _this.onLegendItemMouseover = function (legendItemKey) { return function () {
            _this.props.chartStore.onLegendItemOver(legendItemKey);
        }; };
        _this.onLegendItemMouseout = function () {
            _this.props.chartStore.onLegendItemOut();
        };
        _this.renderLegendElement = function (_a, legendItemKey, onMouseEnter, onMouseLeave) {
            var color = _a.color, label = _a.label, isSeriesVisible = _a.isSeriesVisible, displayValue = _a.displayValue;
            var tooltipValues = _this.props.chartStore.legendItemTooltipValues.get();
            var tooltipValue;
            if (tooltipValues && tooltipValues.get(legendItemKey)) {
                tooltipValue = tooltipValues.get(legendItemKey);
            }
            var display = tooltipValue != null ? tooltipValue : displayValue.formatted;
            var props = { color: color, label: label, isSeriesVisible: isSeriesVisible, legendItemKey: legendItemKey, displayValue: display };
            return react_1.default.createElement(legend_item_1.LegendItem, __assign({}, props, { key: legendItemKey, onMouseEnter: onMouseEnter, onMouseLeave: onMouseLeave }));
        };
        return _this;
    }
    LegendComponent.prototype.render = function () {
        var _this = this;
        var legendId = this.props.legendId;
        var _a = this.props.chartStore, initialized = _a.initialized, legendItems = _a.legendItems, legendPosition = _a.legendPosition, showLegend = _a.showLegend, legendCollapsed = _a.legendCollapsed, debug = _a.debug, chartTheme = _a.chartTheme;
        if (!showLegend.get() || !initialized.get() || legendItems.size === 0 || legendPosition === undefined) {
            return null;
        }
        var legendClasses = classnames_1.default('echLegend', "echLegend--" + legendPosition, {
            'echLegend--collapsed': legendCollapsed.get(),
            'echLegend--debug': debug,
        });
        var paddingStyle;
        if (axis_utils_1.isVertical(legendPosition)) {
            paddingStyle = {
                paddingTop: chartTheme.chartMargins.top,
                paddingBottom: chartTheme.chartMargins.bottom,
            };
        }
        return (react_1.default.createElement("div", { className: legendClasses, style: paddingStyle, id: legendId, "aria-hidden": legendCollapsed.get() },
            react_1.default.createElement("div", { className: "echLegendListContainer" },
                react_1.default.createElement("div", { className: "echLegendList" }, __spread(legendItems.values()).map(function (item) {
                    // const { isLegendItemVisible } = item;
                    // const legendItemProps = {
                    //   key: item.key,
                    //   className: classNames('echLegendList__item', {
                    //     'echLegendList__item--hidden': !isLegendItemVisible,
                    //   }),
                    //   onMouseEnter: this.onLegendItemMouseover(item.key),
                    //   onMouseLeave: this.onLegendItemMouseout,
                    // };
                    return _this.renderLegendElement(item, item.key, _this.onLegendItemMouseover(item.key), _this.onLegendItemMouseout);
                })))));
    };
    LegendComponent.displayName = 'Legend';
    return LegendComponent;
}(react_1.default.Component));
exports.Legend = mobx_react_1.inject('chartStore')(mobx_react_1.observer(LegendComponent));
//# sourceMappingURL=legend.js.map