/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.LayerDetails;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AlignImageryPanel;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public class AddImageryLayerAction
extends JosmAction
implements AdaptableAction {
    private final transient ImageryInfo info;

    public AddImageryLayerAction(ImageryInfo info) {
        super(info.getMenuName(), "imagery_menu", info.getToolTipText(), null, true, "imagery_" + info.getToolbarName(), false);
        this.setHelpId(HelpUtil.ht("/Preferences/Imagery"));
        this.info = info;
        this.installAdapters();
        String icon = info.getIcon();
        if (icon != null) {
            new ImageProvider(icon).setOptional(true).getResourceAsync(result -> {
                if (result != null) {
                    GuiHelper.runInEDT(() -> result.attachImageIcon(this));
                }
            });
        }
    }

    private static ImageryInfo convertImagery(ImageryInfo info) {
        try {
            switch (info.getImageryType()) {
                case WMS_ENDPOINT: {
                    if (info.getDefaultLayers() == null || info.getDefaultLayers().isEmpty()) {
                        return AddImageryLayerAction.getWMSLayerInfo(info);
                    }
                    return info;
                }
                case WMTS: {
                    if (info.getDefaultLayers() == null || info.getDefaultLayers().isEmpty()) {
                        WMTSTileSource tileSource = new WMTSTileSource(info);
                        DefaultLayer layerId = tileSource.userSelectLayer();
                        if (layerId != null) {
                            ImageryInfo copy = new ImageryInfo(info);
                            copy.setDefaultLayers(Collections.singletonList(layerId));
                            String layerName = tileSource.getLayers().stream().filter(x -> x.getIdentifier().equals(layerId.getLayerName())).map(WMTSTileSource.Layer::getUserTitle).findFirst().orElse("");
                            copy.setName(copy.getName() + ": " + layerName);
                            return copy;
                        }
                        return null;
                    }
                    return info;
                }
            }
            return info;
        }
        catch (MalformedURLException ex) {
            AddImageryLayerAction.handleException(ex, I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), null);
        }
        catch (IOException ex) {
            AddImageryLayerAction.handleException(ex, I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), null);
        }
        catch (WMSImagery.WMSGetCapabilitiesException ex) {
            AddImageryLayerAction.handleException(ex, I18n.tr("Could not parse WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), "Could not parse WMS layer list. Incoming data:\n" + ex.getIncomingData());
        }
        catch (WMTSTileSource.WMTSGetCapabilitiesException ex) {
            AddImageryLayerAction.handleException(ex, I18n.tr("Could not parse WMTS layer list.", new Object[0]), I18n.tr("WMTS Error", new Object[0]), "Could not parse WMTS layer list.");
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block5: {
            if (!this.isEnabled()) {
                return;
            }
            ImageryLayer layer = null;
            try {
                ImageryInfo infoToAdd = AddImageryLayerAction.convertImagery(this.info);
                if (infoToAdd != null) {
                    layer = ImageryLayer.create(infoToAdd);
                    this.getLayerManager().addLayer(layer);
                    AlignImageryPanel.addNagPanelIfNeeded(infoToAdd);
                }
            }
            catch (IllegalArgumentException | ReportedException ex) {
                if (ex.getMessage() == null || ex.getMessage().isEmpty() || GraphicsEnvironment.isHeadless()) {
                    throw ex;
                }
                Logging.error(ex);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
                if (layer == null) break block5;
                this.getLayerManager().removeLayer(layer);
            }
        }
    }

    private static LayerSelection askToSelectLayers(WMSImagery wms) {
        WMSLayerTree tree = new WMSLayerTree();
        tree.updateTree(wms);
        Collection<String> wmsFormats = wms.getFormats();
        JComboBox<String> formats = new JComboBox<String>(wmsFormats.toArray(new String[0]));
        formats.setSelectedItem(wms.getPreferredFormat());
        formats.setToolTipText(I18n.tr("Select image format for WMS layer", new Object[0]));
        if (!GraphicsEnvironment.isHeadless()) {
            ExtendedDialog dialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Select WMS layers", new Object[0]), I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0]));
            JScrollPane scrollPane = new JScrollPane(tree.getLayerTree());
            scrollPane.setPreferredSize(new Dimension(400, 400));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)scrollPane, GBC.eol().fill());
            panel.add(formats, GBC.eol().fill(2));
            dialog.setContent(panel);
            if (dialog.showDialog().getValue() != 1) {
                return null;
            }
        }
        return new LayerSelection(tree.getSelectedLayers(), (String)formats.getSelectedItem(), true);
    }

    protected static ImageryInfo getWMSLayerInfo(ImageryInfo info) throws IOException, WMSImagery.WMSGetCapabilitiesException {
        try {
            return AddImageryLayerAction.getWMSLayerInfo(info, AddImageryLayerAction::askToSelectLayers);
        }
        catch (MalformedURLException ex) {
            AddImageryLayerAction.handleException(ex, I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), null);
        }
        catch (IOException ex) {
            AddImageryLayerAction.handleException(ex, I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), null);
        }
        catch (WMSImagery.WMSGetCapabilitiesException ex) {
            AddImageryLayerAction.handleException(ex, I18n.tr("Could not parse WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), "Could not parse WMS layer list. Incoming data:\n" + ex.getIncomingData());
        }
        return null;
    }

    public static ImageryInfo getWMSLayerInfo(ImageryInfo info, Function<WMSImagery, LayerSelection> choice) throws IOException, WMSImagery.WMSGetCapabilitiesException {
        CheckParameterUtil.ensureThat(ImageryInfo.ImageryType.WMS_ENDPOINT == info.getImageryType(), "wms_endpoint imagery type expected");
        WMSImagery wms = new WMSImagery(info.getUrl(), info.getCustomHttpHeaders());
        LayerSelection selection = choice.apply(wms);
        if (selection == null) {
            return null;
        }
        String url = wms.buildGetMapUrl(selection.layers.stream().map(LayerDetails::getName).collect(Collectors.toList()), (Collection<String>)null, selection.format, selection.transparent);
        String selectedLayers = selection.layers.stream().map(LayerDetails::getName).collect(Collectors.joining(", "));
        ImageryInfo ret = new ImageryInfo(info);
        ret.setUrl(url);
        ret.setImageryType(ImageryInfo.ImageryType.WMS);
        ret.setName(info.getName() + selectedLayers);
        ret.setServerProjections(wms.getServerProjections(selection.layers));
        return ret;
    }

    private static void handleException(Exception ex, String uiMessage, String uiTitle, String logMessage) {
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), uiMessage, uiTitle, 0);
        }
        Logging.log(Logging.LEVEL_ERROR, logMessage, ex);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.info.isBlacklisted());
    }

    public String toString() {
        return "AddImageryLayerAction [info=" + this.info + ']';
    }

    public static class LayerSelection {
        private final List<LayerDetails> layers;
        private final String format;
        private final boolean transparent;

        public LayerSelection(List<LayerDetails> layers, String format, boolean transparent) {
            this.layers = layers;
            this.format = format;
            this.transparent = transparent;
        }
    }

    static class SelectWmsLayersDialog
    extends ExtendedDialog {
        SelectWmsLayersDialog(WMSLayerTree tree, JComboBox<String> formats) {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Select WMS layers", new Object[0]), I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0]));
            JScrollPane scrollPane = new JScrollPane(tree.getLayerTree());
            scrollPane.setPreferredSize(new Dimension(400, 400));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)scrollPane, GBC.eol().fill());
            panel.add(formats, GBC.eol().fill(2));
            this.setContent(panel);
        }
    }
}

