#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.13.2
id: QuickCheck-2.13.2-2FrYL0Zx0JL1157x99MUYA
key: QuickCheck-2.13.2-2FrYL0Zx0JL1157x99MUYA
license: BSD-3-Clause
copyright: 2000-2019 Koen Claessen, 2006-2008 Björn Bringert, 2009-2019 Nick Smallbone
maintainer: Nick Smallbone <nick@smallbone.se>
author: Koen Claessen <koen@chalmers.se>
homepage: https://github.com/nick8325/quickcheck
synopsis: Automatic testing of Haskell programs
description:
    QuickCheck is a library for random testing of program properties.
    The programmer provides a specification of the program, in the form of
    properties which functions should satisfy, and QuickCheck then tests that the
    properties hold in a large number of randomly generated cases.
    Specifications are expressed in Haskell, using combinators provided by
    QuickCheck. QuickCheck provides combinators to define properties, observe the
    distribution of test data, and define test data generators.
    .
    Most of QuickCheck'\''s functionality is exported by the main "Test.QuickCheck"
    module. The main exception is the monadic property testing library in
    "Test.QuickCheck.Monadic".
    .
    If you are new to QuickCheck, you can try looking at the following resources:
    .
    * The <http://www.cse.chalmers.se/~rjmh/QuickCheck/manual.html official QuickCheck manual>.
    It'\''s a bit out-of-date in some details and doesn'\''t cover newer QuickCheck features,
    but is still full of good advice.
    * <https://begriffs.com/posts/2017-01-14-design-use-quickcheck.html>,
    a detailed tutorial written by a user of QuickCheck.
    .
    The <https://hackage.haskell.org/package/quickcheck-instances quickcheck-instances>
    companion package provides instances for types in Haskell Platform packages
    at the cost of additional dependencies.
category: Testing
abi: f9f29eb3a17933b5de734df59a62cc4b
exposed: True
exposed-modules:
    Test.QuickCheck Test.QuickCheck.All Test.QuickCheck.Arbitrary
    Test.QuickCheck.Exception Test.QuickCheck.Features
    Test.QuickCheck.Function Test.QuickCheck.Gen
    Test.QuickCheck.Gen.Unsafe Test.QuickCheck.Modifiers
    Test.QuickCheck.Monadic Test.QuickCheck.Poly
    Test.QuickCheck.Property Test.QuickCheck.Random
    Test.QuickCheck.State Test.QuickCheck.Test Test.QuickCheck.Text
import-dirs: /usr/lib/ghc-8.6.5/site-local/QuickCheck-2.13.2
library-dirs: /usr/lib/ghc-8.6.5/site-local/QuickCheck-2.13.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/QuickCheck-2.13.2
hs-libraries: HSQuickCheck-2.13.2-2FrYL0Zx0JL1157x99MUYA
depends:
    base-4.12.0.0 containers-0.6.0.1 deepseq-1.4.4.0
    random-1.1-3ypV4EIycgb35PKjTYYr5q
    splitmix-0.0.3-H9sGLbdTiFIBMFODPQLh0t template-haskell-2.14.0.0
    transformers-0.5.6.2
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

