#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: esqueleto
version: 3.1.0
id: esqueleto-3.1.0-1ko4VhhbnMP9EGfIaiIaHU
key: esqueleto-3.1.0-1ko4VhhbnMP9EGfIaiIaHU
license: BSD-3-Clause
copyright: (c) 2012-2016 Felipe Almeida Lessa
maintainer: cma@bitemyapp.com
author: Felipe Lessa
homepage: https://github.com/bitemyapp/esqueleto
synopsis: Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.
    .
    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)
    .
    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.
    .
    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.
category: Database
abi: 2636ab1043ff3ed7803f4f8a4ecf6648
exposed: True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Internal.Language
    Database.Esqueleto.Internal.Sql Database.Esqueleto.MySQL
    Database.Esqueleto.PostgreSQL Database.Esqueleto.PostgreSQL.JSON
    Database.Esqueleto.SQLite
hidden-modules: Database.Esqueleto.Internal.Internal
                Database.Esqueleto.Internal.PersistentImport
                Database.Esqueleto.PostgreSQL.JSON.Instances Paths_esqueleto
import-dirs: /usr/lib/ghc-8.6.5/site-local/esqueleto-3.1.0
library-dirs: /usr/lib/ghc-8.6.5/site-local/esqueleto-3.1.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/esqueleto-3.1.0
hs-libraries: HSesqueleto-3.1.0-1ko4VhhbnMP9EGfIaiIaHU
depends:
    aeson-1.4.4.0-CNxP0F7FYeU7wjnur6PUp4 base-4.12.0.0
    blaze-html-0.9.1.1-BVzzc2FJfx7GiAJyBgw5Ja bytestring-0.10.8.2
    conduit-1.3.1.1-DEyzgVREq8JGnMpn8fab1M
    monad-logger-0.3.30-1u4kO32eEsdGuIQjkXPEMl
    persistent-2.10.1-8F5JFgmCSdn7QkpC92e0e9
    resourcet-1.2.2-LNFC9oX9jZq9q4YtEcrXC
    tagged-0.8.6-AoE7RQX12AwJxLvAxGYxtP text-1.2.3.1 time-1.8.0.2
    transformers-0.5.6.2 unliftio-0.2.12-1qTQajQfnO8A7kPjHIwpz
    unordered-containers-0.2.10.0-HXsxAsTvm9z649814xbQu4
haddock-interfaces: /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html: /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

