#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cassava
version: 0.5.1.0
id: cassava-0.5.1.0-4rEaI4lyR789GrFe7Y9Gyv
key: cassava-0.5.1.0-4rEaI4lyR789GrFe7Y9Gyv
license: BSD-3-Clause
copyright: (c) 2012 Johan Tibell
           (c) 2012 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: hvr@gnu.org
author: Johan Tibell
homepage: https://github.com/hvr/cassava
synopsis: A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.
    .
    @cassava@'\''s API includes support for
    .
    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")
    .
    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:
    .
    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"
    .
    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.
category: Text, Web, CSV
abi: d351ce8623f9c222ec5a579656fbc961
exposed: True
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming
hidden-modules: Data.Csv.Conversion Data.Csv.Conversion.Internal
                Data.Csv.Encoding Data.Csv.Types Data.Csv.Util
import-dirs: /usr/lib/ghc-8.6.5/site-local/cassava-0.5.1.0
library-dirs: /usr/lib/ghc-8.6.5/site-local/cassava-0.5.1.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/cassava-0.5.1.0
hs-libraries: HScassava-0.5.1.0-4rEaI4lyR789GrFe7Y9Gyv
depends:
    Only-0.1-4eYnxvcrr7tEbYgCvIkHLb array-0.5.3.0
    attoparsec-0.13.2.3-G0AWAouFPeyAsmzjnpc0yX base-4.12.0.0
    bytestring-0.10.8.2 containers-0.6.0.1 deepseq-1.4.4.0
    hashable-1.2.7.0-KHvCgUH7dIl7mI8fl4akIo
    scientific-0.3.6.2-L1dtV0bHm4E7J1We1UVw6b text-1.2.3.1
    text-short-0.1.3-Kb2aUj4bfhgEatUQy5duT1
    unordered-containers-0.2.10.0-HXsxAsTvm9z649814xbQu4
    vector-0.12.0.3-2LEYu9M2i7lERDtz76XG3n
haddock-interfaces: /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html: /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

