/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.simpleframework.http.core.Body;
import org.simpleframework.http.core.Builder;
import org.simpleframework.http.core.BuilderConsumer;
import org.simpleframework.http.core.Channel;
import org.simpleframework.http.core.Collector;
import org.simpleframework.http.core.Consumer;
import org.simpleframework.http.core.Header;
import org.simpleframework.http.core.Selector;
import org.simpleframework.http.core.Tracker;
import org.simpleframework.http.core.TrackerBuilder;
import org.simpleframework.http.session.Session;
import org.simpleframework.transport.Cursor;
import org.simpleframework.util.buffer.Allocator;
import org.simpleframework.util.lease.LeaseException;

class EntityCollector
implements Collector {
    private final Consumer entity;
    private final Builder builder;
    private final Channel channel;
    private final Cursor cursor;

    public EntityCollector(Allocator allocator, Tracker tracker, Channel channel) {
        this.builder = new TrackerBuilder(tracker, channel);
        this.entity = new BuilderConsumer(allocator, this.builder, channel);
        this.cursor = channel.getCursor();
        this.channel = channel;
    }

    public void collect(Selector selector) throws IOException {
        while (this.cursor.isReady() && !this.entity.isFinished()) {
            this.entity.consume(this.cursor);
        }
        if (this.cursor.isOpen()) {
            if (this.entity.isFinished()) {
                selector.ready(this);
            } else {
                selector.select(this);
            }
        }
    }

    public Session getSession(boolean create) throws LeaseException {
        return this.builder.getSession(create);
    }

    public Header getHeader() {
        return this.builder.getHeader();
    }

    public Body getBody() {
        return this.builder.getBody();
    }

    public Channel getChannel() {
        return this.builder.getChannel();
    }

    public SocketChannel getSocket() {
        return this.channel.getSocket();
    }
}

