# frozen_string_literal: true

class AddForeignKeyFromVulnerabilityFeedbackToUsers < ActiveRecord::Migration[5.1]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :vulnerability_feedback, :users, column: :comment_author_id, on_delete: :nullify
    add_concurrent_index :vulnerability_feedback, :comment_author_id
  end

  def down
    remove_foreign_key :vulnerability_feedback, column: :comment_author_id
    remove_concurrent_index :vulnerability_feedback, :comment_author_id
  end
end
