/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.util.Utils;

public class GoodsTradeItem
extends TradeItem {
    private Goods goods;

    public GoodsTradeItem(Game game, Player source, Player destination, Goods goods) {
        super(game, Messages.nameKey("model.tradeItem.goods"), source, destination);
        this.goods = goods;
    }

    public GoodsTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.goods != null && this.goods.getType() != null && this.goods.getAmount() > 0 && this.goods.getLocation() instanceof Ownable && this.getSource().owns((Ownable)((Object)this.goods.getLocation()));
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public StringTemplate getLabel() {
        return this.goods.getLabel(true);
    }

    @Override
    public Goods getGoods() {
        return this.goods;
    }

    @Override
    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    @Override
    public int evaluateFor(Player player) {
        int value;
        Market market = player.getMarket();
        Goods goods = this.getGoods();
        if (!this.isValid()) {
            return Integer.MIN_VALUE;
        }
        if (market == null) {
            value = 2 * goods.getAmount();
            if (this.getSource() == player) {
                value = -value;
            }
        } else if (this.getSource() == player) {
            value = -market.getBidPrice(goods.getType(), goods.getAmount());
        } else {
            value = market.getSalePrice(goods.getType(), goods.getAmount());
            value = (int)Math.round((double)value * (1.0 - (double)player.getTax() / 100.0));
        }
        return value;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof GoodsTradeItem) {
            return Utils.equals(this.goods, ((GoodsTradeItem)other).goods) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 37 * hash + Utils.hashCode(this.goods);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.goods.toXML(xw);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.goods = null;
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (Goods.getXMLElementTagName().equals(tag)) {
            this.goods = new Goods(game, xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" ").append(this.goods.getAmount()).append(" ").append(Messages.getName(this.goods)).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return GoodsTradeItem.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "goodsTradeItem";
    }
}

