/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;

public class DfsSearchResult
extends SearchPhaseResult {
    private static final Term[] EMPTY_TERMS = new Term[0];
    private static final TermStatistics[] EMPTY_TERM_STATS = new TermStatistics[0];
    private Term[] terms;
    private TermStatistics[] termStatistics;
    private ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
    private int maxDoc;

    public DfsSearchResult(StreamInput in) throws IOException {
        super(in);
        this.requestId = in.readLong();
        int termsSize = in.readVInt();
        if (termsSize == 0) {
            this.terms = EMPTY_TERMS;
        } else {
            this.terms = new Term[termsSize];
            for (int i = 0; i < this.terms.length; ++i) {
                this.terms[i] = new Term(in.readString(), in.readBytesRef());
            }
        }
        this.termStatistics = DfsSearchResult.readTermStats(in, this.terms);
        this.fieldStatistics = DfsSearchResult.readFieldStats(in);
        this.maxDoc = in.readVInt();
    }

    public DfsSearchResult(long id, SearchShardTarget shardTarget) {
        this.setSearchShardTarget(shardTarget);
        this.requestId = id;
    }

    public DfsSearchResult maxDoc(int maxDoc) {
        this.maxDoc = maxDoc;
        return this;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public DfsSearchResult termsStatistics(Term[] terms, TermStatistics[] termStatistics) {
        this.terms = terms;
        this.termStatistics = termStatistics;
        return this;
    }

    public DfsSearchResult fieldStatistics(ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics) {
        this.fieldStatistics = fieldStatistics;
        return this;
    }

    public Term[] terms() {
        return this.terms;
    }

    public TermStatistics[] termStatistics() {
        return this.termStatistics;
    }

    public ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.requestId);
        out.writeVInt(this.terms.length);
        for (Term term : this.terms) {
            out.writeString(term.field());
            out.writeBytesRef(term.bytes());
        }
        DfsSearchResult.writeTermStats(out, this.termStatistics);
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVInt(this.maxDoc);
    }

    public static void writeFieldStats(StreamOutput out, ObjectObjectHashMap<String, CollectionStatistics> fieldStatistics) throws IOException {
        out.writeVInt(fieldStatistics.size());
        for (ObjectObjectCursor c : fieldStatistics) {
            out.writeString((String)c.key);
            CollectionStatistics statistics = (CollectionStatistics)c.value;
            assert (statistics.maxDoc() >= 0L);
            out.writeVLong(statistics.maxDoc());
            if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
                out.writeVLong(statistics.docCount());
                out.writeVLong(statistics.sumTotalTermFreq());
                out.writeVLong(statistics.sumDocFreq());
                continue;
            }
            out.writeVLong(DfsSearchResult.addOne(statistics.docCount()));
            out.writeVLong(DfsSearchResult.addOne(statistics.sumTotalTermFreq()));
            out.writeVLong(DfsSearchResult.addOne(statistics.sumDocFreq()));
        }
    }

    public static void writeTermStats(StreamOutput out, TermStatistics[] termStatistics) throws IOException {
        out.writeVInt(termStatistics.length);
        for (TermStatistics termStatistic : termStatistics) {
            DfsSearchResult.writeSingleTermStats(out, termStatistic);
        }
    }

    public static void writeSingleTermStats(StreamOutput out, TermStatistics termStatistic) throws IOException {
        if (termStatistic != null) {
            assert (termStatistic.docFreq() > 0L);
            out.writeVLong(termStatistic.docFreq());
            out.writeVLong(DfsSearchResult.addOne(termStatistic.totalTermFreq()));
        } else {
            out.writeVLong(0L);
            out.writeVLong(0L);
        }
    }

    static ObjectObjectHashMap<String, CollectionStatistics> readFieldStats(StreamInput in) throws IOException {
        int numFieldStatistics = in.readVInt();
        ObjectObjectHashMap fieldStatistics = HppcMaps.newNoNullKeysMap(numFieldStatistics);
        for (int i = 0; i < numFieldStatistics; ++i) {
            long sumDocFreq;
            long sumTotalTermFreq;
            long docCount;
            String field = in.readString();
            assert (field != null);
            long maxDoc = in.readVLong();
            if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
                docCount = in.readVLong();
                sumTotalTermFreq = in.readVLong();
                sumDocFreq = in.readVLong();
            } else {
                docCount = DfsSearchResult.subOne(in.readVLong());
                sumTotalTermFreq = DfsSearchResult.subOne(in.readVLong());
                sumDocFreq = DfsSearchResult.subOne(in.readVLong());
            }
            CollectionStatistics stats = new CollectionStatistics(field, maxDoc, docCount, sumTotalTermFreq, sumDocFreq);
            fieldStatistics.put((Object)field, (Object)stats);
        }
        return fieldStatistics;
    }

    static TermStatistics[] readTermStats(StreamInput in, Term[] terms) throws IOException {
        TermStatistics[] termStatistics;
        int termsStatsSize = in.readVInt();
        if (termsStatsSize == 0) {
            termStatistics = EMPTY_TERM_STATS;
        } else {
            termStatistics = new TermStatistics[termsStatsSize];
            assert (terms.length == termsStatsSize);
            for (int i = 0; i < termStatistics.length; ++i) {
                BytesRef term = terms[i].bytes();
                long docFreq = in.readVLong();
                assert (docFreq >= 0L);
                long totalTermFreq = DfsSearchResult.subOne(in.readVLong());
                if (docFreq == 0L) continue;
                termStatistics[i] = new TermStatistics(term, docFreq, totalTermFreq);
            }
        }
        return termStatistics;
    }

    public static long addOne(long value) {
        assert (value + 1L >= 0L);
        return value + 1L;
    }

    public static long subOne(long value) {
        assert (value >= 0L);
        return value - 1L;
    }
}

