/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.libfolders;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.core.libfolders.ILibraryFolderNameProvider;
import org.eclipse.php.core.libfolders.LibraryFolderManager;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.libfolders.Messages;
import org.eclipse.wst.validation.internal.PreferencesWrapper;

public class AutoDetectLibraryFolderJob
extends WorkspaceJob {
    private static final String EXTENSION_POINT_ID = "org.eclipse.php.core.libraryFolderNameProviders";
    private static final String CLASS_ATTR = "class";
    private IProject[] fProjects;

    public AutoDetectLibraryFolderJob(IProject[] projects) {
        super(Messages.AutoDetectLibraryFolderJob_Name);
        this.fProjects = projects;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        LibraryFolderManager lfm = LibraryFolderManager.getInstance();
        IProject[] iProjectArray = this.fProjects;
        int n = this.fProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!this.hasDisabledPreference(project)) {
                String[] names = this.getCommonLibraryFolderNames(project);
                IFolder[] folders = this.getFoldersFromNames(project, names);
                try {
                    lfm.useAsLibraryFolder(folders, monitor);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.php.core", e.getLocalizedMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private boolean hasDisabledPreference(IProject project) {
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences((IProject)project, null);
        return prefs.get("disabled", null) != null;
    }

    private String[] getCommonLibraryFolderNames(IProject project) {
        IConfigurationElement[] elements;
        HashSet<String> result = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ILibraryFolderNameProvider extension;
                String[] names;
                Object o = element.createExecutableExtension(CLASS_ATTR);
                if (o instanceof ILibraryFolderNameProvider && (names = (extension = (ILibraryFolderNameProvider)o).getLibraryFolderNames(project)) != null) {
                    result.addAll(Arrays.asList(names));
                }
            }
            catch (Exception e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private IFolder[] getFoldersFromNames(IProject project, String[] folderNames) {
        HashSet<IFolder> result = new HashSet<IFolder>();
        String[] stringArray = folderNames;
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IFolder folder = project.getFolder(name);
            if (folder != null && folder.exists()) {
                result.add(folder);
            }
            ++n2;
        }
        return result.toArray(new IFolder[result.size()]);
    }
}

