/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search.text;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.php.internal.ui.search.text.ResultVisitor;
import org.eclipse.php.internal.ui.search.text.TextSearcher;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchScope;

public class TextSearcherFactory {
    public static final TextSearcher createSearcher(TextSearchEngine engine, TextSearchScope newSearchScope, ResultVisitor visitor, Pattern searchPattern) {
        return new TextSearcher(engine, newSearchScope, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(TextSearchScope newSearchScope, ResultVisitor visitor, Pattern searchPattern) {
        TextSearchEngine engine = TextSearchEngine.createDefault();
        return TextSearcherFactory.createSearcher(engine, newSearchScope, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(IResource resource, ResultVisitor visitor, Pattern searchPattern) {
        TextSearchScope searchScope = TextSearchScope.newSearchScope((IResource[])new IResource[]{resource}, (Pattern)Pattern.compile(".*"), (boolean)true);
        return TextSearcherFactory.createSearcher(searchScope, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(IResource resource, Pattern searchPattern) {
        ResultVisitor visitor = new ResultVisitor();
        return TextSearcherFactory.createSearcher(resource, visitor, searchPattern);
    }

    public static final TextSearcher createSearcher(IResource resource, String searchPattern) {
        Pattern pattern = Pattern.compile(searchPattern);
        return TextSearcherFactory.createSearcher(resource, pattern);
    }
}

