/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.Messages;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadCrumbsOperation
extends AbstractTrinidadTransformOperation {
    public Element transform(Element srcElement, Element curElement) {
        String style;
        Element outerSpan = this.createElement("span");
        String styleClass = this.calculateStyleClass("af_breadCrumbs", srcElement);
        if (styleClass != null) {
            this.appendAttribute(outerSpan, "class", styleClass);
        }
        if ((style = srcElement.getAttribute("inlineStyle")) != null) {
            this.appendAttribute(outerSpan, "style", style);
        }
        List<Element> childCmdNavItems = this.getChildCmdNavItems(srcElement);
        int currentChildIndex = 0;
        int numChildren = childCmdNavItems.size();
        if (numChildren > 0) {
            for (Element childCmdNavItem : childCmdNavItems) {
                Element nobr;
                if (this.isVertical(srcElement)) {
                    Element div = this.appendChildElement("div", outerSpan);
                    nobr = this.appendChildElement("nobr", div);
                    this.appendChildText(this.getIndentationString(currentChildIndex), nobr);
                } else {
                    nobr = this.appendChildElement("nobr", outerSpan);
                }
                Element innerSpan = this.appendChildElement("span", nobr);
                this.tagConverterContext.addChild((Node)childCmdNavItem, new ConvertPosition((Node)innerSpan, 0));
                if (currentChildIndex < numChildren - 1) {
                    this.appendChildText("\u00a0 > \u00a0", nobr);
                }
                ++currentChildIndex;
            }
        } else {
            this.appendAttribute(outerSpan, "style", "color:silver;font-family:Arial,Helvetica,Geneva,sans-serif;font-size:8pt;");
            this.appendChildText(Messages.BreadCrumbsOperation_EmptyBreadCrumbsTag, outerSpan);
        }
        return outerSpan;
    }

    private List<Element> getChildCmdNavItems(Element srcElement) {
        ArrayList<Element> childCmdNavItems;
        block3: {
            NodeList childElements;
            block2: {
                childCmdNavItems = new ArrayList<Element>();
                childElements = srcElement.getElementsByTagNameNS("http://myfaces.apache.org/trinidad", "commandNavigationItem");
                if (childElements == null || childElements.getLength() <= 0) break block2;
                int i = 0;
                int len = childElements.getLength();
                while (i < len) {
                    childCmdNavItems.add((Element)childElements.item(i));
                    ++i;
                }
                break block3;
            }
            Element nodeStampFacet = this.getChildFacetByName(srcElement, "nodeStamp");
            if (nodeStampFacet == null || (childElements = nodeStampFacet.getElementsByTagNameNS("http://myfaces.apache.org/trinidad", "commandNavigationItem")) == null || childElements.getLength() <= 0) break block3;
            int i = 0;
            int len = childElements.getLength();
            while (i < len) {
                childCmdNavItems.add((Element)childElements.item(i));
                ++i;
            }
        }
        return childCmdNavItems;
    }

    private boolean isVertical(Element srcElement) {
        String orientationAttr = srcElement.getAttribute("orientation");
        return "vertical".equalsIgnoreCase(orientationAttr);
    }

    private String getIndentationString(int indentationLevel) {
        StringBuffer indentation = new StringBuffer("");
        int i = 0;
        while (i < indentationLevel) {
            indentation.append(" \u00a0 \u00a0 \u00a0 \u00a0 \u00a0");
            ++i;
        }
        return indentation.toString();
    }
}

