/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.HashSet;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.core.internal.analysis.filter.KotlinGeneratedFilter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class KotlinDefaultArgumentsFilter
implements IFilter {
    static boolean isDefaultArgumentsMethodName(String methodName) {
        return methodName.endsWith("$default");
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if ((methodNode.access & 0x1000) == 0) {
            return;
        }
        if (!KotlinDefaultArgumentsFilter.isDefaultArgumentsMethodName(methodNode.name)) {
            return;
        }
        if (!KotlinGeneratedFilter.isKotlinClass(context)) {
            return;
        }
        new Matcher().match(methodNode, output);
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(MethodNode methodNode, IFilterOutput output) {
            this.cursor = methodNode.instructions.getFirst();
            HashSet<AbstractInsnNode> ignore = new HashSet<AbstractInsnNode>();
            int maskVar = Type.getMethodType((String)methodNode.desc).getArgumentTypes().length - 2;
            while (this.cursor.getOpcode() == 21 && ((VarInsnNode)this.cursor).var == maskVar) {
                this.next();
                this.nextIs(126);
                this.nextIs(153);
                if (this.cursor == null) {
                    return;
                }
                ignore.add(this.cursor);
                this.cursor = ((JumpInsnNode)this.cursor).label;
                this.skipNonOpcodes();
            }
            for (AbstractInsnNode i : ignore) {
                output.ignore(i, i);
            }
        }
    }
}

