/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.ui.internal.Logger;

public class LabeledComboBoxCellEditor
extends ComboBoxCellEditor {
    private boolean _fSettingValue = false;
    private Object[] _values;

    public static LabeledComboBoxCellEditor newInstance(Composite parent, Map valueLabelMap, int style) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Object key : valueLabelMap.keySet()) {
            String label = (String)valueLabelMap.get(key);
            list.add(new Object[]{key, label});
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String label1 = (String)((Object[])o1)[1];
                String label2 = (String)((Object[])o2)[1];
                return label1.compareTo(label2);
            }
        });
        Object[] values = new Object[list.size()];
        String[] labels = new String[list.size()];
        int i = 0;
        int n = list.size();
        while (i < n) {
            values[i] = ((Object[])list.get(i))[0];
            labels[i] = (String)((Object[])list.get(i))[1];
            ++i;
        }
        return new LabeledComboBoxCellEditor(parent, values, labels, style);
    }

    public LabeledComboBoxCellEditor(Composite parent, Object[] values, String[] labels) {
        this(parent, values, labels, 0);
    }

    public LabeledComboBoxCellEditor(Composite parent, Object[] values, String[] labels, int style) {
        super(parent, labels, style);
        this._values = values;
    }

    protected Object doGetValue() {
        Object index = super.doGetValue();
        int selection = -1;
        if (index instanceof Integer) {
            selection = (Integer)index;
        }
        if (selection >= 0) {
            return this._values[selection];
        }
        if (this.getControl() instanceof CCombo) {
            return ((CCombo)this.getControl()).getText();
        }
        return null;
    }

    protected void doSetValue(Object value) {
        if (this._fSettingValue) {
            return;
        }
        this._fSettingValue = true;
        if (value instanceof Integer) {
            super.doSetValue(value);
        } else {
            String stringValue = value.toString();
            int selection = -1;
            int i = 0;
            while (i < this._values.length) {
                if (this._values[i].equals(stringValue)) {
                    selection = i;
                }
                ++i;
            }
            if (selection >= 0) {
                super.doSetValue((Object)new Integer(selection));
            } else {
                super.doSetValue((Object)new Integer(-1));
                if (this.getControl() instanceof CCombo && !stringValue.equals(((CCombo)this.getControl()).getText())) {
                    ((CCombo)this.getControl()).setText(stringValue);
                }
            }
        }
        this._fSettingValue = false;
    }

    public void setItems(String[] newItems) {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            Logger.log((int)4, (String)"Attempted to update item list for disposed cell editor");
            return;
        }
        Object previousSelectedValue = this.getValue();
        super.setItems(newItems);
        if (previousSelectedValue != null && this.getControl() instanceof CCombo) {
            int i = 0;
            while (i < newItems.length) {
                if (newItems[i].equals(previousSelectedValue)) {
                    this.setValue(previousSelectedValue);
                }
                ++i;
            }
        }
    }
}

