/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.resource.xml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.translators.EnumeratedValueTranslator;
import org.eclipse.jpt.common.core.resource.xml.CommonPackage;
import org.eclipse.jpt.common.core.resource.xml.EBaseObjectImpl;
import org.eclipse.jpt.common.core.resource.xml.ERootObject;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.wst.common.internal.emf.resource.ConstantAttributeTranslator;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public abstract class ERootObjectImpl
extends EBaseObjectImpl
implements ERootObject {
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final String NAMESPACE_EDEFAULT = null;
    protected String namespace = NAMESPACE_EDEFAULT;
    protected static final String SCHEMA_LOCATION_EDEFAULT = null;
    protected String schemaLocation = SCHEMA_LOCATION_EDEFAULT;
    protected static final String IMPLIED_VERSION_EDEFAULT = null;
    protected String impliedVersion = IMPLIED_VERSION_EDEFAULT;

    protected ERootObjectImpl() {
    }

    protected EClass eStaticClass() {
        return CommonPackage.Literals.EROOT_OBJECT_IMPL;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldVersion, (Object)this.version));
        }
    }

    @Override
    public String getDocumentVersion() {
        String version = this.getVersion();
        return version == null ? this.getImpliedVersion() : version;
    }

    @Override
    public void setDocumentVersion(String newVersion) {
        this.setVersion(newVersion);
        this.setNamespace(this.getNamespaceForVersion(newVersion));
        this.setSchemaLocation(this.getSchemaLocationForVersion(newVersion));
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocationGen(String newSchemaLocation) {
        String oldSchemaLocation = this.schemaLocation;
        this.schemaLocation = newSchemaLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldSchemaLocation, (Object)this.schemaLocation));
        }
    }

    @Override
    public void setSchemaLocation(String newSchemaLocation) {
        this.setSchemaLocationGen(newSchemaLocation);
        for (Map.Entry<String, String> entry : this.schemaLocations().entrySet()) {
            if (!entry.getValue().equals(newSchemaLocation)) continue;
            this.setImpliedVersion(entry.getKey());
            return;
        }
        this.setImpliedVersion(null);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String newNamespace) {
        String oldNamespace = this.namespace;
        this.namespace = newNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldNamespace, (Object)this.namespace));
        }
    }

    @Override
    public String getImpliedVersion() {
        return this.impliedVersion;
    }

    @Override
    public void setImpliedVersion(String newImpliedVersion) {
        String oldImpliedVersion = this.impliedVersion;
        this.impliedVersion = newImpliedVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldImpliedVersion, (Object)this.impliedVersion));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getVersion();
            }
            case 1: {
                return this.getNamespace();
            }
            case 2: {
                return this.getSchemaLocation();
            }
            case 3: {
                return this.getImpliedVersion();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setVersion((String)newValue);
                return;
            }
            case 1: {
                this.setNamespace((String)newValue);
                return;
            }
            case 2: {
                this.setSchemaLocation((String)newValue);
                return;
            }
            case 3: {
                this.setImpliedVersion((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 1: {
                this.setNamespace(NAMESPACE_EDEFAULT);
                return;
            }
            case 2: {
                this.setSchemaLocation(SCHEMA_LOCATION_EDEFAULT);
                return;
            }
            case 3: {
                this.setImpliedVersion(IMPLIED_VERSION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 1: {
                return NAMESPACE_EDEFAULT == null ? this.namespace != null : !NAMESPACE_EDEFAULT.equals(this.namespace);
            }
            case 2: {
                return SCHEMA_LOCATION_EDEFAULT == null ? this.schemaLocation != null : !SCHEMA_LOCATION_EDEFAULT.equals(this.schemaLocation);
            }
            case 3: {
                return IMPLIED_VERSION_EDEFAULT == null ? this.impliedVersion != null : !IMPLIED_VERSION_EDEFAULT.equals(this.impliedVersion);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (version: ");
        result.append(this.version);
        result.append(", namespace: ");
        result.append(this.namespace);
        result.append(", schemaLocation: ");
        result.append(this.schemaLocation);
        result.append(", impliedVersion: ");
        result.append(this.impliedVersion);
        result.append(')');
        return result.toString();
    }

    @Override
    public TextRange getVersionTextRange() {
        return this.getAttributeTextRange("version");
    }

    protected abstract HashMap<String, String> schemaLocations();

    protected String getSchemaLocationForVersion(String version) {
        String schemaLocation = this.schemaLocations().get(version);
        if (schemaLocation == null) {
            JptCommonCorePlugin.instance().logError(new Throwable("No schema location defined for version: " + version));
        }
        return schemaLocation;
    }

    protected abstract HashMap<String, String> namespaces();

    protected String getNamespaceForVersion(String version) {
        String namespace = this.namespaces().get(version);
        if (namespace == null) {
            JptCommonCorePlugin.instance().logError(new Throwable("No namespace defined for version: " + version));
        }
        return namespace;
    }

    protected static Translator buildVersionTranslator(final Map<String, String> versionsToSchemaLocations) {
        return new EnumeratedValueTranslator("version", (EStructuralFeature)CommonPackage.eINSTANCE.getERootObject_Version(), 1){

            protected Iterable<String> getEnumeratedObjectValues() {
                return versionsToSchemaLocations.keySet();
            }
        };
    }

    protected static Translator buildNamespaceTranslator() {
        return new Translator("xmlns", (EStructuralFeature)CommonPackage.eINSTANCE.getERootObject_Namespace(), 1);
    }

    protected static Translator buildSchemaNamespaceTranslator() {
        return new ConstantAttributeTranslator("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    protected static Translator buildSchemaLocationTranslator(final Map<String, String> versionsToSchemaLocations) {
        return new EnumeratedValueTranslator("xsi:schemaLocation", (EStructuralFeature)CommonPackage.eINSTANCE.getERootObject_SchemaLocation(), 1){

            protected Iterable<String> getEnumeratedObjectValues() {
                return versionsToSchemaLocations.values();
            }

            @Override
            public Object convertStringToValue(String string, EObject owner) {
                String[] split = string.split("\\s+");
                int length = split.length;
                return length == 0 ? null : split[length - 1];
            }

            @Override
            public String convertValueToString(Object value, EObject owner) {
                String namespace = ((ERootObject)owner).getNamespace();
                String schemaLocation = (String)value;
                return String.valueOf(namespace) + ' ' + schemaLocation;
            }
        };
    }
}

