/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.contentmodel.internal;

import java.util.Stack;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;

public class XSDVisitor {
    protected XSDSchema schema;
    protected Stack particleStack = new Stack();

    public void visitSchema(XSDSchema schema) {
        this.schema = schema;
        for (XSDAttributeDeclaration attr : schema.getAttributeDeclarations()) {
            this.visitAttributeDeclaration(attr);
        }
        for (XSDTypeDefinition type : schema.getTypeDefinitions()) {
            this.visitTypeDefinition(type);
        }
        for (XSDElementDeclaration element : schema.getElementDeclarations()) {
            this.visitElementDeclaration(element);
        }
        for (XSDIdentityConstraintDefinition identityConstraint : schema.getIdentityConstraintDefinitions()) {
            this.visitIdentityConstraintDefinition(identityConstraint);
        }
        for (XSDModelGroupDefinition modelGroup : schema.getModelGroupDefinitions()) {
            this.visitModelGroupDefinition(modelGroup);
        }
        for (XSDAttributeGroupDefinition attributeGroup : schema.getAttributeGroupDefinitions()) {
            this.visitAttributeGroupDefinition(attributeGroup);
        }
        for (XSDElementDeclaration element : schema.getNotationDeclarations()) {
            this.visitNotationDeclaration((XSDNotationDeclaration)element);
        }
    }

    public void visitAttributeDeclaration(XSDAttributeDeclaration attr) {
    }

    public void visitTypeDefinition(XSDTypeDefinition type) {
        if (type instanceof XSDSimpleTypeDefinition) {
            this.visitSimpleTypeDefinition((XSDSimpleTypeDefinition)type);
        } else if (type instanceof XSDComplexTypeDefinition) {
            this.visitComplexTypeDefinition((XSDComplexTypeDefinition)type);
        }
    }

    public void visitElementDeclaration(XSDElementDeclaration element) {
        if (!element.isElementDeclarationReference() && element.getAnonymousTypeDefinition() != null) {
            this.visitTypeDefinition(element.getAnonymousTypeDefinition());
        }
    }

    public void visitIdentityConstraintDefinition(XSDIdentityConstraintDefinition identityConstraint) {
    }

    public void visitModelGroupDefinition(XSDModelGroupDefinition modelGroupDef) {
        if (!modelGroupDef.isModelGroupDefinitionReference() && modelGroupDef.getModelGroup() != null) {
            this.visitModelGroup(modelGroupDef.getModelGroup());
        }
    }

    public void visitAttributeGroupDefinition(XSDAttributeGroupDefinition attributeGroup) {
    }

    public void visitNotationDeclaration(XSDNotationDeclaration notation) {
    }

    public void visitSimpleTypeDefinition(XSDSimpleTypeDefinition type) {
    }

    public void visitComplexTypeDefinition(XSDComplexTypeDefinition type) {
        if (type.getContentType() != null) {
            XSDComplexTypeContent complexContent = type.getContentType();
            if (complexContent instanceof XSDSimpleTypeDefinition) {
                this.visitSimpleTypeDefinition((XSDSimpleTypeDefinition)complexContent);
            } else if (complexContent instanceof XSDParticle) {
                this.visitParticle((XSDParticle)complexContent);
            }
        }
    }

    public void visitParticle(XSDParticle particle) {
        this.visitParticleContent(particle.getContent());
    }

    public void visitParticleContent(XSDParticleContent particleContent) {
        if (particleContent instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition modelGroupDef = (XSDModelGroupDefinition)particleContent;
            if (this.particleStack.contains(modelGroupDef)) {
                return;
            }
            this.particleStack.push(modelGroupDef);
            this.visitModelGroupDefinition(modelGroupDef);
            this.particleStack.pop();
        } else if (particleContent instanceof XSDModelGroup) {
            this.visitModelGroup((XSDModelGroup)particleContent);
        } else if (particleContent instanceof XSDElementDeclaration) {
            this.visitElementDeclaration((XSDElementDeclaration)particleContent);
        } else if (particleContent instanceof XSDWildcard) {
            this.visitWildcard((XSDWildcard)particleContent);
        }
    }

    public void visitModelGroup(XSDModelGroup modelGroup) {
        if (modelGroup.getContents() != null) {
            for (XSDParticle particle : modelGroup.getContents()) {
                this.visitParticle(particle);
            }
        }
    }

    public void visitWildcard(XSDWildcard wildcard) {
    }
}

