/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.PathEditorInput;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class STPEditor
extends TextEditor {
    private Annotation[] stpOldAnnotations;
    private ProjectionAnnotationModel stpAnnotationModel;
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor";

    public STPEditor() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.linuxtools.systemtap.ui.ide.context"});
        this.configureInsertMode(SMART_INSERT, false);
        this.setSourceViewerConfiguration(new STPConfiguration(this));
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof FileStoreEditorInput) {
            input = new PathEditorInput((IPath)new Path(((FileStoreEditorInput)input).getURI().getPath()));
        }
        super.doSetInput(input);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport stpProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        stpProjectionSupport.install();
        viewer.doOperation(19);
        this.stpAnnotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(ArrayList<Position> updatedPositions) {
        Annotation[] updatedAnnotations = new Annotation[updatedPositions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < updatedPositions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, updatedPositions.get(i));
            updatedAnnotations[i] = annotation;
            ++i;
        }
        this.stpAnnotationModel.modifyAnnotations(this.stpOldAnnotations, newAnnotations, null);
        this.stpOldAnnotations = updatedAnnotations;
    }

    public ISourceViewer getMySourceViewer() {
        return this.getSourceViewer();
    }

    public void insertText(String text) {
        IDocument doc = this.getSourceViewer().getDocument();
        String s = doc.get();
        int offset = s.length();
        s = String.valueOf(s) + text;
        doc.set(s);
        this.setHighlightRange(offset, 0, true);
    }

    public void insertTextAtCurrent(String text) {
        ISelection selection = this.getSelectionProvider().getSelection();
        IDocument doc = this.getSourceViewer().getDocument();
        if (selection instanceof ITextSelection) {
            ITextSelection s = (ITextSelection)selection;
            StringBuilder sb = new StringBuilder(doc.get().substring(0, s.getOffset()));
            sb.append(text.trim());
            sb.append(doc.get().substring(s.getOffset() + s.getLength(), doc.get().length()));
            doc.set(sb.toString());
            this.setHighlightRange(s.getOffset() + text.trim().length(), 0, true);
        }
    }

    public void jumpToLocation(int line, int character) {
        IDocument doc = this.getSourceViewer().getDocument();
        try {
            int offset = doc.getLineOffset(line - 1) + character;
            this.getSelectionProvider().setSelection((ISelection)new TextSelection(doc, offset, 0));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void selectLine(int line) {
        IDocument doc = this.getSourceViewer().getDocument();
        try {
            this.getSelectionProvider().setSelection((ISelection)new TextSelection(doc, doc.getLineOffset(line - 1), doc.getLineLength(line - 1) - 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSaveAs() {
        IEditorInput inputFile;
        block16: {
            File file = STPEditor.queryFile();
            if (file == null) {
                return;
            }
            inputFile = STPEditor.createEditorInput(file);
            IDocument doc = this.getSourceViewer().getDocument();
            String s = doc.get();
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        try (PrintStream ps = new PrintStream(fos);){
                            ps.print(s);
                            ps.close();
                        }
                        if (fos == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setInput(inputFile);
        this.setPartName(inputFile.getName());
    }

    private static IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        return new PathEditorInput((IPath)location);
    }

    private static File queryFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setText(Messages.NewFileHandler_NewFile);
        String path = dialog.open();
        if (path != null && !path.isEmpty()) {
            return new File(path);
        }
        return null;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }
}

