/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

public class OSDescriptor {
    private String code;
    private String arch;

    public OSDescriptor(String code, String arch) {
        this.code = code;
        this.arch = arch;
    }

    public String getCode() {
        return this.code;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean matches(OSDescriptor os) {
        if (!this.code.equals(os.code)) {
            return false;
        }
        return this.arch == null || os.arch != null && this.arch.equals(os.arch);
    }

    public boolean isWindows() {
        return "win32".equals(this.code);
    }

    public String toString() {
        return String.valueOf(this.code) + (this.arch == null ? "" : " (" + this.arch + ")");
    }

    public boolean is64() {
        return "x86_64".equals(this.arch);
    }
}

