/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociationLazy;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressLoaderVisualizer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.editors.data.DatabaseDataEditor;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.utils.CommonUtils;

public class ReferenceValueEditor {
    private static final Log log = Log.getLog(ReferenceValueEditor.class);
    private IValueController valueController;
    private IValueEditor valueEditor;
    private DBSEntityReferrer refConstraint;
    private Table editorSelector;
    private volatile boolean sortByValue = true;
    private volatile boolean sortAsc = true;
    private volatile boolean dictLoaded = false;
    private Object lastPattern;

    public ReferenceValueEditor(IValueController valueController, IValueEditor valueEditor) {
        this.valueController = valueController;
        this.valueEditor = valueEditor;
    }

    public void setValueEditor(IValueEditor valueEditor) {
        this.valueEditor = valueEditor;
    }

    public boolean isReferenceValue() {
        return this.getEnumerableConstraint() != null;
    }

    @Nullable
    private DBSEntityReferrer getEnumerableConstraint() {
        if (this.valueController instanceof IAttributeController) {
            return ReferenceValueEditor.getEnumerableConstraint(((IAttributeController)this.valueController).getBinding());
        }
        return null;
    }

    public static DBSEntityReferrer getEnumerableConstraint(DBDAttributeBinding binding) {
        try {
            DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
            if (entityAttribute != null) {
                DBSDictionary dictionary;
                List refs = DBUtils.getAttributeReferrers((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAttribute)entityAttribute, (boolean)true);
                DBSEntityReferrer constraint = refs.isEmpty() ? null : (DBSEntityReferrer)refs.get(0);
                DBSEntity[] associatedEntity = new DBSEntity[1];
                if (constraint instanceof DBSEntityAssociationLazy) {
                    UIUtils.runInProgressService(monitor -> {
                        try {
                            dBSEntityArray[0] = ((DBSEntityAssociationLazy)constraint).getAssociatedEntity(monitor);
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                } else if (constraint instanceof DBSEntityAssociation) {
                    associatedEntity[0] = ((DBSEntityAssociation)constraint).getAssociatedEntity();
                }
                if (associatedEntity[0] instanceof DBSDictionary && (dictionary = (DBSDictionary)associatedEntity[0]).supportsDictionaryEnumeration()) {
                    return constraint;
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return null;
    }

    public boolean createEditorSelector(final Composite parent) {
        Object curValue;
        DBSEntityAssociation association;
        if (!(this.valueController instanceof IAttributeController) || this.valueController.isReadOnly()) {
            return false;
        }
        this.refConstraint = this.getEnumerableConstraint();
        if (this.refConstraint == null) {
            return false;
        }
        if (this.refConstraint instanceof DBSEntityAssociation && (association = (DBSEntityAssociation)this.refConstraint).getReferencedConstraint() != null) {
            final DBSEntity refTable = association.getReferencedConstraint().getParentObject();
            Composite labelGroup = UIUtils.createPlaceholder((Composite)parent, (int)2);
            labelGroup.setLayoutData((Object)new GridData(768));
            Link dictLabel = UIUtils.createLink((Composite)labelGroup, (String)NLS.bind((String)ResultSetMessages.dialog_value_view_label_dictionary, (Object)refTable.getName()), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IWorkbenchWindow window = ReferenceValueEditor.this.valueController.getValueSite().getWorkbenchWindow();
                    UIUtils.runInUI((IRunnableContext)window, monitor -> {
                        DBNDatabaseNode tableNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)refTable, (boolean)true);
                        if (tableNode != null) {
                            NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)tableNode, (String)DatabaseDataEditor.class.getName(), (IWorkbenchWindow)window);
                        }
                    });
                }
            });
            dictLabel.setLayoutData((Object)new GridData(32));
            Link hintLabel = UIUtils.createLink((Composite)labelGroup, (String)"(<a>Define Description</a>)", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage(refTable);
                    if (editDictionaryPage.edit(parent.getShell())) {
                        ReferenceValueEditor.this.reloadSelectorValues(null);
                    }
                }
            });
            hintLabel.setLayoutData((Object)new GridData(896));
        }
        this.editorSelector = new Table(parent, 68356);
        this.editorSelector.setLinesVisible(true);
        this.editorSelector.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.editorSelector.setLayoutData((Object)gd);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.editorSelector, (int)16384, (String)ResultSetMessages.dialog_value_view_column_value);
        valueColumn.setData((Object)Boolean.TRUE);
        TableColumn descColumn = UIUtils.createTableColumn((Table)this.editorSelector, (int)16384, (String)ResultSetMessages.dialog_value_view_column_description);
        descColumn.setData((Object)Boolean.FALSE);
        SortListener sortListener = new SortListener();
        valueColumn.addListener(13, (Listener)sortListener);
        descColumn.addListener(13, (Listener)sortListener);
        this.editorSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ReferenceValueEditor.this.editorSelector.getSelection();
                if (selection != null && selection.length > 0) {
                    Object value = selection[0].getData();
                    try {
                        ReferenceValueEditor.this.valueEditor.primeEditorValue(value);
                    }
                    catch (DBException e1) {
                        log.error((Object)e1);
                    }
                }
            }
        });
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            manager.add((IAction)new CopyAction());
            manager.add((IContributionItem)new Separator());
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.editorSelector.setMenu(menuMgr.createContextMenu((Control)this.editorSelector));
        this.editorSelector.addDisposeListener(e -> menuMgr.dispose());
        Control control = this.valueEditor.getControl();
        ModifyListener modifyListener = e -> {
            Object curEditorValue;
            try {
                curEditorValue = this.valueEditor.extractEditorValue();
            }
            catch (DBException e1) {
                log.error((Object)e1);
                return;
            }
            String curTextValue = this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)this.valueController).getBinding(), curEditorValue, DBDDisplayFormat.UI);
            boolean valueFound = false;
            if (curTextValue != null) {
                TableItem[] items = this.editorSelector.getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    if (curTextValue.equalsIgnoreCase(item.getText(0)) || curTextValue.equalsIgnoreCase(item.getText(1))) {
                        this.editorSelector.select(this.editorSelector.indexOf(item));
                        this.editorSelector.showItem(item);
                        valueFound = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!valueFound) {
                this.reloadSelectorValues(curEditorValue);
            }
        };
        if (control instanceof Text) {
            ((Text)control).addModifyListener(modifyListener);
        } else if (control instanceof StyledText) {
            ((StyledText)control).addModifyListener(modifyListener);
        }
        if (this.refConstraint instanceof DBSEntityAssociation) {
            Text valueFilterText = new Text(parent, 2048);
            valueFilterText.setLayoutData((Object)new GridData(768));
            valueFilterText.addModifyListener(e -> {
                String filterPattern = valueFilterText.getText();
                this.reloadSelectorValues(filterPattern);
            });
            valueFilterText.addPaintListener(e -> {
                if (valueFilterText.isEnabled() && valueFilterText.getCharCount() == 0) {
                    e.gc.setForeground(parent.getDisplay().getSystemColor(18));
                    e.gc.drawText("Type part of dictionary value to search", 2, 0, true);
                    e.gc.setFont(null);
                }
            });
        }
        this.reloadSelectorValues((curValue = this.valueController.getValue()) instanceof Number ? curValue : null);
        return true;
    }

    private void reloadSelectorValues(Object pattern) {
        if (this.dictLoaded && CommonUtils.equalObjects((Object)String.valueOf(this.lastPattern), (Object)String.valueOf(pattern))) {
            this.selectCurrentValue();
            return;
        }
        this.lastPattern = pattern;
        this.dictLoaded = true;
        SelectorLoaderService loadingService = new SelectorLoaderService();
        if (pattern != null) {
            loadingService.setPattern(pattern);
        }
        LoadingJob.createService((ILoadService)loadingService, (ILoadVisualizer)new SelectorLoaderVisualizer(loadingService)).schedule();
    }

    private void updateDictionarySelector(EnumValuesData valuesData) {
        if (this.editorSelector == null || this.editorSelector.isDisposed()) {
            return;
        }
        this.editorSelector.setRedraw(false);
        try {
            this.editorSelector.removeAll();
            for (DBDLabelValuePair entry : valuesData.keyValues) {
                TableItem discItem = new TableItem(this.editorSelector, 0);
                discItem.setText(0, valuesData.keyHandler.getValueDisplayString((DBSTypedObject)valuesData.keyColumn.getAttribute(), entry.getValue(), DBDDisplayFormat.UI));
                discItem.setText(1, entry.getLabel());
                discItem.setData(entry.getValue());
            }
            this.selectCurrentValue();
            UIUtils.packColumns((Table)this.editorSelector, (boolean)false);
        }
        finally {
            this.editorSelector.setRedraw(true);
        }
    }

    private void selectCurrentValue() {
        Control editorControl = this.valueEditor.getControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            try {
                Object curValue = this.valueEditor.extractEditorValue();
                String curTextValue = this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)this.valueController).getBinding(), curValue, DBDDisplayFormat.UI);
                TableItem curItem = null;
                int curItemIndex = -1;
                TableItem[] items = this.editorSelector.getItems();
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    if (item.getText(0).equals(curTextValue)) {
                        curItem = item;
                        curItemIndex = i;
                        break;
                    }
                    ++i;
                }
                if (curItem != null) {
                    this.editorSelector.setSelection(curItem);
                    this.editorSelector.showItem(curItem);
                    int finalCurItemIndex = curItemIndex;
                    UIUtils.asyncExec(() -> this.editorSelector.setTopIndex(finalCurItemIndex));
                } else {
                    this.editorSelector.deselectAll();
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private class CopyAction
    extends Action {
        public CopyAction() {
            super("Copy Value");
        }

        public void run() {
            StringBuilder result = new StringBuilder();
            TableItem[] tableItemArray = ReferenceValueEditor.this.editorSelector.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(item.getText(0));
                ++n2;
            }
            UIUtils.setClipboardContents((Display)ReferenceValueEditor.this.editorSelector.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)result.toString());
        }
    }

    private static class EnumValuesData {
        List<DBDLabelValuePair> keyValues;
        DBSEntityAttributeRef keyColumn;
        DBDValueHandler keyHandler;

        public EnumValuesData(Collection<DBDLabelValuePair> keyValues, DBSEntityAttributeRef keyColumn, DBDValueHandler keyHandler) {
            this.keyValues = new ArrayList<DBDLabelValuePair>(keyValues);
            this.keyColumn = keyColumn;
            this.keyHandler = keyHandler;
        }
    }

    class SelectorLoaderService
    extends AbstractLoadService<EnumValuesData> {
        private Object pattern;

        private SelectorLoaderService() {
            super(String.valueOf(ResultSetMessages.dialog_value_view_job_selector_name) + ReferenceValueEditor.this.valueController.getValueName() + " possible values");
        }

        void setPattern(@Nullable Object pattern) {
            this.pattern = pattern;
        }

        public EnumValuesData evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            block15: {
                List enumValues;
                DBSEntityAttribute fkAttribute;
                DBSEntityAttributeRef fkColumn;
                block16: {
                    DBSEntityAttribute refColumn;
                    DBSEntityAssociation association;
                    IAttributeController attributeController;
                    block14: {
                        DBSEntityAttribute tableColumn;
                        block13: {
                            block12: {
                                block11: {
                                    if (ReferenceValueEditor.this.editorSelector.isDisposed()) {
                                        return null;
                                    }
                                    attributeController = (IAttributeController)ReferenceValueEditor.this.valueController;
                                    tableColumn = attributeController.getBinding().getEntityAttribute();
                                    if (tableColumn != null) break block11;
                                    return null;
                                }
                                fkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)ReferenceValueEditor.this.refConstraint, (DBSEntityAttribute)tableColumn);
                                if (fkColumn != null) break block12;
                                return null;
                            }
                            if (ReferenceValueEditor.this.refConstraint instanceof DBSEntityAssociation) {
                                association = (DBSEntityAssociation)ReferenceValueEditor.this.refConstraint;
                                break block13;
                            }
                            return null;
                        }
                        refColumn = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)tableColumn, (boolean)false);
                        if (refColumn != null) break block14;
                        return null;
                    }
                    ArrayList<DBDAttributeValue> precedingKeys = null;
                    List allColumns = CommonUtils.safeList((List)ReferenceValueEditor.this.refConstraint.getAttributeReferences(monitor));
                    if (allColumns.size() > 1 && allColumns.get(0) != fkColumn) {
                        List<DBDAttributeBinding> rowAttributes = attributeController.getRowController().getRowAttributes();
                        precedingKeys = new ArrayList<DBDAttributeValue>();
                        for (DBSEntityAttributeRef precColumn : allColumns) {
                            DBDAttributeBinding rowAttr;
                            if (precColumn == fkColumn) break;
                            DBSEntityAttribute precAttribute = precColumn.getAttribute();
                            if (precAttribute == null || (rowAttr = DBUtils.findBinding(rowAttributes, (DBSAttributeBase)precAttribute)) == null) continue;
                            Object precValue = attributeController.getRowController().getAttributeValue(rowAttr);
                            precedingKeys.add(new DBDAttributeValue((DBSAttributeBase)precAttribute, precValue));
                        }
                    }
                    fkAttribute = fkColumn.getAttribute();
                    DBSEntityConstraint refConstraint = association.getReferencedConstraint();
                    DBSDictionary enumConstraint = (DBSDictionary)refConstraint.getParentObject();
                    if (fkAttribute == null || enumConstraint == null) break block15;
                    enumValues = enumConstraint.getDictionaryEnumeration(monitor, refColumn, this.pattern, precedingKeys, ReferenceValueEditor.this.sortByValue, ReferenceValueEditor.this.sortAsc, 200);
                    if (!monitor.isCanceled()) break block16;
                    return null;
                }
                try {
                    DBDValueHandler colHandler = DBUtils.findValueHandler((DBPDataSource)fkAttribute.getDataSource(), (DBSTypedObject)fkAttribute);
                    return new EnumValuesData(enumValues, fkColumn, colHandler);
                }
                catch (DBException e) {
                    log.warn((Object)e);
                }
            }
            return null;
        }

        public Object getFamily() {
            return ReferenceValueEditor.this.valueController.getExecutionContext();
        }
    }

    private class SelectorLoaderVisualizer
    extends ProgressLoaderVisualizer<EnumValuesData> {
        public SelectorLoaderVisualizer(SelectorLoaderService loadingService) {
            super((ILoadService)loadingService, (Composite)ReferenceValueEditor.this.editorSelector);
        }

        public void visualizeLoading() {
            super.visualizeLoading();
        }

        public void completeLoading(EnumValuesData result) {
            super.completeLoading((Object)result);
            super.visualizeLoading();
            if (result != null) {
                ReferenceValueEditor.this.updateDictionarySelector(result);
            }
        }
    }

    private class SortListener
    implements Listener {
        private TableColumn prevColumn = null;
        private int sortDirection = 1024;

        public void handleEvent(Event event) {
            TableColumn column = (TableColumn)event.widget;
            if (this.prevColumn == column) {
                this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
            }
            this.prevColumn = column;
            ReferenceValueEditor.this.sortByValue = (Boolean)column.getData();
            ReferenceValueEditor.this.sortAsc = this.sortDirection == 1024;
            ReferenceValueEditor.this.editorSelector.setSortColumn(column);
            ReferenceValueEditor.this.editorSelector.setSortDirection(this.sortDirection);
            ReferenceValueEditor.this.reloadSelectorValues(ReferenceValueEditor.this.lastPattern);
        }
    }
}

