/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple.ui;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.compare.simple.ui.CompareObjectsWizard;
import org.jkiss.dbeaver.tools.compare.simple.ui.CompareWizardDialog;

public class CompareObjectsHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(CompareObjectsHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() < 2) {
            DBWorkbench.getPlatformUI().showError("Just one object selected", "At least two objects must be selected to perform structure compare");
            return null;
        }
        ArrayList<DBNDatabaseNode> nodes = new ArrayList<DBNDatabaseNode>();
        Class<?> firstType = null;
        DBXTreeNode firstMeta = null;
        for (DBNDatabaseNode node : ss) {
            DBXTreeNode meta = null;
            if (node instanceof DBNDatabaseFolder) {
                meta = node.getMeta();
                if (firstMeta == null) {
                    firstMeta = meta;
                }
            }
            if (node.getObject() == null) {
                log.error((Object)"Bad node with null object");
                return null;
            }
            Class<?> itemType = node.getObject().getClass();
            if (firstType == null) {
                firstType = itemType;
            } else if (firstType != itemType || firstMeta != meta) {
                DBWorkbench.getPlatformUI().showError("Different object types", "Objects of different types were selected. You may compare only objects of the same type");
                return null;
            }
            nodes.add(node);
        }
        CompareWizardDialog dialog = new CompareWizardDialog(workbenchWindow, (IWizard)new CompareObjectsWizard(nodes));
        dialog.open();
        return null;
    }
}

