/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;

public abstract class DataTransferHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        ArrayList<IDataTransferProducer> producers = new ArrayList<IDataTransferProducer>();
        ArrayList<IDataTransferConsumer> consumers = new ArrayList<IDataTransferConsumer>();
        for (Object object : ss) {
            IDataTransferNode node = this.adaptTransferNode(object);
            if (node instanceof IDataTransferProducer) {
                producers.add((IDataTransferProducer)node);
                continue;
            }
            if (!(node instanceof IDataTransferConsumer)) continue;
            consumers.add((IDataTransferConsumer)node);
        }
        if (!producers.isEmpty() || !consumers.isEmpty()) {
            ActiveWizardDialog dialog = new ActiveWizardDialog(workbenchWindow, (IWizard)new DataTransferWizard(producers.toArray(new IDataTransferProducer[producers.size()]), consumers.toArray(new IDataTransferConsumer[consumers.size()])));
            dialog.open();
        }
        return null;
    }

    protected abstract IDataTransferNode adaptTransferNode(Object var1);
}

