/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.control;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardItem;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewContainer;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.ui.dnd.LocalObjectTransfer;

public class DashboardList
extends Composite
implements DashboardGroupContainer {
    private static final int ITEM_SPACING = 5;
    private IWorkbenchSite site;
    private DashboardViewContainer viewContainer;
    private List<DashboardItem> items = new ArrayList<DashboardItem>();
    private final Font boldFont;
    private DashboardItem selectedItem;
    private int listRowCount = 1;
    private int listColumnCount = 1;

    public DashboardList(IWorkbenchSite site, Composite parent, DashboardViewContainer viewContainer) {
        super(parent, 0x20000000);
        this.site = site;
        this.viewContainer = viewContainer;
        Font normalFont = this.getFont();
        FontData[] fontData = normalFont.getFontData();
        fontData[0].setHeight(fontData[0].getHeight() + 1);
        fontData[0].setStyle(1);
        this.boldFont = new Font(normalFont.getDevice(), fontData[0]);
        this.addDisposeListener(e -> this.boldFont.dispose());
        this.setForeground(UIStyles.getDefaultTextForeground());
        this.setBackground(UIStyles.getDefaultTextBackground());
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.registerContextMenu();
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                DashboardList.this.setSelection(null);
                DashboardList.this.setFocus();
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DashboardList.this.handleKeyEvent(e);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DashboardList.this.computeGridSize();
                DashboardList.this.layout(true, true);
            }
        });
    }

    public int getListRowCount() {
        return this.listRowCount;
    }

    public int getListColumnCount() {
        return this.listColumnCount;
    }

    private void computeGridSize() {
        int totalItems = this.items.size();
        Point listAreaSize = this.getSize();
        if (listAreaSize.x <= 0 || listAreaSize.y <= 0 || this.items.isEmpty()) {
            return;
        }
        this.listRowCount = 1;
        int rowCount = 1;
        while (rowCount < 50) {
            int itemsPerRow = (int)Math.ceil((float)totalItems / (float)rowCount);
            int itemWidth = listAreaSize.x / itemsPerRow;
            int itemHeight = itemWidth / 3;
            int totalHeight = itemHeight * rowCount;
            if (totalHeight > listAreaSize.y) {
                if (rowCount <= 1) break;
                this.listRowCount = rowCount - 1;
                break;
            }
            ++rowCount;
        }
        ((GridLayout)this.getLayout()).numColumns = this.listColumnCount = (int)Math.ceil((float)totalItems / (float)this.listRowCount);
    }

    void handleKeyEvent(KeyEvent e) {
        switch (e.keyCode) {
            case 13: {
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.view", (IServiceLocator)this.site);
                break;
            }
            case 127: {
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.remove", (IServiceLocator)this.site);
                break;
            }
            case 0x1000009: {
                ActionUtils.runCommand((String)"org.jkiss.dbeaver.ui.dashboard.add", (IServiceLocator)this.site);
                break;
            }
            case 0x1000001: 
            case 0x1000003: {
                this.moveSelection(-1);
                break;
            }
            case 0x1000002: 
            case 0x1000004: {
                this.moveSelection(1);
            }
        }
    }

    private void moveSelection(int delta) {
        if (this.items.isEmpty()) {
            return;
        }
        if (this.selectedItem == null) {
            this.setSelection(this.items.get(0));
        } else {
            int curIndex = this.items.indexOf(this.selectedItem);
            if ((curIndex += delta) < 0) {
                curIndex = this.items.size() - 1;
            } else if (curIndex >= this.items.size()) {
                curIndex = 0;
            }
            DashboardItem newSelection = this.items.get(curIndex);
            newSelection.getDashboardControl().setFocus();
            this.setSelection(newSelection);
            newSelection.redraw();
        }
    }

    private void registerContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.ui.dashboard.add"));
        menuMgr.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.site, (String)"org.jkiss.dbeaver.ui.dashboard.reset"));
        this.setMenu(menuMgr.createContextMenu((Control)this));
        this.addDisposeListener(e -> menuMgr.dispose());
    }

    DBPDataSourceContainer getDataSourceContainer() {
        return this.viewContainer.getDataSourceContainer();
    }

    @Override
    public DashboardViewContainer getView() {
        return this.viewContainer;
    }

    public List<DashboardItem> getItems() {
        return this.items;
    }

    @Override
    public void removeItem(DashboardContainer container) {
        DashboardItem item = (DashboardItem)container;
        item.dispose();
        this.layout(true, true);
        this.viewContainer.getViewConfiguration().removeDashboard(item.getDashboardId());
        this.viewContainer.getViewConfiguration().saveSettings();
    }

    @Override
    public void addItem(String dashboardId) {
        DashboardDescriptor dashboardDescriptor = DashboardRegistry.getInstance().getDashboard(dashboardId);
        if (dashboardDescriptor == null) {
            return;
        }
        this.viewContainer.getViewConfiguration().readDashboardConfiguration(dashboardDescriptor);
        new DashboardItem(this, dashboardId);
        this.viewContainer.getViewConfiguration().saveSettings();
        this.layout(true, true);
    }

    @Override
    public void selectItem(DashboardContainer item) {
        this.setSelection((DashboardItem)item);
        item.getDashboardControl().setFocus();
    }

    void createDefaultDashboards() {
        List<DashboardDescriptor> dashboards = DashboardRegistry.getInstance().getDashboards((DBPNamedObject)this.viewContainer.getDataSourceContainer(), true);
        for (DashboardDescriptor dd : dashboards) {
            this.addDashboard(dd);
        }
    }

    public void createDashboardsFromConfiguration() {
        for (DashboardItemViewConfiguration itemConfig : this.viewContainer.getViewConfiguration().getDashboardItemConfigs()) {
            this.addDashboard(itemConfig.getDashboardDescriptor());
        }
    }

    private void addDashboard(DashboardDescriptor dashboard) {
        this.viewContainer.getViewConfiguration().readDashboardConfiguration(dashboard);
        new DashboardItem(this, dashboard.getId());
    }

    void addItem(DashboardItem item) {
        this.addDragAndDropSupport(item);
        this.items.add(item);
    }

    void removeItem(DashboardItem item) {
        this.items.remove(item);
    }

    public int getItemSpacing() {
        return 5;
    }

    public Font getTitleFont() {
        return this.boldFont;
    }

    public DashboardItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelection(DashboardItem selection) {
        DashboardItem oldSelection = this.selectedItem;
        this.selectedItem = selection;
        if (oldSelection != null && !oldSelection.isDisposed()) {
            oldSelection.redraw();
        }
    }

    private void addDragAndDropSupport(DashboardItem item) {
        Label dndControl = item.getTitleLabel();
        DragSource source = new DragSource((Control)dndControl, 3);
        source.setTransfer(new Transfer[]{DashboardTransfer.INSTANCE});
        source.addDragListener(new DragSourceListener(){
            private Image dragImage;
            private long lastDragEndTime;

            public void dragStart(DragSourceEvent event) {
                if (DashboardList.this.selectedItem == null || this.lastDragEndTime > 0L && System.currentTimeMillis() - this.lastDragEndTime < 100L) {
                    event.doit = false;
                } else {
                    Rectangle columnBounds = DashboardList.this.selectedItem.getBounds();
                    GC gc = new GC((Drawable)DashboardList.this);
                    this.dragImage = new Image((Device)Display.getCurrent(), columnBounds.width, columnBounds.height);
                    gc.copyArea(this.dragImage, columnBounds.x, columnBounds.y);
                    event.image = this.dragImage;
                    gc.dispose();
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (DashboardList.this.selectedItem != null && DashboardTransfer.INSTANCE.isSupportedType(event.dataType)) {
                    event.data = DashboardList.this.selectedItem;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                if (this.dragImage != null) {
                    UIUtils.dispose((Resource)this.dragImage);
                    this.dragImage = null;
                }
                this.lastDragEndTime = System.currentTimeMillis();
            }
        });
        this.addControlDropTarget((Control)dndControl, 3);
        this.addControlDropTarget((Control)item.getDashboardControl(), 3);
    }

    private void addControlDropTarget(Control dndControl, int operations) {
        DropTarget dropTarget = new DropTarget(dndControl, operations);
        dropTarget.setTransfer(new Transfer[]{DashboardTransfer.INSTANCE, TextTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    UIUtils.asyncExec(() -> this.moveDashboard(event));
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = !this.isDropSupported(event) ? 0 : 2;
                event.feedback = 1;
            }

            private boolean isDropSupported(DropTargetEvent event) {
                DashboardItem overItem = this.getOverItem(event);
                if (DashboardList.this.selectedItem == null || overItem == null) {
                    return false;
                }
                return overItem != DashboardList.this.selectedItem;
            }

            private void moveDashboard(DropTargetEvent event) {
                DashboardItem overItem = this.getOverItem(event);
                if (DashboardList.this.selectedItem == null || overItem == null || DashboardList.this.selectedItem == overItem) {
                    return;
                }
                ArrayList<DashboardItem> newList = new ArrayList<DashboardItem>(DashboardList.this.items);
                int newIndex = newList.indexOf(overItem);
                newList.remove(DashboardList.this.selectedItem);
                newList.add(newIndex, DashboardList.this.selectedItem);
                DashboardViewConfiguration viewConfiguration = DashboardList.this.viewContainer.getViewConfiguration();
                DashboardList.this.setRedraw(false);
                try {
                    DashboardList.this.selectedItem = null;
                    DashboardList.this.items.clear();
                    int i = 0;
                    while (i < newList.size()) {
                        DashboardItem oldItem = (DashboardItem)newList.get(i);
                        DashboardItem newItem = new DashboardItem(DashboardList.this, oldItem.getDashboardId());
                        DashboardItemViewConfiguration dashboardConfig = viewConfiguration.getDashboardConfig(newItem.getDashboardId());
                        dashboardConfig.setIndex(i);
                        newItem.moveViewFrom(oldItem, true);
                        ++i;
                    }
                    for (DashboardItem item : newList) {
                        item.dispose();
                    }
                }
                finally {
                    DashboardList.this.layout(true, true);
                    DashboardList.this.setRedraw(true);
                }
                viewConfiguration.saveSettings();
            }

            private DashboardItem getOverItem(DropTargetEvent event) {
                Object source = event.getSource();
                if (source instanceof DropTarget) {
                    Control control = ((DropTarget)source).getControl();
                    Composite parent = control.getParent();
                    while (parent != null) {
                        if (parent instanceof DashboardItem) {
                            return (DashboardItem)parent;
                        }
                        parent = parent.getParent();
                    }
                }
                return null;
            }
        });
    }

    public void showItem(DashboardContainer item) {
    }

    public static final class DashboardTransfer
    extends LocalObjectTransfer<List<Object>> {
        public static final DashboardTransfer INSTANCE = new DashboardTransfer();
        private static final String TYPE_NAME = "DashboardTransfer.Item Transfer" + System.currentTimeMillis() + ":" + ((Object)((Object)INSTANCE)).hashCode();
        private static final int TYPEID = DashboardTransfer.registerType((String)TYPE_NAME);

        private DashboardTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }
    }
}

