/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
!function(){"use strict";function t(t){function s(t){const e=t.options,n=t.contents,o=(new DOMParser).parseFromString(n,"text/html");if(o.querySelectorAll("a").forEach(t=>{t.title||(t.title=t.getAttribute("href"))}),e.allowScripts){const e=o.createElement("script");e.textContent=function(t){
return`\n\t\t\tconst acquireVsCodeApi = (function() {\n\t\t\t\tconst originalPostMessage = window.parent.postMessage.bind(window.parent);\n\t\t\t\tconst targetOrigin = '*';\n\t\t\t\tlet acquired = false;\n\n\t\t\t\tlet state = ${t?`JSON.parse(${JSON.stringify(t)})`:void 0};\n\n\t\t\t\treturn () => {\n\t\t\t\t\tif (acquired) {\n\t\t\t\t\t\tthrow new Error('An instance of the VS Code API has already been acquired');\n\t\t\t\t\t}\n\t\t\t\t\tacquired = true;\n\t\t\t\t\treturn Object.freeze({\n\t\t\t\t\t\tpostMessage: function(msg) {\n\t\t\t\t\t\t\treturn originalPostMessage({ command: 'onmessage', data: msg }, targetOrigin);\n\t\t\t\t\t\t},\n\t\t\t\t\t\tsetState: function(newState) {\n\t\t\t\t\t\t\tstate = newState;\n\t\t\t\t\t\t\toriginalPostMessage({ command: 'do-update-state', data: JSON.stringify(newState) }, targetOrigin);\n\t\t\t\t\t\t\treturn newState;\n\t\t\t\t\t\t},\n\t\t\t\t\t\tgetState: function() {\n\t\t\t\t\t\t\treturn state;\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t};\n\t\t\t})();\n\t\t\tdelete window.parent;\n\t\t\tdelete window.top;\n\t\t\tdelete window.frameElement;\n\t\t`
}(t.state),o.head.prepend(e)}const s=o.createElement("style");return s.id="_defaultStyles",s.innerHTML=r,o.head.prepend(s),l(o,o.body),"<!DOCTYPE html>\n"+o.documentElement.outerHTML}let a,i=!0,c=[];const d={initialScrollProgress:void 0},l=(t,e)=>{if(t&&(e&&(e.classList.remove("vscode-light","vscode-dark","vscode-high-contrast"),e.classList.add(d.activeTheme)),d.styles))for(const e of Object.keys(d.styles))t.documentElement.style.setProperty(`--${e}`,d.styles[e])},u=e=>{if(!e||!e.view||!e.view.document)return;let n=e.view.document.getElementsByTagName("base")[0],o=e.target;for(;o;){if(o.tagName&&"a"===o.tagName.toLowerCase()&&o.href){if("#"===o.getAttribute("href"))e.view.scrollTo(0,0);else if(o.hash&&(o.getAttribute("href")===o.hash||n&&o.href.indexOf(n.href)>=0)){let t=e.view.document.getElementById(o.hash.substr(1,o.hash.length-1));t&&t.scrollIntoView()}else t.postMessage("did-click-link",o.href.baseVal||o.href);e.preventDefault();break}o=o.parentNode}};let m=!1
;document.addEventListener("DOMContentLoaded",()=>{const r=document.location.search.match(/\bid=([\w-]+)/),f=r?r[1]:void 0;if(!document.body)return;t.onMessage("styles",(t,e)=>{d.styles=e.styles,d.activeTheme=e.activeTheme;const o=n();o&&o.contentDocument&&l(o.contentDocument,o.contentDocument.body)}),t.onMessage("focus",()=>{const t=n();t&&t.contentWindow.focus()});let g=0;t.onMessage("content",async(e,r)=>{function v(e){clearTimeout(a),a=void 0,a=setTimeout(()=>{clearTimeout(a),a=void 0,S(e.contentDocument,e.contentWindow)},200),e.contentWindow.addEventListener("load",function(t){a&&(clearTimeout(a),a=void 0,S(t.target,this))}),e.contentWindow.addEventListener("click",u),t.onIframeLoaded&&t.onIframeLoaded(e)}const b=++g;if(await t.ready,b!==g)return;const h=r.options,w=s(r),y=n(),p=i;let k;if(i)i=!1,k=((t,e)=>{isNaN(d.initialScrollProgress)||0===e.scrollY&&e.scroll(0,t.clientHeight*d.initialScrollProgress)});else{const t=y&&y.contentDocument&&y.contentDocument.body?y.contentWindow.scrollY:0;k=((e,n)=>{
0===n.scrollY&&n.scroll(0,t)})}const M=o();M&&(M.setAttribute("id",""),document.body.removeChild(M)),p||(c=[]);const L=document.createElement("iframe");L.setAttribute("id","pending-frame"),L.setAttribute("frameborder","0"),L.setAttribute("sandbox",h.allowScripts?"allow-scripts allow-forms allow-same-origin":"allow-same-origin"),t.fakeLoad&&(L.src=`./fake.html?id=${f}`),L.style.cssText="display: block; margin: 0; overflow: hidden; position: absolute; width: 100%; height: 100%; visibility: hidden",document.body.appendChild(L),t.fakeLoad||L.contentDocument.open(),L.contentWindow.addEventListener("keydown",e=>{t.postMessage("did-keydown",{key:e.key,keyCode:e.keyCode,code:e.code,shiftKey:e.shiftKey,altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey,repeat:e.repeat})}),L.contentWindow.addEventListener("DOMContentLoaded",e=>{t.fakeLoad&&(L.contentDocument.open(),L.contentDocument.write(w),L.contentDocument.close(),v(L));const n=e.target?e.target:void 0;n&&l(n,n.body)});const S=(e,r)=>{e&&e.body&&k(e.body,r)
;const s=o();if(s&&s.contentDocument&&s.contentDocument===e){const e=n();e&&document.body.removeChild(e),l(s.contentDocument,s.contentDocument.body),s.setAttribute("id","active-frame"),s.style.visibility="visible",t.focusIframeOnCreate&&s.contentWindow.focus(),r.addEventListener("scroll",e=>{if(!e.target||!e.target.body)return;if(m)return;const n=e.currentTarget.scrollY/e.target.body.clientHeight;isNaN(n)||(m=!0,window.requestAnimationFrame(()=>{try{t.postMessage("did-scroll",n)}catch(t){}m=!1}))}),c.forEach(t=>{r.postMessage(t,"*")}),c=[]}};t.fakeLoad||v(L),t.fakeLoad||(L.contentDocument.write(w),L.contentDocument.close()),t.postMessage("did-set-content",void 0)}),t.onMessage("message",(t,e)=>{if(!o()){const t=n();if(t)return void t.contentWindow.postMessage(e,"*")}c.push(e)}),t.onMessage("initial-scroll-position",(t,e)=>{d.initialScrollProgress=e}),e({onFocus:()=>t.postMessage("did-focus"),onBlur:()=>t.postMessage("did-blur")}),t.postMessage("webview-ready",{})})}const e=({onFocus:t,onBlur:e})=>{
let n=document.hasFocus();setInterval(()=>{const o=document.hasFocus();o!==n&&(n=o,o?t():e())},50)
},n=()=>document.getElementById("active-frame"),o=()=>document.getElementById("pending-frame"),r="\n\tbody {\n\t\tbackground-color: var(--vscode-editor-background);\n\t\tcolor: var(--vscode-editor-foreground);\n\t\tfont-family: var(--vscode-font-family);\n\t\tfont-weight: var(--vscode-font-weight);\n\t\tfont-size: var(--vscode-font-size);\n\t\tmargin: 0;\n\t\tpadding: 0 20px;\n\t}\n\n\timg {\n\t\tmax-width: 100%;\n\t\tmax-height: 100%;\n\t}\n\n\ta {\n\t\tcolor: var(--vscode-textLink-foreground);\n\t}\n\n\ta:hover {\n\t\tcolor: var(--vscode-textLink-activeForeground);\n\t}\n\n\ta:focus,\n\tinput:focus,\n\tselect:focus,\n\ttextarea:focus {\n\t\toutline: 1px solid -webkit-focus-ring-color;\n\t\toutline-offset: -1px;\n\t}\n\n\tcode {\n\t\tcolor: var(--vscode-textPreformat-foreground);\n\t}\n\n\tblockquote {\n\t\tbackground: var(--vscode-textBlockQuote-background);\n\t\tborder-color: var(--vscode-textBlockQuote-border);\n\t}\n\n\t::-webkit-scrollbar {\n\t\twidth: 10px;\n\t\theight: 10px;\n\t}\n\n\t::-webkit-scrollbar-thumb {\n\t\tbackground-color: var(--vscode-scrollbarSlider-background);\n\t}\n\t::-webkit-scrollbar-thumb:hover {\n\t\tbackground-color: var(--vscode-scrollbarSlider-hoverBackground);\n\t}\n\t::-webkit-scrollbar-thumb:active {\n\t\tbackground-color: var(--vscode-scrollbarSlider-activeBackground);\n\t}"
;"undefined"!=typeof module?module.exports=t:window.createWebviewManager=t}();
//# sourceMappingURL=https://ticino.blob.core.windows.net/sourcemaps/f06011ac164ae4dc8e753a3fe7f9549844d15e35/core/vs/workbench/contrib/webview/browser/pre/main.js.map
