/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "World" },
            { "002", "Africa" },
            { "003", "North America" },
            { "005", "South America" },
            { "009", "Oceania" },
            { "011", "Western Africa" },
            { "013", "Central America" },
            { "014", "Eastern Africa" },
            { "015", "Northern Africa" },
            { "017", "Middle Africa" },
            { "018", "Southern Africa" },
            { "019", "Americas" },
            { "021", "Northern America" },
            { "029", "Caribbean" },
            { "030", "Eastern Asia" },
            { "034", "Southern Asia" },
            { "035", "South-Eastern Asia" },
            { "039", "Southern Europe" },
            { "053", "Australia and New Zealand" },
            { "054", "Melanesia" },
            { "057", "Micronesian Region" },
            { "061", "Polynesia" },
            { "062", "South-Central Asia" },
            { "142", "Asia" },
            { "143", "Central Asia" },
            { "145", "Western Asia" },
            { "150", "Europe" },
            { "151", "Eastern Europe" },
            { "154", "Northern Europe" },
            { "155", "Western Europe" },
            { "172", "Commonwealth of Independent States" },
            { "200", "Czechoslovakia" },
            { "419", "Latin America" },
            { "830", "Channel Islands" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua and Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AN", "Netherlands Antilles" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land Islands" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia and Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Bonaire, Sint Eustatius, and Saba" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Cocos [Keeling] Islands" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton Island" },
            { "CR", "Costa Rica" },
            { "CS", "Serbia and Montenegro" },
            { "CT", "Canton and Enderbury Islands" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "CZ", "Czech Republic" },
            { "DD", "East Germany" },
            { "DE", "Germany" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "DM", "Dominica" },
            { "DO", "Dominican Republic" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta and Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "Western Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "European Union" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Faroe Islands" },
            { "FQ", "French Southern and Antarctic Territories" },
            { "FR", "France" },
            { "FX", "Metropolitan France" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia and the South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard Island and McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "IC", "Canary Islands" },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "JT", "Johnston Island" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts and Nevis" },
            { "KP", "North Korea" },
            { "KR", "South Korea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Marshall Islands" },
            { "MI", "Midway Islands" },
            { "MK", "Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar [Burma]" },
            { "MN", "Mongolia" },
            { "MO", "Macau SAR China" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NQ", "Dronning Maud Land" },
            { "NR", "Nauru" },
            { "NT", "Neutral Zone" },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PC", "Pacific Islands Trust Territory" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "PM", "Saint Pierre and Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "PU", "U.S. Miscellaneous Pacific Islands" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "PZ", "Panama Canal Zone" },
            { "QA", "Qatar" },
            { "QO", "Outlying Oceania" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Solomon Islands" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard and Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "South Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 and Pr\u00edncipe" },
            { "SU", "Union of Soviet Socialist Republics" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks and Caicos Islands" },
            { "TD", "Chad" },
            { "TF", "French Southern Territories" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkey" },
            { "TT", "Trinidad and Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "U.S. Minor Outlying Islands" },
            { "US", "United States" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatican City" },
            { "VC", "Saint Vincent and the Grenadines" },
            { "VD", "North Vietnam" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis and Futuna" },
            { "WK", "Wake Island" },
            { "WS", "Samoa" },
            { "YD", "People\u2019s Democratic Republic of Yemen" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "South Africa" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Unknown Region" },
            { "aa", "Afar" },
            { "ab", "Abkhazian" },
            { "ae", "Avestan" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharic" },
            { "an", "Aragonese" },
            { "ar", "Arabic" },
            { "as", "Assamese" },
            { "av", "Avaric" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "ba", "Bashkir" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bh", "Bihari" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengali" },
            { "bo", "Tibetan" },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "ca", "Catalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsican" },
            { "cr", "Cree" },
            { "cs", "Czech" },
            { "cu", "Church Slavic" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Danish" },
            { "de", "German" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", "Greek" },
            { "en", "English" },
            { "eo", "Esperanto" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "eu", "Basque" },
            { "fa", "Persian" },
            { "ff", "Fulah" },
            { "fi", "Finnish" },
            { "fj", "Fijian" },
            { "fo", "Faroese" },
            { "fr", "French" },
            { "fy", "Western Frisian" },
            { "ga", "Irish" },
            { "gd", "Scottish Gaelic" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", "Hebrew" },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", "Croatian" },
            { "ht", "Haitian" },
            { "hu", "Hungarian" },
            { "hy", "Armenian" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesian" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupiaq" },
            { "io", "Ido" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "ja", "Japanese" },
            { "jv", "Javanese" },
            { "ka", "Georgian" },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", "Khmer" },
            { "kn", "Kannada" },
            { "ko", "Korean" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirghiz" },
            { "la", "Latin" },
            { "lb", "Luxembourgish" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", "Lao" },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "mi", "Maori" },
            { "mk", "Macedonian" },
            { "ml", "Malayalam" },
            { "mn", "Mongolian" },
            { "mo", "Moldavian" },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Maltese" },
            { "my", "Burmese" },
            { "na", "Nauru" },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "North Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Occitan" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", "Oriya" },
            { "os", "Ossetic" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Polish" },
            { "ps", "Pashto" },
            { "pt", "Portuguese" },
            { "qu", "Quechua" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "ro", "Romanian" },
            { "ru", "Russian" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinian" },
            { "sd", "Sindhi" },
            { "se", "Northern Sami" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croatian" },
            { "si", "Sinhala" },
            { "sk", "Slovak" },
            { "sl", "Slovenian" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albanian" },
            { "sr", "Serbian" },
            { "ss", "Swati" },
            { "st", "Southern Sotho" },
            { "su", "Sundanese" },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "ta", "Tamil" },
            { "te", "Telugu" },
            { "tg", "Tajik" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahitian" },
            { "ug", "Uighur" },
            { "uk", "Ukrainian" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vietnamese" },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Chinese" },
            { "zu", "Zulu" },
            { "ace", "Achinese" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "afa", "Afro-Asiatic Language" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "akk", "Akkadian" },
            { "ale", "Aleut" },
            { "alg", "Algonquian Language" },
            { "alt", "Southern Altai" },
            { "ang", "Old English" },
            { "anp", "Angika" },
            { "apa", "Apache Language" },
            { "arc", "Aramaic" },
            { "arn", "Araucanian" },
            { "arp", "Arapaho" },
            { "art", "Artificial Language" },
            { "arw", "Arawak" },
            { "asa", "Asu" },
            { "ast", "Asturian" },
            { "ath", "Athapascan Language" },
            { "aus", "Australian Language" },
            { "awa", "Awadhi" },
            { "bad", "Banda" },
            { "bai", "Bamileke Language" },
            { "bal", "Baluchi" },
            { "ban", "Balinese" },
            { "bas", "Basaa" },
            { "bat", "Baltic Language" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "ber", "Berber" },
            { "bez", "Bena" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bla", "Siksika" },
            { "bnt", "Bantu" },
            { "bra", "Braj" },
            { "brx", "Bodo" },
            { "btk", "Batak" },
            { "bua", "Buriat" },
            { "bug", "Buginese" },
            { "byn", "Blin" },
            { "cad", "Caddo" },
            { "cai", "Central American Indian Language" },
            { "car", "Carib" },
            { "cau", "Caucasian Language" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "cel", "Celtic Language" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "chn", "Chinook Jargon" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", "Cherokee" },
            { "chy", "Cheyenne" },
            { "ckb", "Sorani Kurdish" },
            { "cmc", "Chamic Language" },
            { "cop", "Coptic" },
            { "cpe", "English-based Creole or Pidgin" },
            { "cpf", "French-based Creole or Pidgin" },
            { "cpp", "Portuguese-based Creole or Pidgin" },
            { "crh", "Crimean Turkish" },
            { "crp", "Creole or Pidgin" },
            { "csb", "Kashubian" },
            { "cus", "Cushitic Language" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "day", "Dayak" },
            { "del", "Delaware" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dra", "Dravidian Language" },
            { "dsb", "Lower Sorbian" },
            { "dua", "Duala" },
            { "dum", "Middle Dutch" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "Ancient Egyptian" },
            { "eka", "Ekajuk" },
            { "elx", "Elamite" },
            { "enm", "Middle English" },
            { "ewo", "Ewondo" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipino" },
            { "fiu", "Finno-Ugrian Language" },
            { "fon", "Fon" },
            { "frm", "Middle French" },
            { "fro", "Old French" },
            { "frr", "Northern Frisian" },
            { "frs", "Eastern Frisian" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gem", "Germanic Language" },
            { "gez", "Geez" },
            { "gil", "Gilbertese" },
            { "gmh", "Middle High German" },
            { "goh", "Old High German" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", "Gothic" },
            { "grb", "Grebo" },
            { "grc", "Ancient Greek" },
            { "gsw", "Swiss German" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Hawaiian" },
            { "hil", "Hiligaynon" },
            { "him", "Himachali" },
            { "hit", "Hittite" },
            { "hmn", "Hmong" },
            { "hsb", "Upper Sorbian" },
            { "hup", "Hupa" },
            { "iba", "Iban" },
            { "ijo", "Ijo" },
            { "ilo", "Iloko" },
            { "inc", "Indic Language" },
            { "ine", "Indo-European Language" },
            { "inh", "Ingush" },
            { "ira", "Iranian Language" },
            { "iro", "Iroquoian Language" },
            { "jbo", "Lojban" },
            { "jmc", "Machame" },
            { "jpr", "Judeo-Persian" },
            { "jrb", "Judeo-Arabic" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kar", "Karen" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardian" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kha", "Khasi" },
            { "khi", "Khoisan Language" },
            { "kho", "Khotanese" },
            { "khq", "Koyra Chiini" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kos", "Kosraean" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelian" },
            { "kro", "Kru" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Colognian" },
            { "kum", "Kumyk" },
            { "kut", "Kutenai" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Lezghian" },
            { "lol", "Mongo" },
            { "loz", "Lozi" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Lushai" },
            { "luy", "Luyia" },
            { "mad", "Madurese" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "man", "Mandingo" },
            { "map", "Austronesian Language" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Middle Irish" },
            { "mgh", "Makhuwa-Meetto" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mis", "Miscellaneous Language" },
            { "mkh", "Mon-Khmer Language" },
            { "mnc", "Manchu" },
            { "mni", "Manipuri" },
            { "mno", "Manobo Language" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Multiple Languages" },
            { "mun", "Munda Language" },
            { "mus", "Creek" },
            { "mwl", "Mirandese" },
            { "mwr", "Marwari" },
            { "myn", "Mayan Language" },
            { "myv", "Erzya" },
            { "nah", "Nahuatl" },
            { "nai", "North American Indian Language" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Low German" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "nic", "Niger-Kordofanian Language" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nog", "Nogai" },
            { "non", "Old Norse" },
            { "nqo", "N\u2019Ko" },
            { "nso", "Northern Sotho" },
            { "nub", "Nubian Language" },
            { "nus", "Nuer" },
            { "nwc", "Classical Newari" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osage" },
            { "ota", "Ottoman Turkish" },
            { "oto", "Otomian Language" },
            { "paa", "Papuan Language" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "peo", "Old Persian" },
            { "phi", "Philippine Language" },
            { "phn", "Phoenician" },
            { "pon", "Pohnpeian" },
            { "pra", "Prakrit Language" },
            { "pro", "Old Proven\u00e7al" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "roa", "Romance Language" },
            { "rof", "Rombo" },
            { "rom", "Romany" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "sai", "South American Indian Language" },
            { "sal", "Salishan Language" },
            { "sam", "Samaritan Aramaic" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "sbp", "Sangu" },
            { "scn", "Sicilian" },
            { "sco", "Scots" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sel", "Selkup" },
            { "sem", "Semitic Language" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Old Irish" },
            { "sgn", "Sign Language" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "sid", "Sidamo" },
            { "sio", "Siouan Language" },
            { "sit", "Sino-Tibetan Language" },
            { "sla", "Slavic Language" },
            { "sma", "Southern Sami" },
            { "smi", "Sami Language" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "sog", "Sogdien" },
            { "son", "Songhai" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer" },
            { "ssa", "Nilo-Saharan Language" },
            { "ssy", "Saho" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "Sumerian" },
            { "swb", "Comorian" },
            { "swc", "Congo Swahili" },
            { "syc", "Classical Syriac" },
            { "syr", "Syriac" },
            { "tai", "Tai Language" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetum" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelau" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "tsi", "Tsimshian" },
            { "tum", "Tumbuka" },
            { "tup", "Tupi Language" },
            { "tut", "Altaic Language" },
            { "tvl", "Tuvalu" },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinian" },
            { "tzm", "Central Morocco Tamazight" },
            { "udm", "Udmurt" },
            { "uga", "Ugaritic" },
            { "umb", "Umbundu" },
            { "und", "Unknown Language" },
            { "vai", "Vai" },
            { "vot", "Votic" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wak", "Wakashan Language" },
            { "wal", "Walamo" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "wen", "Sorbian Language" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapese" },
            { "yav", "Yangben" },
            { "ypk", "Yupik Language" },
            { "yue", "Cantonese" },
            { "zap", "Zapotec" },
            { "zbl", "Blissymbols" },
            { "zen", "Zenaga" },
            { "znd", "Zande" },
            { "zun", "Zuni" },
            { "zxx", "No linguistic content" },
            { "zza", "Zaza" },
            { "Arab", "Arabic" },
            { "Armi", "Imperial Aramaic" },
            { "Armn", "Armenian" },
            { "Avst", "Avestan" },
            { "Bali", "Balinese" },
            { "Bamu", "Bamum" },
            { "Batk", "Batak" },
            { "Beng", "Bengali" },
            { "Blis", "Blissymbols" },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", "Buginese" },
            { "Buhd", "Buhid" },
            { "Cakm", "Chakma" },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "Cari", "Carian" },
            { "Cham", "Cham" },
            { "Cher", "Cherokee" },
            { "Cirt", "Cirth" },
            { "Copt", "Coptic" },
            { "Cprt", "Cypriot" },
            { "Cyrl", "Cyrillic" },
            { "Cyrs", "Old Church Slavonic Cyrillic" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Egyd", "Egyptian demotic" },
            { "Egyh", "Egyptian hieratic" },
            { "Egyp", "Egyptian hieroglyphs" },
            { "Ethi", "Ethiopic" },
            { "Geok", "Georgian Khutsuri" },
            { "Geor", "Georgian" },
            { "Glag", "Glagolitic" },
            { "Goth", "Gothic" },
            { "Gran", "Grantha" },
            { "Grek", "Greek" },
            { "Gujr", "Gujarati" },
            { "Guru", "Gurmukhi" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Simplified" },
            { "Hant", "Traditional" },
            { "Hebr", "Hebrew" },
            { "Hira", "Hiragana" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Japanese syllabaries" },
            { "Hung", "Old Hungarian" },
            { "Inds", "Indus" },
            { "Ital", "Old Italic" },
            { "Java", "Javanese" },
            { "Jpan", "Japanese" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Khoj", "Khojki" },
            { "Knda", "Kannada" },
            { "Kore", "Korean" },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latf", "Fraktur Latin" },
            { "Latg", "Gaelic Latin" },
            { "Latn", "Latin" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Lyci", "Lycian" },
            { "Lydi", "Lydian" },
            { "Mand", "Mandaean" },
            { "Mani", "Manichaean" },
            { "Maya", "Mayan hieroglyphs" },
            { "Merc", "Meroitic Cursive" },
            { "Mero", "Meroitic" },
            { "Mlym", "Malayalam" },
            { "Mong", "Mongolian" },
            { "Moon", "Moon" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Myanmar" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", "N\u2019Ko" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", "Oriya" },
            { "Osma", "Osmanya" },
            { "Perm", "Old Permic" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inscriptional Pahlavi" },
            { "Phlp", "Psalter Pahlavi" },
            { "Phlv", "Book Pahlavi" },
            { "Phnx", "Phoenician" },
            { "Plrd", "Pollard Phonetic" },
            { "Prti", "Inscriptional Parthian" },
            { "Rjng", "Rejang" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runic" },
            { "Samr", "Samaritan" },
            { "Sara", "Sarati" },
            { "Sarb", "Old South Arabian" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shavian" },
            { "Sinh", "Sinhala" },
            { "Sund", "Sundanese" },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Syriac" },
            { "Syre", "Estrangelo Syriac" },
            { "Syrj", "Western Syriac" },
            { "Syrn", "Eastern Syriac" },
            { "Tagb", "Tagbanwa" },
            { "Tale", "Tai Le" },
            { "Talu", "New Tai Lue" },
            { "Taml", "Tamil" },
            { "Tavt", "Tai Viet" },
            { "Telu", "Telugu" },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Thai", "Thai" },
            { "Tibt", "Tibetan" },
            { "Tirh", "Tirhuta" },
            { "Ugar", "Ugaritic" },
            { "Vaii", "Vai" },
            { "Visp", "Visible Speech" },
            { "Wara", "Varang Kshiti" },
            { "Xpeo", "Old Persian" },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "Yiii", "Yi" },
            { "Zinh", "Inherited" },
            { "Zmth", "Mathematical Notation" },
            { "Zsym", "Symbols" },
            { "Zxxx", "Unwritten" },
            { "Zyyy", "Common" },
            { "Zzzz", "Unknown Script" },
            { "root", "Root" },
            { "de_AT", "Austrian German" },
            { "de_CH", "Swiss High German" },
            { "en_AU", "Australian English" },
            { "en_CA", "Canadian English" },
            { "en_GB", "British English" },
            { "en_US", "U.S. English" },
            { "es_ES", "Iberian Spanish" },
            { "fr_CA", "Canadian French" },
            { "fr_CH", "Swiss French" },
            { "nl_BE", "Flemish" },
            { "pt_BR", "Brazilian Portuguese" },
            { "pt_PT", "Iberian Portuguese" },
            { "ar_001", "Modern Standard Arabic" },
            { "es_419", "Latin American Spanish" },
            { "zh_Hans", "Simplified Chinese" },
            { "zh_Hant", "Traditional Chinese" },
        };
        return data;
    }
}
